/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementsSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.extension.DeploymentEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.ConfigurableObjectOverviewForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DeploymentTestSuitesSection;
import org.eclipse.hyades.test.ui.internal.editor.util.DeploymentCompatibilityConverter;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class DeploymentForm
extends ConfigurableObjectOverviewForm {
    private int mapPageIndex;
    private NamedElementsSection artifactsSection;
    private NamedElementsSection locationsSection;
    private DeploymentTestSuitesSection testSuitesSection;

    public DeploymentForm(DeploymentEditorExtension deploymentEditorExtension, WidgetFactory widgetFactory) {
        super(deploymentEditorExtension, widgetFactory);
        this.setHeadingText(TestUIPlugin.getString("W_DEPLOYMENT"));
    }

    public void dispose() {
        if (this.artifactsSection != null) {
            this.artifactsSection.dispose();
            this.artifactsSection = null;
        }
        if (this.locationsSection != null) {
            this.locationsSection.dispose();
            this.locationsSection = null;
        }
        if (this.testSuitesSection != null) {
            this.testSuitesSection.dispose();
            this.testSuitesSection = null;
        }
        super.dispose();
    }

    public void setLocationPageIndex(int index) {
        this.mapPageIndex = index;
    }

    public Control createControl() {
        Control control = super.createControl();
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)(TestUIPlugin.getID() + ".depf0001"));
        return control;
    }

    protected void createEditorFormContents(Composite parent) {
        super.createEditorFormContents(parent);
        this.artifactsSection = new NamedElementsSection((IEditorExtension)this.getBaseEditorExtension(), this.mapPageIndex);
        this.registerSection(this.artifactsSection);
        this.artifactsSection.createControl(this.getRightColumnContainer(), this.factory, TestUIPlugin.getString("W_ARTIFACTS"), TestUIPlugin.getString("EDT_DEP_ART_DSC"));
        this.locationsSection = new NamedElementsSection((IEditorExtension)this.getBaseEditorExtension(), this.mapPageIndex);
        this.registerSection(this.locationsSection);
        this.locationsSection.createControl(this.getRightColumnContainer(), this.factory, TestUIPlugin.getString("W_LOCS"), TestUIPlugin.getString("EDT_DEP_LOC_DSC"));
        this.testSuitesSection = new DeploymentTestSuitesSection();
        this.registerSection(this.testSuitesSection);
        this.testSuitesSection.createControl(this.getRightColumnContainer(), this.factory, TestUIPlugin.getString("W_TST_SUITE"), TestUIPlugin.getString("EDT_DEP_TSUITE_DSC"));
    }

    protected void setGeneralInfoSectionHelp(Control control) {
        WorkbenchHelp.setHelp((Control)control, (String)(TestUIPlugin.getID() + ".depf0003"));
    }

    public void load() {
        super.load();
        boolean isOld = false;
        TPFDeployment deployment = (TPFDeployment)this.getDataObject();
        this.artifactsSection.initialize(this.getDataObject(), (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_Artifacts(), null);
        this.testSuitesSection.initialize(this.getDataObject(), (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_Artifacts(), null);
        if (!deployment.getLocations().isEmpty()) {
            boolean toConvert = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)TestUIPlugin.getString("DLG_UPGRADE_DEP"), (String)TestUIPlugin.getString("DLG_UPGRADE_DSC"));
            if (toConvert) {
                try {
                    DeploymentCompatibilityConverter.convert(deployment);
                    this.getBaseEditorExtension().markDirty();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                isOld = true;
            }
        }
        if (isOld) {
            this.locationsSection.initialize(this.getDataObject(), (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_Locations(), null);
        } else {
            this.locationsSection.initialize(this.getDataObject(), (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_RefLocations(), null);
        }
    }

    public void openLocationEditor(CFGLocation location) {
        Resource resource = location.eResource();
        TestUIUtil.openEditor(resource, "org.eclipse.hyades.test.ui.editor.LocationEditorPart", false);
    }
}

