/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.EditorSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.StructuredViewerPart;
import org.eclipse.hyades.test.ui.internal.model.ui.LocalTransfer;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public abstract class StructuredViewerSection
extends EditorSection {
    private StructuredViewerPart viewerPart;
    private boolean handleDefaultButton;

    protected StructuredViewerSection(EditorForm editorForm, String[] buttonLabels) {
        super(editorForm);
        this.setButtonLabels(buttonLabels);
    }

    protected StructuredViewerSection(EditorForm editorForm) {
        super(editorForm);
    }

    protected void setButtonLabels(String[] buttonLabels) {
        if (this.viewerPart != null) {
            return;
        }
        this.viewerPart = this.createViewerPart(buttonLabels);
        this.viewerPart.setMinimumSize(50, 50);
    }

    protected void setButtonLabels(String[] buttonLabels, String[] tooltips) {
        if (this.viewerPart != null) {
            return;
        }
        this.viewerPart = this.createViewerPart(buttonLabels, tooltips);
        this.viewerPart.setMinimumSize(50, 50);
    }

    public void dispose() {
        this.viewerPart = null;
        super.dispose();
    }

    protected void setHandleDefaultButton(boolean handle) {
        this.handleDefaultButton = handle;
    }

    protected boolean isHandlingDefaultButton() {
        return this.handleDefaultButton;
    }

    protected abstract StructuredViewerPart createViewerPart(String[] var1);

    protected StructuredViewerPart createViewerPart(String[] buttonLabels, String[] toolTips) {
        return null;
    }

    protected StructuredViewerPart getViewerPart() {
        return this.viewerPart;
    }

    public void setFocus() {
        this.getViewerPart().getViewer().getControl().setFocus();
    }

    protected Composite createClientContainer(Composite parent, int span, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.numColumns = span;
        container.setLayout((Layout)layout);
        return container;
    }

    protected void createViewerPartControl(Composite parent, int style, int span, FormWidgetFactory factory) {
        this.viewerPart.createControl(parent, style, span, factory);
        this.createActions();
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                StructuredViewerSection.this.fillContextMenu(menuManager);
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        Control control = this.viewerPart.getControl();
        Menu menu = popupMenuManager.createContextMenu(control);
        control.setMenu(menu);
        control.getAccessible().addAccessibleListener((AccessibleListener)this);
    }

    protected void createActions() {
    }

    public void setInput(Object object) {
        this.getViewerPart().getViewer().setInput(object);
        if (object != null) {
            this.updateActionsAndButtons((IStructuredSelection)new StructuredSelection(object));
        } else {
            this.updateActionsAndButtons((IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    public Object getInput() {
        return this.getViewerPart().getViewer().getInput();
    }

    public IStructuredSelection getStructuredSelection() {
        return (IStructuredSelection)this.getViewerPart().getViewer().getSelection();
    }

    public void selectReveal(ISelection selection) {
        if (UIUtil.areEquals((ISelection)this.getStructuredSelection(), (ISelection)selection)) {
            return;
        }
        this.getViewerPart().getViewer().setSelection(selection, true);
    }

    protected void fillContextMenu(IMenuManager menuManager) {
    }

    protected void entryModified(Object entry, String value) {
    }

    protected void selectionChanged(IStructuredSelection structuredSelection) {
        this.fireSelectionNotification(structuredSelection);
        this.getHyadesEditorPart().setSelection((ISelection)structuredSelection);
        this.updateActionsAndButtons(structuredSelection);
    }

    protected void handleDoubleClick(IStructuredSelection structuredSelection) {
    }

    protected void buttonSelected(int index) {
    }

    protected void updateActionsAndButtons(IStructuredSelection structuredSelection) {
    }

    protected void doPaste() {
        LocalTransfer localTransfer;
        IStructuredSelection structuredSelection = this.getStructuredSelection();
        if (structuredSelection.size() > 1) {
            return;
        }
        Object target = structuredSelection.getFirstElement();
        Clipboard clipboard = this.getClipboard();
        Object[] objects = (Object[])clipboard.getContents((Transfer)(localTransfer = LocalTransfer.getInstance()));
        if (objects != null && objects.length > 0) {
            this.doPaste(target, objects);
        }
    }

    protected void doPaste(Object target, Object[] objects) {
    }

    public boolean canPaste(Clipboard clipboard) {
        IStructuredSelection structuredSelection = this.getStructuredSelection();
        if (structuredSelection.size() > 1) {
            return false;
        }
        Object target = structuredSelection.getFirstElement();
        LocalTransfer modelTransfer = LocalTransfer.getInstance();
        Object[] objects = (Object[])clipboard.getContents((Transfer)modelTransfer);
        if (objects != null && objects.length > 0) {
            return this.canPaste(target, objects);
        }
        return false;
    }

    protected boolean canPaste(Object target, Object[] objects) {
        return false;
    }
}

