/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class ResourceUtil {
    static /* synthetic */ Class class$org$eclipse$hyades$test$ui$internal$model$ResourceUtil$ElementFactory;
    static /* synthetic */ Class class$org$eclipse$emf$ecore$resource$Resource;
    static /* synthetic */ Class class$org$eclipse$ui$IPersistableElement;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;
    static /* synthetic */ Class class$org$eclipse$ui$views$properties$IPropertySource;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ResourceAdaptable
    implements IAdaptable,
    IDisposable {
        private Resource resource;

        public ResourceAdaptable(Resource resource) {
            this.resource = resource;
        }

        public void dispose() {
            this.resource = null;
        }

        public Resource getResource() {
            return this.resource;
        }

        public Object getAdapter(Class adapter) {
            if ((class$org$eclipse$emf$ecore$resource$Resource == null ? (class$org$eclipse$emf$ecore$resource$Resource = ResourceUtil.class$("org.eclipse.emf.ecore.resource.Resource")) : class$org$eclipse$emf$ecore$resource$Resource).isAssignableFrom(adapter)) {
                return this.getResource();
            }
            if ((class$org$eclipse$ui$IPersistableElement == null ? (class$org$eclipse$ui$IPersistableElement = ResourceUtil.class$("org.eclipse.ui.IPersistableElement")) : class$org$eclipse$ui$IPersistableElement) == adapter) {
                return new PersistableElement(this.getResource());
            }
            IFile file = EMFUtil.getWorkspaceFile(this.getResource());
            if ((class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = ResourceUtil.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource).isAssignableFrom(adapter)) {
                return file;
            }
            if (file != null && (class$org$eclipse$ui$views$properties$IPropertySource == null ? (class$org$eclipse$ui$views$properties$IPropertySource = ResourceUtil.class$("org.eclipse.ui.views.properties.IPropertySource")) : class$org$eclipse$ui$views$properties$IPropertySource) == adapter) {
                return file.getAdapter(class$org$eclipse$ui$views$properties$IPropertySource == null ? (class$org$eclipse$ui$views$properties$IPropertySource = ResourceUtil.class$("org.eclipse.ui.views.properties.IPropertySource")) : class$org$eclipse$ui$views$properties$IPropertySource);
            }
            return null;
        }
    }

    public static class ElementFactory
    implements IElementFactory {
        public static final String TAG_FILE = "FILE";

        public static void save(IMemento memento, Resource resource) {
            memento.putString(TAG_FILE, EMFUtil.getFilePath(resource));
        }

        public IAdaptable createElement(IMemento memento) {
            String filePath = memento.getString(TAG_FILE);
            if (filePath == null) {
                return null;
            }
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(filePath);
            if (resource == null || resource.getType() != 1) {
                return null;
            }
            EObject[] eObjects = EMFUtil.load(null, (IFile)resource);
            if (eObjects.length > 0) {
                return new ResourceAdaptable(eObjects[0].eResource());
            }
            return null;
        }
    }

    public static class PersistableElement
    implements IPersistableElement,
    IDisposable {
        private Resource resource;

        public PersistableElement(Resource resource) {
            this.resource = resource;
        }

        public void dispose() {
            this.resource = null;
        }

        public String getFactoryId() {
            return (class$org$eclipse$hyades$test$ui$internal$model$ResourceUtil$ElementFactory == null ? (class$org$eclipse$hyades$test$ui$internal$model$ResourceUtil$ElementFactory = ResourceUtil.class$("org.eclipse.hyades.test.ui.internal.model.ResourceUtil$ElementFactory")) : class$org$eclipse$hyades$test$ui$internal$model$ResourceUtil$ElementFactory).getName();
        }

        public void saveState(IMemento memento) {
            ElementFactory.save(memento, this.resource);
        }
    }
}

