/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.ui.ChildrenSelectionAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class RemoveChildrenAction
extends ChildrenSelectionAction {
    private boolean saveChanges;
    private boolean showErrorDialog;
    private boolean unloadNotSavedResource;

    public RemoveChildrenAction(boolean saveChanges) {
        super(TestUIPlugin.getString("BTN_REMOVE"));
        this.saveChanges = saveChanges;
        if (saveChanges) {
            this.setText(TestUIPlugin.getString("LBL_DELETE"));
        }
        this.setToolTipText(this.getText());
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setHoverImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_HOVER"));
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection)) {
            return false;
        }
        if (this.getStructuredViewer() == null || this.getChildren().size() != 1) {
            return true;
        }
        return this.getStructuredViewer().getInput() != this.getChildren().get(0);
    }

    public void setUnloadNotSavedResource(boolean unloadNotSavedResource) {
        this.unloadNotSavedResource = unloadNotSavedResource;
    }

    public boolean isUnloadNotSavedResource() {
        return this.unloadNotSavedResource;
    }

    public boolean isSaveChanges() {
        return this.saveChanges;
    }

    public void setShowErrorDialog(boolean showErrorDialog) {
        this.showErrorDialog = showErrorDialog;
    }

    public boolean isShowErrorDialog() {
        return this.showErrorDialog;
    }

    public void run() {
        this.setActionPerformed(false);
        Set changedResources = this.breakFeatures(this.getStructuredSelection());
        if (changedResources.isEmpty()) {
            return;
        }
        List unsavedResources = this.saveResources(changedResources);
        changedResources.clear();
        if (unsavedResources.isEmpty()) {
            return;
        }
        this.handleUnsavedResources(unsavedResources);
        unsavedResources.clear();
    }

    protected Set breakFeatures(IStructuredSelection structuredSelection) {
        HashSet<Resource> changedResources = new HashSet<Resource>();
        Iterator i = structuredSelection.iterator();
        while (i.hasNext()) {
            EObject eObject = (EObject)i.next();
            Resource[] resources = EMFUtil.remove(eObject);
            if (resources.length > 0) {
                this.setActionPerformed(true);
            }
            if (!this.isSaveChanges()) continue;
            changedResources.addAll(Arrays.asList(resources));
        }
        this.adjustStructuredViewer();
        this.getChildren().clear();
        return changedResources;
    }

    protected void adjustStructuredViewer() {
    }

    protected List saveResources(Set changedResources) {
        ArrayList<Resource> unsavedResources = new ArrayList<Resource>();
        Iterator i = changedResources.iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            try {
                EMFUtil.save(resource);
            }
            catch (Exception e) {
                TestUIPlugin.logError(e);
                unsavedResources.add(resource);
            }
        }
        return unsavedResources;
    }

    protected void handleUnsavedResources(List unsavedResources) {
        if (this.isShowErrorDialog()) {
            StringBuffer filePaths = new StringBuffer();
            Iterator i = unsavedResources.iterator();
            while (i.hasNext()) {
                Resource resource = (Resource)i.next();
                filePaths.append("\n").append(EMFUtil.getFilePath(resource));
            }
            String message = TestUIPlugin.getString("_ERROR_RESS_SAVE", filePaths.toString());
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)TestUIPlugin.getString("W_ERROR"), (String)message);
        }
        if (this.isUnloadNotSavedResource()) {
            Iterator i = unsavedResources.iterator();
            while (i.hasNext()) {
                Resource resource = (Resource)i.next();
                resource.unload();
            }
        }
    }
}

