/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorConverter;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorFilter;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorProvider;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileFactoryManager;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class TestNavigatorProvider
implements ITreeContentProvider,
ILabelProvider,
ILabelProviderListener {
    private Map visibleElementFromFile = new HashMap();
    private Map visibleElementFromObject = new HashMap();
    private Map convertedObjects = new HashMap();
    private List filters;
    private List listeners = new LinkedList();
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public TestNavigatorProvider() {
        this.filters = new LinkedList();
    }

    public void addVisibleFile(String extName, IHyadesTestNavigatorProvider provider, IHyadesTestNavigatorConverter converter) {
        if (extName.startsWith(".")) {
            extName = extName.substring(1);
        }
        if (this.visibleElementFromFile.containsKey(extName)) {
            TestUIPlugin.logInfo("Extension file: '." + extName + "' can't be registered as a visible element in the Test Navigator due to a previous registration by another plug-in");
            return;
        }
        if (provider != null) {
            provider.addListener(this);
        }
        this.visibleElementFromFile.put(extName, new fileExtensionElement(provider, converter));
    }

    public void addVisibleObject(String objectName, IHyadesTestNavigatorProvider provider) {
        if (this.visibleElementFromObject.containsKey(objectName)) {
            TestUIPlugin.logInfo("Extension file: '." + objectName + "' can't be registered as a visible element in the Test Navigator due to a previous registration by another plug-in");
            return;
        }
        this.visibleElementFromObject.put(objectName, provider);
        provider.addListener(this);
    }

    public void addFilter(IHyadesTestNavigatorFilter filter) {
        this.filters.add(filter);
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        if (element instanceof IProxyNode) {
            return ((IProxyNode)element).getParent();
        }
        if (element instanceof IProxyNode) {
            IProxyNode proxy = (IProxyNode)element;
            return proxy.getParent();
        }
        IHyadesTestNavigatorProvider provider = (IHyadesTestNavigatorProvider)this.visibleElementFromObject.get(element.getClass().getName());
        if (provider != null) {
            return provider.getParent(element);
        }
        return null;
    }

    private IHyadesTestNavigatorProvider getProviderFromFile(IFile file) {
        fileExtensionElement fileExt;
        String fileExtension = file.getFileExtension();
        if (fileExtension != null && (fileExt = (fileExtensionElement)this.visibleElementFromFile.get(fileExtension)) != null) {
            return fileExt.getProvider();
        }
        return null;
    }

    public IHyadesTestNavigatorConverter getConverterFromFile(IFile file) {
        fileExtensionElement fileExt;
        String fileExtension = file.getFileExtension();
        if (fileExtension != null && (fileExt = (fileExtensionElement)this.visibleElementFromFile.get(fileExtension)) != null) {
            return fileExt.getConverter();
        }
        return null;
    }

    private IHyadesTestNavigatorProvider getProviderFromObject(Object object) {
        return (IHyadesTestNavigatorProvider)this.visibleElementFromObject.get(object);
    }

    private boolean filter(Object element) {
        if (element == null) {
            return true;
        }
        Iterator it = this.filters.iterator();
        while (it.hasNext()) {
            IHyadesTestNavigatorFilter filter = (IHyadesTestNavigatorFilter)it.next();
            if (!filter.isFiltered(element)) continue;
            return true;
        }
        return false;
    }

    private Object[] filterChildren(Object[] children) {
        if (children == null) {
            return new Object[0];
        }
        LinkedList<Object> res = new LinkedList<Object>();
        int i = 0;
        while (i < children.length) {
            if (!this.filter(children[i])) {
                res.add(children[i]);
            }
            ++i;
        }
        return res.toArray();
    }

    public boolean hasChildren(Object parentElement) {
        if (parentElement == null) {
            return false;
        }
        if (parentElement instanceof IContainer) {
            IContainer container = (IContainer)parentElement;
            if (!container.exists()) {
                return false;
            }
            IResource[] resources = null;
            try {
                resources = container.members();
            }
            catch (CoreException e) {
                TestUIPlugin.logError(e);
                return false;
            }
            int i = 0;
            while (i < resources.length) {
                String fileExtension;
                if (resources[i].getType() != 1 ? !this.filter(resources[i]) : (fileExtension = resources[i].getFileExtension()) != null && this.isVisibleResource(resources[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (parentElement instanceof IFile) {
            IFile res = (IFile)parentElement;
            IHyadesTestNavigatorProvider provider = this.getProviderFromFile(res);
            if (provider != null) {
                return this.filterChildren(provider.getChildren(res)).length > 0;
            }
        } else {
            if (parentElement instanceof IProxyNode) {
                IProxyNode proxy = (IProxyNode)parentElement;
                return proxy.getChildren().length > 0;
            }
            IHyadesTestNavigatorProvider provider = (IHyadesTestNavigatorProvider)this.visibleElementFromObject.get(parentElement.getClass().getName());
            if (provider != null) {
                return this.filterChildren(provider.getChildren(parentElement)).length > 0;
            }
        }
        return false;
    }

    public boolean isVisibleResource(IResource resource) {
        if (resource.getType() != 1) {
            return !this.filter(resource);
        }
        String fileExtension = resource.getFileExtension();
        if (fileExtension != null) {
            return FileFactoryManager.getInstance().isRegistered(fileExtension) && !this.filter(resource);
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IContainer) {
            return this.getContainerChildren(parentElement);
        }
        if (parentElement instanceof IFile) {
            IFile res = (IFile)parentElement;
            IHyadesTestNavigatorProvider provider = this.getProviderFromFile(res);
            if (provider != null) {
                return this.filterChildren(provider.getChildren(res));
            }
        } else {
            if (parentElement instanceof IProxyNode) {
                IProxyNode proxy = (IProxyNode)parentElement;
                return proxy.getChildren();
            }
            IHyadesTestNavigatorProvider provider = (IHyadesTestNavigatorProvider)this.visibleElementFromObject.get(parentElement.getClass().getName());
            if (provider != null) {
                return this.filterChildren(provider.getChildren(parentElement));
            }
        }
        return new Object[0];
    }

    private Object[] getContainerChildren(Object parentElement) {
        UniqueEList children = new UniqueEList();
        IResource[] resources = null;
        try {
            resources = ((IContainer)parentElement).members();
        }
        catch (CoreException e) {
            TestUIPlugin.logError(e);
            return new Object[0];
        }
        int i = 0;
        int maxi = resources.length;
        while (i < maxi) {
            if (!this.filter(resources[i])) {
                if (resources[i].getType() != 1) {
                    children.add(resources[i]);
                } else {
                    Object node = this.getFileNode((IFile)resources[i]);
                    if (!this.filter(node)) {
                        children.add(node);
                    }
                }
            }
            ++i;
        }
        return children.toArray();
    }

    private Object getFileNode(IFile file) {
        Object node = null;
        node = FileProxyManager.getInstance().getProxy(file);
        if (node == null) {
            IHyadesTestNavigatorProvider provider = this.getProviderFromFile(file);
            if (provider != null) {
                node = file;
            } else {
                IHyadesTestNavigatorConverter converter = this.getConverterFromFile(file);
                if (converter != null && !this.filter(node = converter.getObjectFromResource((IResource)file))) {
                    this.addCorrespondingObjectFromFile((IResource)file, node);
                }
            }
        }
        return node;
    }

    private IWorkbenchAdapter getWorkbenchAdapter(Object object) {
        IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(object, class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = TestNavigatorProvider.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter);
        if (workbenchAdapter == this) {
            return null;
        }
        return workbenchAdapter;
    }

    public Image getImage(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof IContainer) {
            ImageDescriptor descriptor;
            IWorkbenchAdapter workbenchAdapter = this.getWorkbenchAdapter(element);
            if (workbenchAdapter != null && (descriptor = workbenchAdapter.getImageDescriptor(element)) != null) {
                return descriptor.createImage();
            }
        } else if (element instanceof IFile) {
            IHyadesTestNavigatorProvider provider = this.getProviderFromFile((IFile)element);
            if (provider != null) {
                return provider.getImage(element);
            }
        } else {
            if (element instanceof IProxyNode) {
                return ((IProxyNode)element).getImage();
            }
            IHyadesTestNavigatorProvider provider = (IHyadesTestNavigatorProvider)this.visibleElementFromObject.get(element.getClass().getName());
            if (provider != null) {
                return provider.getImage(element);
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (element == null) {
            return "";
        }
        if (element instanceof IContainer) {
            IWorkbenchAdapter workbenchAdapter = this.getWorkbenchAdapter(element);
            if (workbenchAdapter != null) {
                return workbenchAdapter.getLabel(element);
            }
        } else if (element instanceof IFile) {
            IHyadesTestNavigatorProvider provider = this.getProviderFromFile((IFile)element);
            if (provider != null) {
                return provider.getText(element);
            }
        } else {
            if (element instanceof IProxyNode) {
                return ((IProxyNode)element).getText();
            }
            IHyadesTestNavigatorProvider provider = (IHyadesTestNavigatorProvider)this.visibleElementFromObject.get(element.getClass().getName());
            if (provider != null) {
                return provider.getText(element);
            }
        }
        return "";
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IWorkspaceRoot) {
            IProject[] projects = ((IWorkspaceRoot)inputElement).getProjects();
            LinkedList<IProject> visibleProjects = new LinkedList<IProject>();
            int i = 0;
            while (i < projects.length) {
                if (!this.filter(projects[i])) {
                    visibleProjects.add(projects[i]);
                }
                ++i;
            }
            return visibleProjects.toArray();
        }
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (!this.listeners.remove(listener)) {
            TestUIPlugin.logInfo("Unable to remove listener '" + listener.toString());
        }
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ILabelProviderListener listener = (ILabelProviderListener)it.next();
            listener.labelProviderChanged(event);
        }
    }

    public String[] getVisibleFiles() {
        Set s = this.visibleElementFromFile.keySet();
        String[] res = new String[s.size()];
        int i = 0;
        Iterator it = s.iterator();
        while (it.hasNext()) {
            res[i] = (String)it.next();
            ++i;
        }
        return res;
    }

    public Object getCorrespondingObjectFromFile(IResource resource) {
        return this.convertedObjects.get(resource);
    }

    public void cleanConvertedObjectEntryFor(IResource resource) {
        if (this.convertedObjects.containsKey(resource)) {
            this.convertedObjects.remove(resource);
        }
    }

    public void addCorrespondingObjectFromFile(IResource resource, Object convertedObject) {
        if (resource != null && convertedObject != null) {
            this.convertedObjects.put(resource, convertedObject);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class fileExtensionElement {
        private IHyadesTestNavigatorProvider provider;
        private IHyadesTestNavigatorConverter converter;

        public fileExtensionElement(IHyadesTestNavigatorProvider provider, IHyadesTestNavigatorConverter converter) {
            this.provider = provider;
            this.converter = converter;
        }

        public IHyadesTestNavigatorConverter getConverter() {
            return this.converter;
        }

        public IHyadesTestNavigatorProvider getProvider() {
            return this.provider;
        }
    }
}

