/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorProvider;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.ui.ITypeProviderFactory;
import org.eclipse.hyades.test.ui.internal.model.ui.VisibleTypes;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class ExecutionResultHTNProvider
implements IHyadesTestNavigatorProvider,
IExecutableExtension {
    private ITypeProviderFactory typeProvidersFactory;

    public ExecutionResultHTNProvider() {
        this.typeProvidersFactory = VisibleTypes.getInstance();
    }

    public ExecutionResultHTNProvider(ITypeProviderFactory factory) {
        this.typeProvidersFactory = factory;
    }

    public void dispose() {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TPFExecutionResult) {
            TPFExecutionResult result = (TPFExecutionResult)parentElement;
            IHyadesTestNavigatorProvider provider = this.typeProvidersFactory.getProvider(result.getType());
            if (provider != null) {
                return provider.getChildren(result);
            }
            TPFExecutionHistory history = result.getExecutionHistory();
            if (history == null) {
                return new Object[0];
            }
            EList events = history.getExecutionEvents();
            ArrayList results = new ArrayList();
            Iterator it = events.iterator();
            while (it.hasNext()) {
                TPFExecutionEvent element = (TPFExecutionEvent)it.next();
                this.collectExecutionResults(element, results);
            }
            return results.toArray();
        }
        return new Object[0];
    }

    private void collectExecutionResults(TPFExecutionEvent event, List list) {
        if (event instanceof TPFInvocationEvent) {
            TPFInvocationEvent invok = (TPFInvocationEvent)event;
            list.add(invok.getInvokedExecutionResult());
        } else {
            Iterator it = event.getChildren().iterator();
            while (it.hasNext()) {
                TPFExecutionEvent element = (TPFExecutionEvent)it.next();
                this.collectExecutionResults(element, list);
            }
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Image getImage(Object element) {
        TPFExecutionResult result;
        IHyadesTestNavigatorProvider provider;
        if (element instanceof TPFExecutionResult && (provider = this.typeProvidersFactory.getProvider((result = (TPFExecutionResult)element).getType())) != null) {
            return provider.getImage(result);
        }
        return TestUIImages.INSTANCE.getImage("execution_obj.gif");
    }

    public Object getParent(Object element) {
        if (element instanceof TPFExecutionResult) {
            TPFExecutionResult executionResult = (TPFExecutionResult)element;
            IHyadesTestNavigatorProvider provider = this.typeProvidersFactory.getProvider(executionResult.getType());
            if (provider != null) {
                return provider.getParent(executionResult);
            }
            if (executionResult.getInvocationExecutionEvent() == null) {
                return EMFUtil.getParent(EMFUtil.getResource(null, (EObject)executionResult));
            }
            TPFInvocationEvent event = executionResult.getInvocationExecutionEvent();
            while (event.getParent() != null) {
                event = event.getParent();
            }
            return event.getExecutionHistory().getExecutionResult();
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof TPFExecutionResult) {
            TPFExecutionResult executionResult = (TPFExecutionResult)element;
            IHyadesTestNavigatorProvider provider = this.typeProvidersFactory.getProvider(executionResult.getType());
            if (provider != null) {
                return provider.getText(executionResult);
            }
            String name = executionResult.getName() != null ? executionResult.getName() : "unamed";
            if (executionResult.getTest() != null && executionResult.getTest().getName() != null) {
                name = name + " [" + executionResult.getTest().getName() + "]";
            }
            return name;
        }
        return "";
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TPFExecutionResult) {
            TPFExecutionResult result = (TPFExecutionResult)element;
            IHyadesTestNavigatorProvider provider = this.typeProvidersFactory.getProvider(result.getType());
            if (provider != null) {
                return provider.hasChildren(result);
            }
            TPFExecutionHistory history = result.getExecutionHistory();
            if (history == null) {
                return false;
            }
            EList events = history.getExecutionEvents();
            ArrayList results = new ArrayList();
            Iterator it = events.iterator();
            while (it.hasNext()) {
                TPFExecutionEvent event = (TPFExecutionEvent)it.next();
                this.collectExecutionResults(event, results);
            }
            return !results.isEmpty();
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        TPFExecutionResult result;
        IHyadesTestNavigatorProvider provider;
        if (element instanceof TPFExecutionResult && (provider = this.typeProvidersFactory.getProvider((result = (TPFExecutionResult)element).getType())) != null) {
            return provider.isLabelProperty(result, property);
        }
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public int getVerdict(Object element) {
        if (element instanceof TPFExecutionResult) {
            TPFExecutionResult result = (TPFExecutionResult)element;
            IHyadesTestNavigatorProvider provider = this.typeProvidersFactory.getProvider(result.getType());
            if (provider != null) {
                return provider.getVerdict(result);
            }
            switch (result.getVerdict().getValue()) {
                case 3: {
                    return 3;
                }
                case 2: {
                    return 1;
                }
                case 0: {
                    return 4;
                }
                case 1: {
                    return 2;
                }
            }
            return 0;
        }
        return 0;
    }
}

