/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorProvider;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.ui.ITypeProviderFactory;
import org.eclipse.hyades.test.ui.internal.model.ui.VisibleTypes;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class TestSuiteHTNProvider
implements IHyadesTestNavigatorProvider {
    private ITypeProviderFactory typeProvidersFactory;

    public TestSuiteHTNProvider() {
        this.typeProvidersFactory = VisibleTypes.getInstance();
    }

    public TestSuiteHTNProvider(ITypeProviderFactory factory) {
        this.typeProvidersFactory = factory;
    }

    public void dispose() {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TPFTestSuite) {
            TPFTestSuite ts = (TPFTestSuite)parentElement;
            IHyadesTestNavigatorProvider provider = this.typeProvidersFactory.getProvider(ts.getType());
            if (provider != null) {
                return provider.getChildren(ts);
            }
            EList tcs = ts.getTestCases();
            Object[] ret = new Object[tcs.size()];
            int j = 0;
            Iterator it = tcs.iterator();
            while (it.hasNext()) {
                ret[j] = (TPFTestCase)it.next();
                ++j;
            }
            return ret;
        }
        return new Object[0];
    }

    public Object[] getElements(Object inputElement) {
        TPFTestSuite ts;
        IHyadesTestNavigatorProvider provider;
        if (inputElement instanceof TPFTestSuite && (provider = this.typeProvidersFactory.getProvider((ts = (TPFTestSuite)inputElement).getType())) != null) {
            return provider.getElements(ts);
        }
        return this.getChildren(inputElement);
    }

    public Image getImage(Object element) {
        if (element instanceof TPFTestSuite) {
            TPFTestSuite ts = (TPFTestSuite)element;
            IHyadesTestNavigatorProvider provider = this.typeProvidersFactory.getProvider(ts.getType());
            if (provider != null) {
                return provider.getImage(ts);
            }
            return TestUIImages.INSTANCE.getImage("testsuite_obj.gif");
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof TPFTestSuite) {
            TPFTestSuite ts = (TPFTestSuite)element;
            IHyadesTestNavigatorProvider provider = this.typeProvidersFactory.getProvider(ts.getType());
            if (provider != null) {
                return provider.getParent(ts);
            }
            EObject parent = ts.eContainer();
            if (parent == null || parent instanceof Resource) {
                Resource res = ts.eResource();
                return EMFUtil.getParent(res);
            }
            return parent;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof TPFTestSuite) {
            TPFTestSuite ts = (TPFTestSuite)element;
            IHyadesTestNavigatorProvider provider = this.typeProvidersFactory.getProvider(ts.getType());
            if (provider != null) {
                return provider.getText(ts);
            }
            return ts.getName();
        }
        return "";
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TPFTestSuite) {
            TPFTestSuite ts = (TPFTestSuite)element;
            IHyadesTestNavigatorProvider provider = this.typeProvidersFactory.getProvider(ts.getType());
            if (provider != null) {
                return provider.hasChildren(ts);
            }
            return ts.getTestCases().size() > 0;
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        TPFTestSuite ts;
        IHyadesTestNavigatorProvider provider;
        if (element instanceof TPFTestSuite && (provider = this.typeProvidersFactory.getProvider((ts = (TPFTestSuite)element).getType())) != null) {
            return provider.isLabelProperty(ts, property);
        }
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public int getVerdict(Object element) {
        TPFTestSuite ts;
        IHyadesTestNavigatorProvider provider;
        if (element instanceof TPFTestSuite && (provider = this.typeProvidersFactory.getProvider((ts = (TPFTestSuite)element).getType())) != null) {
            return provider.getVerdict(ts);
        }
        return 0;
    }
}

