/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.navigator.actions.IPaster;
import org.eclipse.swt.dnd.Clipboard;

public class PasteExtensionManager {
    private static PasteExtensionManager instance;
    private List strictPasters = new LinkedList();
    private List simplePasters = new LinkedList();

    public static PasteExtensionManager getInstance() {
        if (instance == null) {
            instance = new PasteExtensionManager();
        }
        return instance;
    }

    private PasteExtensionManager() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(TestUIPlugin.getID() + ".testNavigatorPasteExtension");
        if (extPoint != null) {
            IConfigurationElement[] members = extPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement element = members[i];
                if ("paster".equals(element.getName())) {
                    String target = element.getAttribute("target");
                    boolean strict = Boolean.getBoolean(element.getAttribute("strict"));
                    this.addPasteExtension(target, element, strict);
                }
                ++i;
            }
        }
    }

    private void addPasteExtension(String target, IConfigurationElement element, boolean strict) {
        PasterExtensionInfo info = new PasterExtensionInfo(target, strict, element);
        if (strict) {
            this.strictPasters.add(info);
        } else {
            this.simplePasters.add(info);
        }
    }

    public boolean isPasteAllowedFor(Clipboard clipboard, Object selection) {
        IPaster[] pasters = this.getPasters(selection);
        int i = 0;
        while (i < pasters.length) {
            IPaster paster = pasters[i];
            if (paster != null && paster.isPasteAllowedFor(clipboard, selection)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IPaster[] getPasters(Object selection) {
        if (selection != null) {
            LinkedList<IPaster> pasters = new LinkedList<IPaster>();
            Class<?> target = selection.getClass();
            Iterator it = this.strictPasters.iterator();
            while (it.hasNext()) {
                PasterExtensionInfo info = (PasterExtensionInfo)it.next();
                if (target != info.getTarget()) continue;
                pasters.add(info.getPaster());
            }
            Iterator it2 = this.simplePasters.iterator();
            while (it2.hasNext()) {
                PasterExtensionInfo info = (PasterExtensionInfo)it2.next();
                if (!info.getTarget().isAssignableFrom(target)) continue;
                pasters.add(info.getPaster());
            }
            return pasters.toArray(new IPaster[pasters.size()]);
        }
        return new IPaster[0];
    }

    static class PasterExtensionInfo {
        private boolean strict;
        private Class target;
        private IPaster paster;
        private IConfigurationElement element;

        public PasterExtensionInfo(String target, boolean strict, IConfigurationElement element) {
            this.strict = strict;
            try {
                this.target = Platform.getBundle((String)element.getDeclaringExtension().getNamespace()).loadClass(target);
            }
            catch (ClassNotFoundException e) {
                TestUIPlugin.logError(e);
            }
            this.element = element;
            this.paster = null;
        }

        public IPaster getPaster() {
            block2: {
                if (this.paster != null) break block2;
                try {
                    this.paster = (IPaster)this.element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    TestUIPlugin.logError(e);
                }
            }
            return this.paster;
        }

        public boolean isStrict() {
            return this.strict;
        }

        public Class getTarget() {
            return this.target;
        }
    }
}

