/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultExecutionResultProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultTestCaseProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultTestComponentlProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultTestSuiteProxyNode;
import org.eclipse.hyades.test.ui.navigator.IPersistableTypedElementProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypedElementProxyFactory;
import org.eclipse.ui.IMemento;

public class TypedElementFactoryManager {
    private static TypedElementFactoryManager instance;
    private HashMap factories = new HashMap();
    private HashMap types = new HashMap();

    public static TypedElementFactoryManager getInstance() {
        if (instance == null) {
            instance = new TypedElementFactoryManager();
        }
        return instance;
    }

    private TypedElementFactoryManager() {
        IConfigurationElement element;
        int i;
        IConfigurationElement[] members;
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(TestUIPlugin.getID() + ".testNavigatorTypedElementProxyFactory");
        if (extPoint != null) {
            members = extPoint.getConfigurationElements();
            i = 0;
            while (i < members.length) {
                element = members[i];
                if ("factory".equals(element.getName())) {
                    String id = element.getAttribute("id");
                    this.addFactory(id, element);
                } else if ("typedElement".equals(element.getName())) {
                    String type = element.getAttribute("type");
                    String factoryID = element.getAttribute("factoryID");
                    if (type != null && type.length() != 0) {
                        this.addType(type, factoryID);
                    }
                }
                ++i;
            }
        }
        if ((extPoint = Platform.getExtensionRegistry().getExtensionPoint(TestUIPlugin.getID() + ".testNavigatorTypedElementFactory")) != null) {
            members = extPoint.getConfigurationElements();
            i = 0;
            while (i < members.length) {
                String typeName;
                element = members[i];
                if ("typedElement".equals(element.getName()) && (typeName = element.getAttribute("type")) != null && typeName.length() != 0) {
                    String id = element.getAttribute("factory");
                    this.addFactory(id, element);
                    this.addType(typeName, id);
                }
                ++i;
            }
        }
    }

    private void addFactory(String id, IConfigurationElement element) {
        if (!this.factories.containsKey(id)) {
            this.factories.put(id, element);
        } else {
            TestUIPlugin.logInfo("ID: " + id + " already used in a previously registered factory");
        }
    }

    private void addType(String type, String factoryID) {
        if (!this.types.containsKey(type)) {
            this.types.put(type, factoryID);
        } else {
            TestUIPlugin.logInfo("type: " + type + " already registered");
        }
    }

    public ITypedElementProxyFactory getFactory(String typeName) {
        if (this.types.containsKey(typeName)) {
            return this.getFactoryFromID((String)this.types.get(typeName));
        }
        return null;
    }

    public ITypedElementProxyFactory getFactoryFromID(String factoryID) {
        Object value = this.factories.get(factoryID);
        if (value instanceof IConfigurationElement) {
            IConfigurationElement element = (IConfigurationElement)value;
            try {
                ITypedElementProxyFactory factory = null;
                factory = "factory".equals(element.getName()) ? (ITypedElementProxyFactory)element.createExecutableExtension("class") : (ITypedElementProxyFactory)element.createExecutableExtension("factory");
                return factory;
            }
            catch (CoreException e) {
                TestUIPlugin.logError(e);
                return new DefaultTypedElementFactory();
            }
        }
        if (value instanceof ITypedElementProxyFactory) {
            return (ITypedElementProxyFactory)value;
        }
        TestUIPlugin.logError("internal error");
        return null;
    }

    class DefaultTypedElementFactory
    implements IPersistableTypedElementProxyFactory {
        DefaultTypedElementFactory() {
        }

        public IProxyNode recreate(IMemento memento, Object parent) {
            String nodeKind = memento.getString("nodeKind");
            if (nodeKind.equals("testSuiteNode")) {
                return new DefaultTestSuiteProxyNode(memento, parent);
            }
            if (nodeKind.equals("testCaseNode")) {
                return new DefaultTestCaseProxyNode(memento, parent);
            }
            if (nodeKind.equals("executionResultNode")) {
                return new DefaultExecutionResultProxyNode(memento, parent);
            }
            if (nodeKind.equals("testComponentNode")) {
                return new DefaultTestComponentlProxyNode(memento, parent);
            }
            return null;
        }

        public IProxyNode create(TPFExecutionResult result, Object parent) {
            return new DefaultExecutionResultProxyNode(result, parent);
        }

        public IProxyNode create(TPFTest test, Object parent) {
            if (test instanceof TPFTestSuite) {
                return new DefaultTestSuiteProxyNode((TPFTestSuite)test, parent);
            }
            if (test instanceof TPFTestCase) {
                return new DefaultTestCaseProxyNode((TPFTestCase)test, parent);
            }
            return null;
        }

        public IProxyNode create(TPFTestComponent component, Object parent) {
            return new DefaultTestComponentlProxyNode(component, parent);
        }
    }
}

