/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.util.LocationUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.PartInitException;

public class LocationNewWizard
extends HyadesNewWizard {
    private CFGMachineConstraint newLocation;

    public LocationNewWizard() {
        this.setWindowTitle(TestUIPlugin.getString("WIZ_LOCATION_TTL"));
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("new_location_wiz.gif"));
        IDialogSettings dialogSettings = TestUIPlugin.getInstance().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection("LocationNewWizard");
        if (settings == null) {
            settings = dialogSettings.addNewSection("LocationNewWizard");
        }
        this.setDialogSettings(settings);
    }

    protected String getType() {
        return "org.eclipse.hyades.location.generic";
    }

    public String getFileExtension() {
        return "location";
    }

    public void addPages() {
        this.getLocationPage().setTitle(TestUIPlugin.getString("WIZ_LOCATION_GEN_PG_TTL"));
        this.getLocationPage().setDescription(TestUIPlugin.getString("WIZ_LOCATION_GEN_PG_LOC_DSC"));
        this.addPage((IWizardPage)this.getLocationPage());
        this.getAttributeWizardPage().setTitle(TestUIPlugin.getString("WIZ_LOCATION_GEN_PG_TTL"));
        this.getAttributeWizardPage().setDescription(TestUIPlugin.getString("WIZ_LOCATION_GEN_PG_ATT_DSC"));
        this.addPage((IWizardPage)this.getAttributeWizardPage());
    }

    protected boolean createObject(IFile file) throws Exception {
        String hostname = TestUIPlugin.getInstance().getPreferenceStore().getString("default_host_name");
        LocationUtil.createNew(file, this.getLocationPage().getItemName(), this.getAttributeWizardPage().getItemDescription(), hostname);
        return true;
    }

    protected void openEditor(IFile file) throws PartInitException {
        LocationUtil.openEditor(file);
    }

    public CFGLocation getNewLocation() {
        return this.newLocation;
    }
}

