/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.SaveUtil;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.help.WorkbenchHelp;

public class SaveAction
extends SelectionProviderAction
implements ISelectionChangedListener,
IRunnableWithProgress {
    private INavigator fViewer;
    private Object[] fSelections;
    private IResource fResSelection;
    private IResource[] fResSelections;
    private Shell fShell;

    public SaveAction(INavigator viewer) {
        super((ISelectionProvider)viewer.getViewer(), UIPlugin.getResourceString("SAVE"));
        this.setDescription(UIPlugin.getResourceString("SAVE"));
        PDPluginImages.setImageDescriptors((IAction)this, "lcl16", "save.gif");
        this.fViewer = viewer;
        WorkbenchHelp.setHelp((IAction)this, (String)(UIPlugin.getPluginId() + ".save0000"));
    }

    public void run() {
        String title = UIPlugin.getResourceString("TRACE_MSG");
        String msg = "";
        ISelection sel = this.getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return;
        }
        this.fSelections = ((IStructuredSelection)sel).toArray();
        this.fShell = this.fViewer.getViewSite().getShell();
        if (sel != null && !sel.isEmpty()) {
            msg = ((IStructuredSelection)sel).size() == 1 && ((IStructuredSelection)sel).getFirstElement() != null && ((IStructuredSelection)sel).getFirstElement() instanceof IProject ? UIPlugin.getResourceString("SAVE_PROJECT_Q") : UIPlugin.getResourceString("SAVE_RES_Q");
        }
        if (!MessageDialog.openQuestion((Shell)this.fShell, (String)UIPlugin.getResourceString("SAVTOLOCACT_DIA_TITLE"), (String)msg)) {
            return;
        }
        this.finishSaving(sel);
    }

    public void run(int result) {
        String title = UIPlugin.getResourceString("TRACE_MSG");
        String msg = "";
        ISelection sel = this.getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return;
        }
        this.fSelections = ((IStructuredSelection)sel).toArray();
        this.fShell = this.fViewer.getViewSite().getShell();
        if (sel != null && !sel.isEmpty() && result == 0) {
            this.finishSaving(sel);
        }
    }

    protected void finishSaving(ISelection sel) {
        int j = 0;
        int s = ((IStructuredSelection)sel).size();
        this.fResSelections = new IResource[s];
        Iterator iter = ((IStructuredSelection)sel).iterator();
        while (iter.hasNext()) {
            this.fResSelections[j++] = HyadesUtil.getSelectionFolder(iter.next());
        }
        this.fResSelection = this.fResSelections[0];
        try {
            new ProgressMonitorDialog(this.fShell).run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)this));
        }
        catch (InterruptedException e) {
            try {
                if (this.fResSelection != null && this.fResSelection.exists()) {
                    this.fResSelection.getProject().refreshLocal(2, null);
                }
            }
            catch (CoreException exc) {
                exc.printStackTrace();
            }
            this.fResSelection = null;
            this.fResSelections = null;
            return;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            this.fResSelection = null;
            this.fResSelections = null;
            return;
        }
        try {
            if (this.fResSelection != null && this.fResSelection.exists()) {
                this.fResSelection.getProject().refreshLocal(2, null);
            }
        }
        catch (CoreException exc) {
            exc.printStackTrace();
        }
        this.fResSelection = null;
        this.fResSelections = null;
    }

    protected INavigator getViewer() {
        return this.fViewer;
    }

    public ISelection getSelection() {
        return this.fViewer.getViewer().getSelection();
    }

    public void run(IProgressMonitor monitor) {
        SaveUtil.save(Arrays.asList(this.fSelections), monitor, this.fViewer.getID());
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(true);
    }

    public void dispose() {
        super.dispose();
        this.fViewer = null;
        this.fResSelection = null;
        this.fResSelections = null;
        this.fShell = null;
        this.fSelections = null;
    }
}

