/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.AgentAttribute;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileAttachDelegate;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.hyades.trace.ui.internal.util.CTree;
import org.eclipse.hyades.trace.ui.internal.util.ErrorItem;
import org.eclipse.hyades.trace.ui.internal.util.ProcessTreeItem;
import org.eclipse.hyades.trace.ui.internal.util.ProfilingAgentList;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class DoubleCTree
extends AbstractChangeable {
    Composite _group;
    Composite groupWidget;
    private CTree sourceList;
    private CTree targetList;
    private ProfilingAgentList sourceAgentList = new ProfilingAgentList();
    private ProfilingAgentList targetAgentList = new ProfilingAgentList();
    private boolean _needToResetAgentLists = false;
    private boolean _treesLoaded = false;
    public Label targetListLabel;
    public Label sourceListLabel;
    public Button add;
    public Button remove;
    public Button addAll;
    public Button removeAll;
    private WizardPage _wizardPage;
    private ILaunchConfiguration _conf;

    private boolean isRetrievingList() {
        Object[] items = this.sourceList.getItems();
        if (items.length == 0) {
            return false;
        }
        return items[0] instanceof IWorkbenchAdapter;
    }

    protected void addAgentsToTargetList(Object[] items) {
        ProcessTreeItem pti;
        if (this.isRetrievingList()) {
            return;
        }
        if (this.sourceList.getItemCount() > 0 && (pti = (ProcessTreeItem)this.sourceList.getItems()[0]).getData() instanceof ErrorItem) {
            return;
        }
        this.targetList.setRedraw(false);
        this.sourceList.setRedraw(false);
        Vector<Object> dataToBeSelected = new Vector<Object>();
        int i = 0;
        while (i < items.length) {
            if (this.vaildItemtoAdd(items[i])) {
                dataToBeSelected.addElement(items[i]);
                this.targetAgentList.addAgent((ProcessTreeItem)items[i]);
                this.sourceAgentList.removeAgent((ProcessTreeItem)items[i]);
            }
            ++i;
        }
        this.sourceList.resetTree(this.sourceAgentList);
        this.targetList.resetTree(this.targetAgentList);
        this.sourceList.clearSelection();
        if (dataToBeSelected.size() > 0) {
            this.targetList.setSelectionFromData(dataToBeSelected.toArray());
        }
        this.targetList.setRedraw(true);
        this.sourceList.setRedraw(true);
        if (this._wizardPage != null && this.getSelectedItems().length > 0) {
            this._wizardPage.setPageComplete(true);
        }
    }

    protected void removeAgentsFromTargetList(Object[] items) {
        if (this.isRetrievingList()) {
            return;
        }
        this.targetList.setRedraw(false);
        this.sourceList.setRedraw(false);
        int i = 0;
        while (i < items.length) {
            this.sourceAgentList.addAgent((ProcessTreeItem)items[i]);
            this.targetAgentList.removeAgent((ProcessTreeItem)items[i]);
            ++i;
        }
        this.targetList.clearSelection();
        if (this._wizardPage != null && this.getSelectedItems().length > 0) {
            this._wizardPage.setPageComplete(true);
        }
        this.sourceList.resetTree(this.sourceAgentList);
        this.targetList.resetTree(this.targetAgentList);
        this.targetList.setRedraw(true);
        this.sourceList.setRedraw(true);
    }

    private boolean vaildItemtoAdd(Object item) {
        return item != null && !(item instanceof IWorkbenchAdapter);
    }

    public Object[] getTargetItems() {
        return this.targetList.getItems();
    }

    public void removeAll() {
        this.sourceAgentList.initializeFromAgents(new Object[0]);
        this.targetAgentList.initializeFromAgents(new Object[0]);
        this.sourceList.setRedraw(false);
        this.targetList.setRedraw(false);
        this.sourceList.resetTree(this.sourceAgentList);
        this.targetList.resetTree(this.targetAgentList);
        this.sourceList.setRedraw(true);
        this.targetList.setRedraw(true);
    }

    public void setWizardPage(WizardPage wizardPage) {
        this._wizardPage = wizardPage;
    }

    public DoubleCTree(Composite parent, int style, String groupText, String sourceTextID, String targetTextID) {
        this._group = new Composite(parent, style);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = -10;
        layout.horizontalSpacing = 0;
        this._group.setLayout((Layout)layout);
        this._group.setLayoutData((Object)GridUtil.createFill());
        this.createDoubleTree(this._group, sourceTextID, targetTextID);
        this.add.addListener(13, (Listener)new ButtonListener());
        this.remove.addListener(13, (Listener)new ButtonListener());
        this.addAll.addListener(13, (Listener)new ButtonListener());
        this.removeAll.addListener(13, (Listener)new ButtonListener());
        this.sourceList.addSelectionListener(new TreeSelListener());
        this.targetList.addSelectionListener(new TreeSelListener());
    }

    public void createDoubleTree(Composite parent, String sourceTextID, String targetTextID) {
        this._conf = null;
        this.groupWidget = parent;
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.groupWidget.setLayout((Layout)layout);
        this.sourceList = new CTree(this.groupWidget, sourceTextID);
        Composite buttonWidget = new Composite(this.groupWidget, 0);
        GridLayout blayout = new GridLayout();
        blayout.numColumns = 1;
        buttonWidget.setLayout((Layout)blayout);
        Label label = new Label(buttonWidget, 8);
        label.setText("");
        GridData spec = new GridData();
        spec.grabExcessVerticalSpace = true;
        spec.verticalAlignment = 4;
        label.setLayoutData((Object)spec);
        this.add = new Button(buttonWidget, 8);
        this.add.setText(UIPlugin.getResourceString("LEFT_TO_RIGHT"));
        spec = new GridData();
        spec.horizontalAlignment = 4;
        this.add.setLayoutData((Object)spec);
        this.remove = new Button(buttonWidget, 8);
        this.remove.setText(UIPlugin.getResourceString("RIGHT_TO_LEFT"));
        spec = new GridData();
        spec.horizontalAlignment = 4;
        this.remove.setLayoutData((Object)spec);
        new Label(buttonWidget, 0);
        this.addAll = new Button(buttonWidget, 8);
        this.addAll.setText(UIPlugin.getResourceString("LEFT_ALL_TO_RIGHT"));
        spec = new GridData();
        spec.horizontalAlignment = 4;
        this.addAll.setLayoutData((Object)spec);
        this.removeAll = new Button(buttonWidget, 8);
        this.removeAll.setText(UIPlugin.getResourceString("RIGHT_ALL_TO_LEFT"));
        spec = new GridData();
        spec.horizontalAlignment = 4;
        this.removeAll.setLayoutData((Object)spec);
        Label label1 = new Label(buttonWidget, 8);
        label1.setText("");
        spec = new GridData();
        spec.grabExcessVerticalSpace = true;
        spec.verticalAlignment = 4;
        label.setLayoutData((Object)spec);
        this.targetList = new CTree(this.groupWidget, targetTextID);
        this.sourceList.setUIListener(new TreeUpdatedListener());
        this.targetList.setUIListener(new TreeUpdatedListener());
    }

    public Control getControl() {
        return this._group;
    }

    public Object[] getSelectedItems() {
        return this.targetList.getSelectedItems();
    }

    public Object[] getSelectedItemsForProfiling() {
        return this.targetList.getItems();
    }

    public Composite getWidget() {
        return this.groupWidget;
    }

    public void initializeLaunchConfiguration(ILaunchConfiguration conf) {
        this._conf = conf;
    }

    public void initialize() {
        this.sourceList.initializeTree(this._conf);
        this.sourceAgentList.initializeFromAgents(this.sourceList.getItems());
        this.targetAgentList.initializeFromAgents(this.targetList.getItems());
        this._needToResetAgentLists = true;
    }

    public List getAttributeAgents() {
        if (this._conf != null) {
            try {
                return ProfileAttachDelegate.getAttributeAgents(this._conf);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return new ArrayList();
    }

    public static List getAttributeAgents(Object[] agentItems) {
        ArrayList<AgentAttribute> list = new ArrayList<AgentAttribute>();
        int i = 0;
        while (i < agentItems.length) {
            ProcessTreeItem pti = (ProcessTreeItem)agentItems[i];
            String pid = pti.getProcessId();
            if (pid != null) {
                list.add(new AgentAttribute(pid, (Agent)pti.getData()));
            }
            ++i;
        }
        return list;
    }

    private AgentAttribute[] getTargetAgentList() {
        List attrAgList = this.treesLoaded() ? DoubleCTree.getAttributeAgents(this.getTargetItems()) : this.getAttributeAgents();
        AgentAttribute[] attrAgents = new AgentAttribute[attrAgList.size()];
        attrAgList.toArray(attrAgents);
        return attrAgents;
    }

    private AgentAttribute[] getTargetSelectedAgentList() {
        List attrAgList = this.treesLoaded() ? DoubleCTree.getAttributeAgents(this.getSelectedItems()) : this.getAttributeAgents();
        AgentAttribute[] attrAgents = new AgentAttribute[attrAgList.size()];
        attrAgList.toArray(attrAgents);
        return attrAgents;
    }

    public boolean treesLoaded() {
        return this._treesLoaded;
    }

    public void treesLoaded(boolean treesLoaded) {
        this._treesLoaded = treesLoaded;
    }

    public void resetAgentLists() {
        if (this.getControl().isDisposed()) {
            return;
        }
        if (this._needToResetAgentLists && (this.sourceList.getItemCount() == 0 || !this.isRetrievingList())) {
            ProcessTreeItem pti;
            this._needToResetAgentLists = false;
            this.sourceAgentList.initializeFromAgents(this.sourceList.getItems());
            if (this.sourceList.getItemCount() > 0 && (pti = (ProcessTreeItem)this.sourceList.getItems()[0]).getData() instanceof ErrorItem) {
                this.targetAgentList.initializeFromAgents(new Object[0]);
                this.targetList.resetTree(this.targetAgentList);
                return;
            }
            AgentAttribute[] targetAgentAttributeList = this.getTargetAgentList();
            AgentAttribute[] selectedTargetAgentAttributeList = this.getTargetSelectedAgentList();
            if (targetAgentAttributeList.length > 0) {
                Vector<ProcessTreeItem> agentsInTarget = new Vector<ProcessTreeItem>();
                Vector<ProcessTreeItem> dataToBeSelected = new Vector<ProcessTreeItem>();
                int i = 0;
                while (i < targetAgentAttributeList.length) {
                    ProcessTreeItem agentFromSource = this.sourceAgentList.getAgentForAgentAttribute(targetAgentAttributeList[i]);
                    if (agentFromSource != null) {
                        agentsInTarget.addElement(agentFromSource);
                        this.sourceAgentList.removeAgent(agentFromSource);
                        if (this.agentAttributeListContains(selectedTargetAgentAttributeList, agentFromSource)) {
                            dataToBeSelected.addElement(agentFromSource);
                        }
                    }
                    ++i;
                }
                this.targetAgentList.initializeFromAgents(agentsInTarget.toArray());
                this.sourceList.setRedraw(false);
                this.targetList.setRedraw(false);
                this.sourceList.resetTree(this.sourceAgentList);
                this.targetList.resetTree(this.targetAgentList);
                if (dataToBeSelected.size() > 0) {
                    this.targetList.setSelectionFromData(dataToBeSelected.toArray());
                }
                this.sourceList.setRedraw(true);
                this.targetList.setRedraw(true);
            } else {
                this.targetAgentList.initializeFromAgents(new Object[0]);
                this.targetList.resetTree(this.targetAgentList);
            }
            this._treesLoaded = true;
            this.changed();
        }
    }

    private boolean agentAttributeListContains(AgentAttribute[] attributes, ProcessTreeItem pti) {
        String pid = pti.getProcessId();
        String name = ((Agent)pti.getData()).getName();
        String type = ((Agent)pti.getData()).getType();
        int i = 0;
        while (i < attributes.length) {
            if (attributes[i].getPID().equals(pid) && attributes[i].getName().equals(name) && attributes[i].getType().equals(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    class ButtonListener
    implements Listener {
        ButtonListener() {
        }

        public void handleEvent(Event e) {
            DoubleCTree.this.sourceAgentList.initializeFromAgents(DoubleCTree.this.sourceList.getItems());
            if (e.widget == DoubleCTree.this.add) {
                DoubleCTree.this.addAgentsToTargetList(DoubleCTree.this.sourceList.getSelectedItems());
            } else if (e.widget == DoubleCTree.this.addAll) {
                DoubleCTree.this.addAgentsToTargetList(DoubleCTree.this.sourceList.getItems());
            } else if (e.widget == DoubleCTree.this.remove) {
                DoubleCTree.this.removeAgentsFromTargetList(DoubleCTree.this.targetList.getSelectedItems());
            } else if (e.widget == DoubleCTree.this.removeAll) {
                DoubleCTree.this.removeAgentsFromTargetList(DoubleCTree.this.targetList.getItems());
            }
            DoubleCTree.this.changed();
        }
    }

    class TreeSelListener
    implements SelectionListener {
        TreeSelListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            DoubleCTree.this.sourceAgentList.initializeFromAgents(DoubleCTree.this.sourceList.getItems());
            if (DoubleCTree.this.sourceList.hasWidget(e.widget) && DoubleCTree.this.sourceList.getSelectedItems().length != 0) {
                DoubleCTree.this.targetList.clearSelection();
            } else if (DoubleCTree.this.targetList.hasWidget(e.widget) && DoubleCTree.this.targetList.getSelectedItems().length != 0) {
                DoubleCTree.this.sourceList.clearSelection();
            }
            DoubleCTree.this.changed();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Object[] items;
            DoubleCTree.this.sourceAgentList.initializeFromAgents(DoubleCTree.this.sourceList.getItems());
            if (DoubleCTree.this.sourceList.hasWidget(e.widget)) {
                Object[] items2 = DoubleCTree.this.sourceList.getSelectedItems();
                if (items2.length > 0) {
                    DoubleCTree.this.addAgentsToTargetList(items2);
                    DoubleCTree.this.changed();
                }
            } else if (DoubleCTree.this.targetList.hasWidget(e.widget) && (items = DoubleCTree.this.targetList.getSelectedItems()).length > 0) {
                DoubleCTree.this.removeAgentsFromTargetList(items);
                DoubleCTree.this.changed();
            }
        }
    }

    class TreeUpdatedListener
    implements Listener {
        TreeUpdatedListener() {
        }

        public void handleEvent(Event event) {
            DoubleCTree.this.resetAgentLists();
        }
    }
}

