/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.wizard.NewNodeWizardPage;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenNodeWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenNodeWizardPage
extends NewNodeWizardPage
implements ModifyListener {
    protected int hourValue = 0;
    protected int minValue = 0;
    protected int secValue = 0;
    protected int micsecValue = 0;

    public OpenNodeWizardPage(String name) {
        super(name);
        this.setTitle(UIPlugin.getResourceString("NODE_PROPERTIES_TITLE"));
        this.setDescription(UIPlugin.getResourceString("NODE_PROPERTIES_DESC"));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this._nodeUI.setEnabled(false);
        this.populateData();
        this.setPageComplete(true);
        WorkbenchHelp.setHelp((Control)parent, (String)(UIPlugin.getPluginId() + ".onwp0000"));
    }

    public boolean finish() {
        TRCNode node = ((OpenNodeWizard)this.getWizard()).getNode();
        if (node == null) {
            return true;
        }
        if (node.getDeltaTime() != this._nodeUI.getDeltaTime()) {
            node.setDeltaTime(this._nodeUI.getDeltaTime());
            ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
            event.setSource(node);
            event.setType(2048);
            UIPlugin.getDefault().notifyProfileEventListener(event);
        }
        return true;
    }

    public void modifyText(ModifyEvent event) {
        block16: {
            block19: {
                block18: {
                    block17: {
                        block15: {
                            this.setPageComplete(true);
                            String port = this._nodeUI.getPortNumberUI().getText().trim();
                            if (event.widget != this._nodeUI.getPortNumberUI()) break block15;
                            try {
                                int value = Integer.parseInt(port);
                                if (value < 0) {
                                    this.setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
                                    this.setPageComplete(false);
                                    return;
                                }
                                this.setErrorMessage(null);
                                this.setPageComplete(true);
                            }
                            catch (NumberFormatException nfe) {
                                this.setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
                                this.setPageComplete(false);
                            }
                            break block16;
                        }
                        if (event.widget != this._nodeUI.getHourUI()) break block17;
                        try {
                            this.hourValue = Integer.parseInt(this._nodeUI.getHourUI().getText().trim());
                            this.setErrorMessage(null);
                            this.setPageComplete(this.canCompletePage());
                        }
                        catch (NumberFormatException e) {
                            if (this._nodeUI.getHourUI().getText().trim().equals("")) {
                                this.hourValue = 0;
                                this.setPageComplete(this.canCompletePage());
                                return;
                            }
                            String message = UIPlugin.getResourceString("INVALID_DELTA_FORMAT");
                            this.setErrorMessage(message);
                            this.setPageComplete(false);
                        }
                        break block16;
                    }
                    if (event.widget != this._nodeUI.getMinUI()) break block18;
                    try {
                        this.minValue = Integer.parseInt(this._nodeUI.getMinUI().getText().trim());
                        this.setPageComplete(this.canCompletePage());
                    }
                    catch (NumberFormatException e) {
                        if (this._nodeUI.getMinUI().getText().trim().equals("")) {
                            this.minValue = 0;
                            this.setPageComplete(this.canCompletePage());
                            return;
                        }
                        String message = UIPlugin.getResourceString("INVALID_DELTA_FORMAT");
                        this.setErrorMessage(message);
                        this.setPageComplete(false);
                    }
                    break block16;
                }
                if (event.widget != this._nodeUI.getSecUI()) break block19;
                try {
                    this.secValue = Integer.parseInt(this._nodeUI.getSecUI().getText().trim());
                    this.setPageComplete(this.canCompletePage());
                }
                catch (NumberFormatException e) {
                    if (this._nodeUI.getSecUI().getText().trim().equals("")) {
                        this.secValue = 0;
                        this.setPageComplete(this.canCompletePage());
                        return;
                    }
                    String message = UIPlugin.getResourceString("INVALID_DELTA_FORMAT");
                    this.setErrorMessage(message);
                    this.setPageComplete(false);
                }
                break block16;
            }
            if (event.widget != this._nodeUI.getMicSecUI()) break block16;
            try {
                this.micsecValue = Integer.parseInt(this._nodeUI.getMicSecUI().getText().trim());
                this.setPageComplete(this.canCompletePage());
            }
            catch (NumberFormatException e) {
                if (this._nodeUI.getMicSecUI().getText().trim().equals("")) {
                    this.micsecValue = 0;
                    this.setPageComplete(this.canCompletePage());
                    return;
                }
                String message = UIPlugin.getResourceString("INVALID_DELTA_FORMAT");
                this.setErrorMessage(message);
                this.setPageComplete(false);
            }
        }
    }

    protected void populateData() {
        TRCNode node = ((OpenNodeWizard)this.getWizard()).getNode();
        if (node == null) {
            return;
        }
        this._nodeUI.getNodeNameUI().setText(node.getName());
        this._nodeUI.getPortNumberUI().setText(String.valueOf(node.getPort()));
        if (node.getIpAddress() != null) {
            this._nodeUI.getAddressUI().setText(node.getIpAddress());
        }
        this._locationUI.setMonitor(node.getMonitor().getName());
        double delta = node.getDeltaTime();
        if (delta != 0.0) {
            this._nodeUI.setDeltaTime(delta);
        }
    }

    protected boolean canCompletePage() {
        String hour = this._nodeUI.getHourUI().getText().trim();
        String min = this._nodeUI.getMinUI().getText().trim();
        String sec = this._nodeUI.getSecUI().getText().trim();
        String micsec = this._nodeUI.getMicSecUI().getText().trim();
        return this.isHourValid() && this.isMinValid() && this.isSecValid() && this.isMicsecValid();
    }

    protected boolean isHourValid() {
        block2: {
            int hourValue = 0;
            String hour = this._nodeUI.getHourUI().getText().trim();
            try {
                hourValue = Integer.parseInt(hour);
            }
            catch (Exception e) {
                if (hour.equals("")) break block2;
                this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    protected boolean isMinValid() {
        String hour;
        int minValue;
        block3: {
            minValue = 0;
            hour = this._nodeUI.getHourUI().getText().trim();
            String min = this._nodeUI.getMinUI().getText().trim();
            try {
                minValue = Integer.parseInt(min);
            }
            catch (Exception e) {
                if (this._nodeUI.getMinUI().getText().trim().equals("")) break block3;
                this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                return false;
            }
        }
        if (!(hour.equals("") || this.hourValue == 0 || minValue >= 0 && minValue < 60)) {
            this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_TIME"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected boolean isSecValid() {
        String min;
        String hour;
        int secValue;
        block3: {
            secValue = 0;
            hour = this._nodeUI.getHourUI().getText().trim();
            min = this._nodeUI.getMinUI().getText().trim();
            String sec = this._nodeUI.getSecUI().getText().trim();
            try {
                secValue = Integer.parseInt(sec);
            }
            catch (Exception e) {
                if (this._nodeUI.getSecUI().getText().trim().equals("")) break block3;
                this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                return false;
            }
        }
        if ((!hour.equals("") && this.hourValue != 0 || !min.equals("") && this.minValue != 0) && (secValue < 0 || secValue >= 60)) {
            this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_TIME"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected boolean isMicsecValid() {
        String sec;
        String min;
        String hour;
        block3: {
            boolean microsecValue = false;
            hour = this._nodeUI.getHourUI().getText().trim();
            min = this._nodeUI.getMinUI().getText().trim();
            sec = this._nodeUI.getSecUI().getText().trim();
            String micsec = this._nodeUI.getMicSecUI().getText().trim();
            try {
                this.micsecValue = Integer.parseInt(micsec);
            }
            catch (Exception e) {
                if (this._nodeUI.getMicSecUI().getText().trim().equals("")) break block3;
                this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                return false;
            }
        }
        if ((!hour.equals("") && this.hourValue != 0 || !min.equals("") && this.minValue != 0 || !sec.equals("") && this.secValue != 0) && (this.micsecValue < 0 || this.micsecValue >= 1000000)) {
            this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_TIME"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

