/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Vector;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolCell;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.CSVBufferedReader;
import org.eclipse.hyades.test.ui.datapool.internal.util.CSVTokenizer;
import org.eclipse.hyades.test.ui.datapool.internal.util.CorruptCSVFileException;
import org.eclipse.hyades.test.ui.datapool.internal.util.DatapoolUtil;
import org.eclipse.hyades.test.ui.datapool.internal.util.TypeChecker;

public class CSVImportExportUtil {
    public static final String ASCII = "US-ASCII";
    public static final String ISONLATIN = "ISO-8859-1";
    public static final String UTF8 = "UTF-8";
    public static final String UTF16 = "UTF-16";
    public static final String UTF16LE = "UTF-16LE";
    public static final String UTF16BE = "UTF-16BE";
    private static final String SEPERATOR = ",";
    private static final String LINEFEED = "\n";
    private static final char DOUBLEQUOTE = '\"';
    private static final char COMMA = ',';
    private static final String TWOQUOTES = "\"\"";
    private static final String QUOTE = "\"";
    private static final String COLON = ":";
    private static final CSVImportExportUtil instance = new CSVImportExportUtil();
    private static long lineCounter = 1L;

    public static CSVImportExportUtil getInstance() {
        return instance;
    }

    protected CSVImportExportUtil() {
    }

    public void importCSV(IDatapool datapool, String csvFileName, boolean isFirstRowVariableNameType, boolean isFirstColEqClsName, String importEncoding) throws IOException, CorruptCSVFileException {
        if (datapool == null || csvFileName == null) {
            return;
        }
        try {
            try {
                InputStreamReader inputStreamReader = null;
                inputStreamReader = importEncoding.length() == 0 ? new InputStreamReader(new FileInputStream(csvFileName)) : new InputStreamReader((InputStream)new FileInputStream(csvFileName), importEncoding);
                CSVBufferedReader bufferedReader = new CSVBufferedReader(inputStreamReader);
                String firstLine = bufferedReader.readLine();
                if (isFirstRowVariableNameType) {
                    this.createVariablesFromFile(datapool, firstLine, isFirstColEqClsName);
                    firstLine = bufferedReader.readLine();
                    ++lineCounter;
                } else {
                    this.createVariables(datapool, firstLine, isFirstColEqClsName);
                }
                String line = firstLine;
                while (line != null) {
                    this.createRecord(datapool, line, isFirstColEqClsName);
                    line = bufferedReader.readLine();
                    ++lineCounter;
                }
                bufferedReader.close();
            }
            catch (IOException e) {
                throw e;
            }
            catch (CorruptCSVFileException e) {
                throw e;
            }
            Object var11_12 = null;
            lineCounter = 1L;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            lineCounter = 1L;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportCSV(IDatapool datapool, String csvFileName, boolean includeVariables, boolean includeEquivalenceClassNames, boolean includeTags, String exportEncoding) {
        if (datapool == null || csvFileName == null) {
            return;
        }
        try {
            try {
                OutputStreamWriter outputStreamWriter = null;
                outputStreamWriter = exportEncoding.length() == 0 ? new OutputStreamWriter(new FileOutputStream(csvFileName)) : new OutputStreamWriter((OutputStream)new FileOutputStream(csvFileName), exportEncoding);
                BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
                if (includeVariables) {
                    this.writeVariables(datapool, bufferedWriter, true, includeEquivalenceClassNames);
                }
                this.writeRecords(datapool, bufferedWriter, includeEquivalenceClassNames, includeTags);
                bufferedWriter.close();
            }
            catch (IOException e) {
                Object var10_11 = null;
                lineCounter = 1L;
            }
            Object var10_10 = null;
            lineCounter = 1L;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            lineCounter = 1L;
            throw throwable;
        }
    }

    private void createVariablesFromFile(IDatapool datapool, String variableString, boolean ignoreFirst) throws CorruptCSVFileException {
        boolean first = true;
        CSVTokenizer tokenizer = new CSVTokenizer(variableString);
        while (tokenizer.hasMoreTokens()) {
            String error;
            Object[] messageElements;
            String nameTypePair = tokenizer.nextToken();
            if (ignoreFirst && first) {
                first = false;
                continue;
            }
            int separatorIndex = nameTypePair.indexOf(DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER"));
            String name = new String();
            String type = new String();
            if (separatorIndex == -1) {
                name = nameTypePair;
            } else {
                name = nameTypePair.substring(0, separatorIndex);
                type = nameTypePair.substring(separatorIndex + 2);
            }
            String nameErrorFormat = DatapoolPlugin.getResourceString("DATA_COL_DLG_ERROR_NAME_FORMAT");
            if (!DatapoolUtil.getInstance().isVariableNameUnique(datapool, name, null)) {
                messageElements = new Object[]{DatapoolPlugin.getResourceString("DATA_CSV_LINE"), NumberFormat.getInstance().format(lineCounter), COLON, DatapoolPlugin.getResourceString("DATA_COL_DLG_ERROR_NAME_NOT_UNIQUE")};
                error = MessageFormat.format(nameErrorFormat, messageElements);
                throw new CorruptCSVFileException(error);
            }
            if (!DatapoolUtil.getInstance().isVariableNameValid(name)) {
                messageElements = new Object[]{DatapoolPlugin.getResourceString("DATA_CSV_LINE"), NumberFormat.getInstance().format(lineCounter), COLON, DatapoolPlugin.getResourceString("DATA_COL_DLG_ERROR_NAME_NOT_VALID")};
                error = MessageFormat.format(nameErrorFormat, messageElements);
                throw new CorruptCSVFileException(error);
            }
            if (!DatapoolUtil.getInstance().isVariableTypeValid(type)) {
                messageElements = new Object[]{DatapoolPlugin.getResourceString("DATA_CSV_LINE"), NumberFormat.getInstance().format(lineCounter), COLON, DatapoolPlugin.getResourceString("DATA_COL_DLG_ERROR_TYPE_NOT_VALID")};
                error = MessageFormat.format(nameErrorFormat, messageElements);
                throw new CorruptCSVFileException(error);
            }
            IDatapoolVariable variable = datapool.constructVariable();
            variable.setName(name);
            IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)variable.getSuggestedType();
            TypeChecker.getInstance().setVariableType(suggestedType, type);
            variable.setSuggestedType(suggestedType);
            datapool.appendVariable(variable);
        }
    }

    private void createVariables(IDatapool datapool, String varaibleString, boolean ignoreFirst) {
        CSVTokenizer tokenizer = new CSVTokenizer(varaibleString);
        int counter = 1;
        if (ignoreFirst && tokenizer.hasMoreTokens()) {
            tokenizer.nextToken();
        }
        while (tokenizer.hasMoreTokens()) {
            tokenizer.nextToken();
            Object[] messageElements = new Object[]{DatapoolPlugin.getResourceString("DATA_VARIABLE_NAME"), String.valueOf(counter)};
            String name = MessageFormat.format(DatapoolPlugin.getResourceString("DATA_VARIABLE_NAME_FORMAT"), messageElements);
            IDatapoolVariable variable = datapool.constructVariable();
            IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)variable.getSuggestedType();
            suggestedType.setSuggestedClassName(new String());
            variable.setSuggestedType(suggestedType);
            variable.setName(name);
            datapool.appendVariable(variable);
            ++counter;
        }
    }

    private void createRecord(IDatapool datapool, String recordString, boolean useSpecifiedEC) throws CorruptCSVFileException {
        CSVTokenizer tokenizer = new CSVTokenizer(recordString);
        IDatapoolEquivalenceClass equivalenceClass = null;
        String recordIndexStr = null;
        int recordIndex = -1;
        String nameErrorFormat = DatapoolPlugin.getResourceString("DATA_COL_DLG_ERROR_NAME_FORMAT");
        if (useSpecifiedEC) {
            String ecName = tokenizer.nextToken();
            int separatorIndex = ecName.indexOf(DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER"));
            if (separatorIndex >= 0) {
                try {
                    recordIndexStr = ecName.substring(separatorIndex + 2);
                    Number number = NumberFormat.getInstance().parse(recordIndexStr);
                    recordIndex = number.intValue();
                }
                catch (Exception e) {
                    // empty catch block
                }
                ecName = ecName.substring(0, separatorIndex);
            }
            if (!DatapoolUtil.getInstance().isEquivalenceClassNameValid(ecName)) {
                Object[] messageElements = new Object[]{DatapoolPlugin.getResourceString("DATA_CSV_LINE"), NumberFormat.getInstance().format(lineCounter), COLON, DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_ERROR_NAME_NOT_VALID")};
                String error = MessageFormat.format(nameErrorFormat, messageElements);
                throw new CorruptCSVFileException(error);
            }
            int ecIndex = datapool.getEquivalenceClassIndex(ecName);
            if (ecIndex >= 0) {
                equivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(ecIndex);
            } else {
                equivalenceClass = datapool.constructEquivalenceClass();
                equivalenceClass.setName(ecName);
                datapool.appendEquivalenceClass(equivalenceClass);
            }
        } else if (datapool.getEquivalenceClassCount() == 0) {
            equivalenceClass = datapool.constructEquivalenceClass();
            datapool.appendEquivalenceClass(equivalenceClass);
        } else {
            int defaultIndex = datapool.getDefaultEquivalenceClassIndex();
            defaultIndex = defaultIndex < 0 ? 0 : defaultIndex;
            equivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(defaultIndex);
        }
        Vector<String> cellValues = new Vector<String>();
        while (tokenizer.hasMoreTokens()) {
            String cellValue = tokenizer.nextToken();
            cellValues.add(cellValue);
        }
        Object[] recordValues = new String[cellValues.size()];
        int i = 0;
        while (i < cellValues.size()) {
            recordValues[i] = (String)cellValues.get(i);
            ++i;
        }
        IDatapoolRecord record = equivalenceClass.constructRecord(recordValues);
        if (recordIndex != -1) {
            IDatapoolRecord existingRecord = null;
            try {
                existingRecord = (IDatapoolRecord)equivalenceClass.getRecord(recordIndex);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (existingRecord != null) {
                Object[] messageElements = new Object[]{DatapoolPlugin.getResourceString("DATA_CSV_LINE"), NumberFormat.getInstance().format(lineCounter), COLON, DatapoolPlugin.getResourceString("DATA_CSV_ERROR_RECORD_INDEX_DUP")};
                String error = MessageFormat.format(nameErrorFormat, messageElements);
                throw new CorruptCSVFileException(error);
            }
            if (recordIndex > equivalenceClass.getRecordCount()) {
                Object[] messageElements = new Object[]{DatapoolPlugin.getResourceString("DATA_CSV_LINE"), NumberFormat.getInstance().format(lineCounter), COLON, DatapoolPlugin.getResourceString("DATA_CSV_ERROR_RECORD_INDEX_ORDER")};
                String error = MessageFormat.format(nameErrorFormat, messageElements);
                throw new CorruptCSVFileException(error);
            }
            equivalenceClass.insertRecord(record, recordIndex);
        } else {
            equivalenceClass.appendRecord(record);
        }
    }

    private void writeVariables(IDatapool datapool, BufferedWriter writer, boolean includeTypes, boolean includeEquivalenceClasses) {
        String output = new String();
        int count = datapool.getVariableCount();
        if (count != 0) {
            if (includeEquivalenceClasses) {
                Object[] messageElements = new Object[]{output, SEPERATOR};
                output = MessageFormat.format("{0}{1}", messageElements);
            }
            int i = 0;
            while (i < count) {
                IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(i);
                String name = variable.getName();
                String separator = new String();
                if (i != count - 1) {
                    separator = SEPERATOR;
                }
                if (includeTypes) {
                    String type = variable.getSuggestedType().getSuggestedClassName();
                    Object[] preprocessedElements = new Object[]{name, DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER"), type};
                    String preprocessedOutput = MessageFormat.format("{0}{1}{2}", preprocessedElements);
                    preprocessedOutput = this.processString(preprocessedOutput);
                    Object[] messageElements = new Object[]{output, preprocessedOutput, separator};
                    output = MessageFormat.format("{0}{1}{2}", messageElements);
                } else {
                    name = this.processString(name);
                    Object[] messageElements = new Object[]{output, name, separator};
                    output = MessageFormat.format("{0}{1}{2}", messageElements);
                }
                ++i;
            }
            Object[] messageElements = new Object[]{output, LINEFEED};
            output = MessageFormat.format("{0}{1}", messageElements);
        } else {
            output = LINEFEED;
        }
        try {
            writer.write(output);
        }
        catch (IOException e) {}
    }

    private void writeRecords(IDatapool datapool, BufferedWriter writer, boolean includeEquivalenceClasses, boolean includeTags) {
        String output = new String();
        int i = 0;
        while (i < datapool.getEquivalenceClassCount()) {
            IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(i);
            String equivalenceClassName = new String();
            if (includeEquivalenceClasses) {
                equivalenceClassName = equivalenceClass.getName();
                Object[] messageElements = new Object[]{equivalenceClassName, DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER")};
                equivalenceClassName = MessageFormat.format("{0}{1}", messageElements);
            }
            int j = 0;
            while (j < equivalenceClass.getRecordCount()) {
                Object[] messageElements;
                IDatapoolRecord record = (IDatapoolRecord)equivalenceClass.getRecord(j);
                if (includeEquivalenceClasses) {
                    Object[] preprocessedElements = new Object[]{equivalenceClassName, NumberFormat.getInstance().format(j)};
                    String preprocessedOutput = MessageFormat.format(DatapoolPlugin.getResourceString("DATA_VARIABLE_NAME_FORMAT"), preprocessedElements);
                    preprocessedOutput = this.processString(preprocessedOutput);
                    messageElements = new Object[]{output, preprocessedOutput, SEPERATOR};
                    output = MessageFormat.format("{0}{1}{2}", messageElements);
                }
                int count = record.getCellCount();
                int k = 0;
                while (k < count) {
                    IDatapoolCell cell = (IDatapoolCell)record.getCell(k);
                    String cellValue = new String();
                    cellValue = includeTags ? cell.getPersistedRepresentation() : cell.getStringValue();
                    String seperator = new String();
                    if (k != count - 1) {
                        seperator = SEPERATOR;
                    }
                    cellValue = this.processString(cellValue);
                    Object[] messageElements2 = new Object[]{output, cellValue, seperator};
                    output = MessageFormat.format("{0}{1}{2}", messageElements2);
                    ++k;
                }
                messageElements = new Object[]{output, LINEFEED};
                output = MessageFormat.format("{0}{1}", messageElements);
                ++j;
            }
            ++i;
        }
        try {
            writer.write(output);
        }
        catch (IOException e) {}
    }

    private String processString(String value) {
        if (value == null) {
            return null;
        }
        String returnString = value;
        boolean quoteString = false;
        if (value.trim().length() < value.length()) {
            quoteString = true;
        }
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == ',') {
                quoteString = true;
            }
            if (c == '\"') {
                quoteString = true;
            }
            ++i;
        }
        returnString = returnString.replaceAll(QUOTE, TWOQUOTES);
        if (quoteString) {
            returnString = this.wrapString(returnString);
        }
        return returnString;
    }

    private String wrapString(String value) {
        Object[] messageElements = new Object[]{QUOTE, value, QUOTE};
        return MessageFormat.format("{0}{1}{2}", messageElements);
    }
}

