/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.testgen;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.execution.testgen.TestgenPlugin;
import org.eclipse.hyades.internal.execution.testgen.TestgenException;
import org.eclipse.hyades.internal.execution.testgen.ui.TestgenUIUtility;
import org.eclipse.hyades.internal.execution.testgen.ui.dialogs.TestGenProgressDialog;

public abstract class TestGenerator
implements Runnable {
    protected IFile recModelFile = null;
    protected String outputFileName = null;
    private TestGenProgressDialog dlg = null;
    private boolean bSuccess = false;

    public abstract boolean runTestGen() throws TestgenException;

    public abstract boolean showProgress();

    public void initialize(IFile iFile, String string) {
        this.recModelFile = iFile;
        this.outputFileName = string;
    }

    public void run() {
        if (this.showProgress()) {
            this.dlg = new TestGenProgressDialog();
            this.dlg.setBlockOnOpen(false);
            this.dlg.open();
        }
        try {
            this.bSuccess = this.runTestGen();
            if (this.bSuccess) {
                IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.outputFileName));
                TestgenUIUtility.selectAndReveal((IResource)iFile, TestgenPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow());
                TestgenUIUtility.openEditor(iFile, null, false);
            }
        }
        catch (TestgenException testgenException) {
            testgenException.printStackTrace();
        }
    }

    public void setProgress(int n) {
        if (this.dlg != null) {
            this.dlg.setProgress(n);
        }
    }

    public void setMessage(String string) {
        if (this.dlg != null) {
            this.dlg.setMessage(string);
        }
    }

    public void closeProgressDialog() {
        if (this.dlg != null) {
            this.dlg.close();
        }
    }

    public boolean isSuccess() {
        return this.bSuccess;
    }
}

