/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDRepresentation;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDTextObservation;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.ImageManager;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConModelOp;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConOpState;
import org.eclipse.hyades.statistical.ui.editor.internal.StatisticalModelGraphViewer;
import org.eclipse.hyades.statistical.ui.editor.internal.XMLConfigUtil;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.BasicGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Graph;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.swt.widgets.TreeItem;

public class OpGenerateDescriptorConfig
implements StatConModelOp {
    public static OpGenerateDescriptorConfig INSTANCE = new OpGenerateDescriptorConfig();
    static ImageManager img = EditorPlugin.img;

    public static void launch(StatisticalModelGraphViewer statcon, SDDescriptor item, SDDescriptor root, StringBuffer xml, int depth) {
        StatConOpState state = new StatConOpState(new State(depth, xml));
        statcon.applyStatConModelOp(new OpGenerateDescriptorConfig(), state, item, root);
    }

    public StatConOpState preapply(StatConOpState state, StatisticalModelGraphViewer statcon, SDDescriptor descriptor, SDDescriptor root_parent, boolean parents_checked, boolean parents_enabled) {
        State mystate = (State)state.state;
        StringBuffer xml = mystate.xml;
        int depth = mystate.depth;
        this.generatePreChildConfig(statcon, xml, descriptor, depth);
        return new StatConOpState(new State(depth + 1, xml));
    }

    public void postapply(StatConOpState state, StatisticalModelGraphViewer statcon, SDDescriptor descriptor, SDDescriptor root_parent, boolean parents_checked, boolean parents_enabled) {
        State mystate = (State)state.state;
        StringBuffer xml = mystate.xml;
        int depth = mystate.depth;
        this.generatePostChildConfig(statcon, xml, descriptor, depth);
    }

    private void generatePostChildConfig(StatisticalModelGraphViewer statcon, StringBuffer xml, SDDescriptor descriptor, int depth) {
        int t = 0;
        while (t < depth) {
            xml.append("  ");
            ++t;
        }
        xml.append("</descriptor>\n");
    }

    private void generatePreChildConfig(StatisticalModelGraphViewer statcon, StringBuffer xml, SDDescriptor descriptor, int depth) {
        SDRepresentation rep;
        SDMemberDescriptor mem_descriptor;
        TreeItem sd_item = statcon.mapDescriptorToItem(descriptor);
        if (descriptor == null) {
            return;
        }
        if (sd_item == null) {
            return;
        }
        int t = 0;
        while (t < depth) {
            xml.append("  ");
            ++t;
        }
        xml.append("<descriptor ");
        xml.append("name=\"").append(descriptor.getName()).append("\" ");
        xml.append("ticked=\"").append(sd_item.getChecked()).append("\" ");
        xml.append("expanded=\"").append(sd_item.getExpanded()).append("\" ");
        xml.append(">\n");
        if (descriptor instanceof SDMemberDescriptor) {
            mem_descriptor = (SDMemberDescriptor)descriptor;
            EList observations = mem_descriptor.getSnapshotObservation();
            int i = 0;
            while (i < observations.size()) {
                Object o = observations.get(i);
                if (o instanceof SDContiguousObservation || o instanceof SDTextObservation) {
                    int t2;
                    TreeItem obs_item = statcon.mapObservationToItem((SDSnapshotObservation)o);
                    BasicGraphSource source = statcon.mapItemToGraphSource(obs_item);
                    Graph graph = null;
                    if (source != null) {
                        graph = statcon.mapSourceToGraph(source);
                    }
                    if (graph != null) {
                        t2 = 0;
                        while (t2 < depth) {
                            xml.append("  ");
                            ++t2;
                        }
                        xml.append("<obs_graph ");
                        xml.append("ticked=\"").append(obs_item.getChecked()).append("\" ");
                        xml.append("obs_index=\"").append(i).append("\" ");
                        xml.append("x_slider=\"").append(statcon.getGraphWindow().getXSlider(graph.getXSlider())).append("\" ");
                        xml.append("y_slider=\"").append(statcon.getGraphWindow().getYSlider(graph.getYSlider())).append("\" ");
                        xml.append("color=\"").append(XMLConfigUtil.colorToString(graph.getForeground())).append("\" ");
                        xml.append("line_width=\"").append(graph.getLineWidth()).append("\" ");
                        xml.append("line_style=\"").append(XMLConfigUtil.lineStyleToString(graph.getLineStyle())).append("\" ");
                        xml.append("multiplier=\"").append(graph.getStaticScaling()).append("\" ");
                        xml.append("plotting_type=\"").append(XMLConfigUtil.generatePlottingType(graph.getPlottingType())).append("\" ");
                        xml.append("plotting_period=\"").append(XMLConfigUtil.generatePlottingPeriod(graph.getPlottingPeriodType())).append("\" ");
                        xml.append("nodata_behaviour=\"").append(XMLConfigUtil.generateNoDataBehaviour(graph.getNoDataBehaviour())).append("\" ");
                        xml.append("plotting_period_value=\"").append(graph.getPlottingPeriodValue()).append("\" ");
                        xml.append("xoffset=\"").append(graph.getXOffset()).append("\" ");
                        xml.append("yoffset=\"").append(graph.getYOffset()).append("\" ");
                        xml.append("/>\n");
                    } else if (obs_item != null) {
                        t2 = 0;
                        while (t2 < depth) {
                            xml.append("  ");
                            ++t2;
                        }
                        xml.append("<obs_graph ");
                        xml.append("ticked=\"").append(obs_item.getChecked()).append("\" ");
                        xml.append("obs_index=\"").append(i).append("\" ");
                        xml.append("/>\n");
                    }
                }
                ++i;
            }
        }
        if (descriptor instanceof SDMemberDescriptor && (rep = (mem_descriptor = (SDMemberDescriptor)descriptor).getRepresentation()) instanceof SDModifiableVariableRepresentation) {
            TreeItem rep_item = statcon.mapRepresentationToItem(rep);
            ZoomSlider slider = statcon.mapItemToSlider(rep_item);
            int t3 = 0;
            while (t3 < depth) {
                xml.append("  ");
                ++t3;
            }
            if (slider != null) {
                xml.append("<control ");
                xml.append("ticked=\"").append(rep_item.getChecked()).append("\" ");
                xml.append("y_slider=\"").append(statcon.getGraphWindow().getYSlider(slider)).append("\" ");
                xml.append("/>\n");
            } else {
                xml.append("<control ");
                xml.append("ticked=\"").append(rep_item.getChecked()).append("\" ");
                xml.append("y_slider=\"0\" ");
                xml.append("/>\n");
            }
        }
    }

    static class State {
        int depth = 0;
        StringBuffer xml;

        public State(int depth, StringBuffer xml) {
            this.depth = depth;
            this.xml = xml;
        }
    }
}

