/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.extension;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationDescriptorFilter;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.hyades.ui.internal.extension.AssociationMapping;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.hyades.ui.internal.util.XMLUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.ui.IPropertyListener;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AssociationMappingRegistry
implements IAssociationMappingRegistry {
    private static final String PREFERENCE_PREFIX_KEY = HyadesUIPlugin.getID() + ".AssociationMappingRegistry.";
    private Map associationMappingByExtensionPoint;
    private IAssociationDescriptorFilter filter;
    private String objectCategory;
    private IPreferenceStore preferenceStore;
    private ImageRegistry imageRegistry;
    private ListenerList commitChangeListeners;
    private String xmlBuffer;

    public void initialize(String objectCategory, IAssociationDescriptorFilter filter, IPreferenceStore preferenceStore) throws IllegalArgumentException {
        if (objectCategory == null) {
            throw new IllegalArgumentException(HyadesUIPlugin.getString("_ERROR_ARG_NULL", "objectCategory"));
        }
        this.objectCategory = objectCategory;
        this.filter = filter;
        this.preferenceStore = preferenceStore;
        this.load(preferenceStore);
    }

    public void dispose() {
        CoreUtil.dispose(this.associationMappingByExtensionPoint);
        if (this.commitChangeListeners != null) {
            this.commitChangeListeners.clear();
        }
        this.filter = null;
        this.preferenceStore = null;
        this.xmlBuffer = null;
        this.imageRegistry = null;
    }

    public ImageRegistry getImageRegistry() {
        block2: {
            if (this.imageRegistry != null) break block2;
            try {
                this.imageRegistry = new ImageRegistry();
            }
            catch (RuntimeException e) {
                HyadesUIPlugin.logError(e);
            }
        }
        return this.imageRegistry;
    }

    public void setImageRegistry(ImageRegistry imageRegistry) {
        this.imageRegistry = imageRegistry;
    }

    public String getObjectCategory() {
        return this.objectCategory;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public IAssociationDescriptorFilter getFilter() {
        return this.filter;
    }

    public synchronized IAssociationMapping retrieveAssociationMapping(String extensionPoint, String pluginId) throws IllegalArgumentException {
        if (extensionPoint == null) {
            throw new IllegalArgumentException(HyadesUIPlugin.getString("_ERROR_ARG_NULL", "extensionPoint"));
        }
        AssociationMapping associationMapping = null;
        if (this.associationMappingByExtensionPoint == null) {
            this.associationMappingByExtensionPoint = new TreeMap();
        } else {
            associationMapping = (AssociationMapping)this.associationMappingByExtensionPoint.get(extensionPoint);
        }
        if (associationMapping == null) {
            associationMapping = new AssociationMapping(this, extensionPoint, pluginId);
            this.associationMappingByExtensionPoint.put(extensionPoint, associationMapping);
        }
        return associationMapping;
    }

    public IAssociationMapping getAssociationMapping(String extensionPoint) {
        if (extensionPoint == null || this.associationMappingByExtensionPoint == null) {
            return null;
        }
        return (AssociationMapping)this.associationMappingByExtensionPoint.get(extensionPoint);
    }

    public IAssociationMapping[] getAssociationMappings() {
        if (this.associationMappingByExtensionPoint == null) {
            return new IAssociationMapping[0];
        }
        return this.associationMappingByExtensionPoint.values().toArray(new AssociationMapping[this.associationMappingByExtensionPoint.values().size()]);
    }

    public synchronized boolean checkpoint() {
        this.xmlBuffer = this.write();
        return true;
    }

    public synchronized void clearCheckpoint() {
        this.xmlBuffer = null;
    }

    public synchronized boolean commit() {
        this.checkpoint();
        if (this.write(this.preferenceStore)) {
            this.notifyCommitChangeListeners();
        }
        return true;
    }

    public synchronized boolean rollback() {
        if (this.xmlBuffer != null) {
            this.load(this.xmlBuffer);
        }
        return true;
    }

    public void addCommitChangeListener(IPropertyListener propertyListener) {
        if (this.commitChangeListeners == null) {
            this.commitChangeListeners = new ListenerList();
        }
        this.commitChangeListeners.add((Object)propertyListener);
    }

    public void removeCommitChangeListener(IPropertyListener propertyListener) {
        if (this.commitChangeListeners != null) {
            this.commitChangeListeners.remove((Object)propertyListener);
        }
    }

    protected void notifyCommitChangeListeners() {
        if (this.commitChangeListeners == null) {
            return;
        }
        Object[] listeners = this.commitChangeListeners.getListeners();
        int i = 0;
        int maxi = listeners.length;
        while (i < maxi) {
            IPropertyListener propertyListener = (IPropertyListener)listeners[i];
            try {
                propertyListener.propertyChanged((Object)this, 1);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            ++i;
        }
    }

    protected String getPreferenceKey() {
        StringBuffer key = new StringBuffer(PREFERENCE_PREFIX_KEY);
        key.append(this.objectCategory);
        return key.toString();
    }

    protected boolean load(IPreferenceStore preferenceStore) {
        if (preferenceStore == null) {
            return false;
        }
        String value = preferenceStore.getString(this.getPreferenceKey());
        if (value == null || value.length() == 0) {
            return false;
        }
        return this.load(value);
    }

    protected boolean load(String xml) {
        XMLUtil.setLogger(HyadesUIPlugin.getLogger());
        Element registryElement = XMLUtil.loadDom(xml, "AssociationMappingRegistry");
        if (registryElement == null) {
            return false;
        }
        NodeList nodeList = XMLUtil.getChildrenByName(registryElement, "AssociationMapping");
        int i = 0;
        int maxi = nodeList.getLength();
        while (i < maxi) {
            if (nodeList.item(i) instanceof Element) {
                this.loadMapping((Element)nodeList.item(i));
            }
            ++i;
        }
        return true;
    }

    protected boolean write(IPreferenceStore preferenceStore) {
        if (preferenceStore == null) {
            return false;
        }
        String xmlString = this.write();
        if (xmlString.equals(preferenceStore.getString(this.getPreferenceKey()))) {
            return false;
        }
        preferenceStore.setValue(this.getPreferenceKey(), xmlString);
        return true;
    }

    protected String write() {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml");
        xml.append(XMLUtil.createXMLAttribute("version", "1.0", false)).append(XMLUtil.createXMLAttribute("encoding", "UTF-8", false));
        xml.append("?>");
        xml.append("<AssociationMappingRegistry>");
        IAssociationMapping[] mappings = this.getAssociationMappings();
        int i = 0;
        int maxi = mappings.length;
        while (i < maxi) {
            this.writeMapping(xml, mappings[i]);
            ++i;
        }
        xml.append("</AssociationMappingRegistry>");
        return xml.toString();
    }

    protected void loadMapping(Element mappingElement) {
        String extensionPoint = XMLUtil.getValue(mappingElement, "extensionPoint");
        if (extensionPoint == null) {
            return;
        }
        String pluginId = XMLUtil.getValue(mappingElement, "pluginId");
        IAssociationMapping mapping = this.retrieveAssociationMapping(extensionPoint, pluginId);
        String defaultId = XMLUtil.getValue(mappingElement, "defaultId");
        if (defaultId != null) {
            mapping.setDefaultAssociationDescriptor(mapping.getAssociationDescriptor(defaultId));
        }
        NodeList typeDetailNodeList = XMLUtil.getChildrenByName(mappingElement, "TypeDetail");
        int i = 0;
        int maxi = typeDetailNodeList.getLength();
        while (i < maxi) {
            Element typeDetailElement;
            String type;
            if (typeDetailNodeList.item(i) instanceof Element && (type = XMLUtil.getValue(typeDetailElement = (Element)typeDetailNodeList.item(i), "type")) != null) {
                defaultId = XMLUtil.getValue(typeDetailElement, "defaultId");
                if (defaultId != null) {
                    mapping.setDefaultAssociationDescriptor(type, mapping.getAssociationDescriptor(type, defaultId));
                }
                mapping.removeAllFromAvoidSet(type);
                NodeList avoidedDescriptorNodeList = XMLUtil.getChildrenByName(typeDetailElement, "AvoidedDescriptor");
                int j = 0;
                int maxj = avoidedDescriptorNodeList.getLength();
                while (j < maxj) {
                    Element avoidedDescriptorElement;
                    String id;
                    if (avoidedDescriptorNodeList.item(j) instanceof Element && (id = XMLUtil.getValue(avoidedDescriptorElement = (Element)avoidedDescriptorNodeList.item(j), "id")) != null) {
                        mapping.addToAvoidedSet(type, mapping.getAssociationDescriptor(type, id));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void writeMapping(StringBuffer xml, IAssociationMapping mapping) {
        StringBuffer tempXML = new StringBuffer();
        tempXML.append("<AssociationMapping");
        tempXML.append(XMLUtil.createXMLAttribute("extensionPoint", mapping.getExtensionPoint(), false));
        tempXML.append(XMLUtil.createXMLAttribute("pluginId", mapping.getPluginId(), false));
        IAssociationDescriptor defaultDescriptor = mapping.getDefaultAssociationDescriptor();
        if (defaultDescriptor != null) {
            tempXML.append(XMLUtil.createXMLAttribute("defaultId", defaultDescriptor.getId(), false));
        }
        tempXML.append(">");
        boolean hasContent = false;
        String[] types = mapping.getTypes();
        int i = 0;
        int maxi = types.length;
        while (i < maxi) {
            defaultDescriptor = mapping.getDefaultAssociationDescriptor(types[i]);
            IAssociationDescriptor[] avoidedDescriptors = mapping.getAvoidedAssociationDescriptors(types[i]);
            if (defaultDescriptor != null && defaultDescriptor.getId() != null || avoidedDescriptors.length != 0) {
                hasContent = true;
                tempXML.append("<TypeDetail");
                tempXML.append(XMLUtil.createXMLAttribute("type", types[i], false));
                if (defaultDescriptor != null) {
                    tempXML.append(XMLUtil.createXMLAttribute("defaultId", defaultDescriptor.getId(), false));
                }
                tempXML.append(">");
                int j = 0;
                int maxj = avoidedDescriptors.length;
                while (j < maxj) {
                    if (avoidedDescriptors[j].getId() != null) {
                        tempXML.append("<AvoidedDescriptor");
                        tempXML.append(XMLUtil.createXMLAttribute("id", avoidedDescriptors[j].getId(), false));
                        tempXML.append("/>");
                    }
                    ++j;
                }
                tempXML.append("</TypeDetail>");
            }
            ++i;
        }
        tempXML.append("</AssociationMapping>");
        if (hasContent) {
            xml.append(tempXML);
        }
    }
}

