/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard.exampleproject;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class CreationWizardPage
extends WizardNewProjectCreationPage {
    private IConfigurationElement configurationElement;
    private String initialProjectName;
    private CreationWizard creationWizard;

    public CreationWizardPage(CreationWizard creationWizard, String pageName, IConfigurationElement configurationElement) {
        super(pageName);
        this.configurationElement = configurationElement;
        this.creationWizard = creationWizard;
        this.initialProjectName = this.getValue(configurationElement, "name");
        if (this.initialProjectName != null) {
            this.setInitialProjectName(this.initialProjectName);
        }
        this.setDescription(this.getValue(configurationElement, "pagedescription"));
        this.setTitle(this.getValue(configurationElement, "pagetitle"));
    }

    public void dispose() {
        this.configurationElement = null;
        this.creationWizard = null;
        super.dispose();
    }

    protected CreationWizard getCreationWizard() {
        return this.creationWizard;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public String getInitialProjectName() {
        return this.initialProjectName;
    }

    protected boolean setHelpId() {
        String helpId = this.configurationElement.getAttribute("helpId");
        if (helpId == null) {
            return true;
        }
        if (this.getControl() == null) {
            return false;
        }
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)helpId);
        return true;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Text projectText = this.getProjectText();
        if (projectText != null) {
            projectText.notifyListeners(24, new Event());
            projectText.setSelection(0, projectText.getText().length());
        }
    }

    private Text getProjectText() {
        if (!(this.getControl() instanceof Composite)) {
            return null;
        }
        if (this.getProjectName() == null) {
            return null;
        }
        Composite parent = (Composite)this.getControl();
        Control[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Composite) {
                Control[] grandChildren = ((Composite)children[i]).getChildren();
                int j = 0;
                while (j < grandChildren.length) {
                    if (grandChildren[j] instanceof Text) {
                        Text text = (Text)grandChildren[j];
                        if (this.getProjectName().equals(text.getText())) {
                            return text;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        String projectName = this.getProjectName();
        if (projectName == null) {
            return false;
        }
        IWizard wizard = this.getWizard();
        if (wizard instanceof CreationWizard) {
            IWizardPage[] pages = wizard.getPages();
            int i = 0;
            while (i < pages.length) {
                if (pages[i] != this && pages[i] instanceof CreationWizardPage && projectName.equals(((CreationWizardPage)pages[i]).getProjectName())) {
                    this.setErrorMessage(HyadesUIPlugin.getString("_ERROR_DUP_PROJECT_NAME"));
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private String getValue(IConfigurationElement configurationElement, String attribute) {
        String value = configurationElement.getAttribute(attribute);
        if (value == null) {
            return "";
        }
        return value;
    }
}

