/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.cbe;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;
import java.util.SimpleTimeZone;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;

public class CBEUtils {
    public static double computeAdjustedCreationTime(CBECommonBaseEvent event) {
        double creationTime = event.getCreationTime();
        try {
            if (event.getAgent().getAgentProxy().getDeltaTime() != 0.0) {
                return creationTime + event.getAgent().getAgentProxy().getDeltaTime();
            }
            return creationTime + event.getAgent().getAgentProxy().getProcessProxy().getNode().getDeltaTime();
        }
        catch (Exception e) {
            return creationTime;
        }
    }

    public static String formatCreationTime(CBECommonBaseEvent event, DateFormat dateFormat) {
        short zone = event.getTimeZone();
        return CBEUtils.formatCreationTime(event, dateFormat, zone);
    }

    public static String formatCreationTime(CBECommonBaseEvent event, DateFormat dateFormat, short zone) {
        if (event.getCreationTime() != 0.0) {
            try {
                double ct = CBEUtils.computeAdjustedCreationTime(event);
                Double l2 = new Double(ct);
                long r = (long)(l2 % 1000000.0);
                if (r < 0L) {
                    r = 1000000L + r;
                }
                String microseconds = "" + r;
                String ms = "." + "000000".substring(0, 6 - microseconds.length()) + microseconds;
                StringBuffer toAppendTo = new StringBuffer();
                FieldPosition fieldPosition = new FieldPosition(7);
                SimpleTimeZone timeZone = new SimpleTimeZone(zone * 60 * 1000, "");
                dateFormat.setTimeZone(timeZone);
                dateFormat.format(new Date(l2.longValue() / 1000L), toAppendTo, fieldPosition);
                if (fieldPosition.getEndIndex() > 0) {
                    toAppendTo.insert(fieldPosition.getEndIndex(), ms);
                }
                return toAppendTo.toString();
            }
            catch (Exception e) {
                LoadersUtils.log((Throwable)e);
            }
        }
        return "0";
    }
}

