/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.cbe.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.CorrelationQuery;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByElement;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.hierarchy.util.IFilterElement;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.models.hierarchy.util.ILogFilterCriteria;
import org.eclipse.hyades.models.hierarchy.util.ISortElement;

public class LogQueryBuilder {
    public static Query createQuery(List inputList, ILogFilterCriteria element, EAttribute attribute) {
        SimpleSearchQuery query = LogQueryBuilder.addAgents(inputList, element);
        SimpleOperand operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        operand.setType(HierarchyPackage.eINSTANCE.getTRCAgent());
        query.getOutputElements().add((Object)operand);
        operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        operand.setFeature((EStructuralFeature)attribute);
        query.getOutputElements().add((Object)operand);
        return query;
    }

    public static Query createQuery(List inputList, ILogFilterCriteria element) {
        Query query = null;
        EObject inputObject = null;
        int s = inputList.size();
        int i = 0;
        while (i < s) {
            inputObject = (EObject)inputList.get(i);
            if (inputObject instanceof TRCAgentProxy) {
                if (query == null) {
                    query = LogQueryBuilder.createQueryFromAgentProxy((TRCAgentProxy)inputObject, element);
                } else if (i == 0) {
                    LogQueryBuilder.addAgentToQuery((SimpleSearchQuery)query, (TRCAgentProxy)inputObject, element);
                } else {
                    LogQueryBuilder.addAgentToQuery((SimpleSearchQuery)query, (TRCAgentProxy)inputObject, null);
                }
            } else if (inputObject instanceof CorrelationContainerProxy) {
                query = LogQueryBuilder.createQueryFromAgents((List)((CorrelationContainerProxy)inputObject).getCorrelatedAgents(), element);
            }
            ++i;
        }
        if (query != null) {
            query.setDistinct(true);
        }
        return query;
    }

    public static QueryResult executeQuery(Query query, ResourceSet resourceSet) {
        if (query == null || query.getSources().size() == 0) {
            return null;
        }
        QueryResult queryResult = null;
        String url = (String)query.getSources().get(0);
        IHyadesResourceExtension hyadesResourceExtension = (IHyadesResourceExtension)HyadesResourceExtensions.getInstance().get((Object)LoadersUtils.getPostfix((String)url));
        if (hyadesResourceExtension != null) {
            ArrayList<EClass> notLoadedTypes = new ArrayList<EClass>();
            notLoadedTypes.add(HierarchyPackage.eINSTANCE.getAbstractDefaultEvent());
            notLoadedTypes.add(HierarchyPackage.eINSTANCE.getTRCAgentProxy());
            queryResult = hyadesResourceExtension.executeQuery(query, resourceSet, notLoadedTypes);
            return queryResult;
        }
        return queryResult;
    }

    public static boolean convertToCreationTimeIfRequired(Query query) {
        boolean res = false;
        TreeIterator iter = query.eAllContents();
        while (iter.hasNext()) {
            SimpleOperand so;
            EObject element = (EObject)iter.next();
            if (!(element instanceof SimpleOperand) || (so = (SimpleOperand)element).getFeature() != CBEPackage.eINSTANCE.getCBECommonBaseEvent_AdjustedCreationTime()) continue;
            so.setFeature((EStructuralFeature)CBEPackage.eINSTANCE.getCBECommonBaseEvent_CreationTime());
            res = true;
        }
        return res;
    }

    public static Query createSearchQuery(List inputList, ILogFilterCriteria filterElement, ILogFilterCriteria searchElement) {
        Query query = LogQueryBuilder.createQuery(inputList, filterElement);
        query = query == null ? LogQueryBuilder.createQuery(inputList, searchElement) : LogQueryBuilder.getMergedQuery(query, searchElement);
        return query;
    }

    public static Query createSearchQuery(Query query, ILogFilterCriteria searchElement) {
        if (query instanceof CorrelationQuery) {
            CorrelationQuery searchQuery = (CorrelationQuery)EcoreUtil.copy((EObject)query);
            SimpleSearchQuery searchSubQuery = LogQueryBuilder.simulateOldWhereExpressions();
            EList whereCriterias = ((LogicalExpression)searchSubQuery.getWhereExpression()).getArguments();
            IFilterElement[] searchFilters = searchElement.getFilters();
            EList attributes = CBEPackage.eINSTANCE.getCBECommonBaseEvent().getEAllAttributes();
            EAttribute attribute = null;
            int i = 0;
            while (i < searchFilters.length) {
                attribute = LogQueryBuilder.findAttributeInList(searchFilters[i].getAttribute(), (List)attributes);
                if (attribute != null && !LogQueryBuilder.isFilterInWhereClause(searchFilters[i], (List)whereCriterias)) {
                    whereCriterias.add(LogQueryBuilder.createBinaryExpression(searchFilters[i], attribute));
                }
                ++i;
            }
            searchQuery.getSubQuery().add((Object)searchSubQuery);
            return searchQuery;
        }
        return LogQueryBuilder.getMergedQuery(query, searchElement);
    }

    public static Query getMergedQuery(Query query, ILogFilterCriteria mergeElement) {
        SimpleSearchQuery searchQuery = (SimpleSearchQuery)EcoreUtil.copy((EObject)query);
        LogQueryBuilder.addWhereExpression(searchQuery);
        EList whereCriteria = ((LogicalExpression)searchQuery.getWhereExpression()).getArguments();
        IFilterElement[] searchFilters = mergeElement.getFilters();
        EList attributes = CBEPackage.eINSTANCE.getCBECommonBaseEvent().getEAllAttributes();
        EAttribute attribute = null;
        int i = 0;
        while (i < searchFilters.length) {
            attribute = LogQueryBuilder.findAttributeInList(searchFilters[i].getAttribute(), (List)attributes);
            if (attribute != null && !LogQueryBuilder.isFilterInWhereClause(searchFilters[i], (List)whereCriteria)) {
                whereCriteria.add(LogQueryBuilder.createBinaryExpression(searchFilters[i], attribute));
            }
            ++i;
        }
        return searchQuery;
    }

    private static void addWhereExpression(SimpleSearchQuery searchQuery) {
        if (searchQuery.getWhereExpression() == null) {
            LogicalExpression l = ExtensionsFactory.eINSTANCE.createLogicalExpression();
            l.setOperator(LogicalOperators.AND_LITERAL);
            searchQuery.setWhereExpression((WhereExpression)l);
        }
    }

    public static Query createCorrelation(List agentProxies) {
        TimeBasedCorrelationQuery query = ExtensionsFactory.eINSTANCE.createTimeBasedCorrelationQuery();
        int s = agentProxies.size();
        EObject inputObject = null;
        double delta = 0.0;
        int i = 0;
        while (i < s) {
            inputObject = (EObject)agentProxies.get(i);
            if (inputObject instanceof TRCAgentProxy) {
                LogQueryBuilder.addAgentToQuery((SimpleSearchQuery)query, (TRCAgentProxy)inputObject, null);
                delta = ((TRCAgentProxy)inputObject).getDeltaTime() != 0.0 ? ((TRCAgentProxy)inputObject).getDeltaTime() : (((TRCAgentProxy)inputObject).getProcessProxy() != null && ((TRCAgentProxy)inputObject).getProcessProxy().getNode() != null ? ((TRCAgentProxy)inputObject).getProcessProxy().getNode().getDeltaTime() : 0.0);
                query.getDeltaTime().add((Object)new Double(delta));
            }
            ++i;
        }
        return query;
    }

    public static Query createCorrelatedEventsQuery(List agentProxies) {
        TimeBasedCorrelationQuery query = (TimeBasedCorrelationQuery)LogQueryBuilder.createCorrelation(agentProxies);
        SimpleOperand Operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        Operand.setType(CBEPackage.eINSTANCE.getCBECommonBaseEvent());
        query.getOutputElements().add((Object)Operand);
        return query;
    }

    public static Query createOutboundCorrelationQuery(List agentProxies, ILogFilterCriteria filter) {
        TimeBasedCorrelationQuery query = (TimeBasedCorrelationQuery)LogQueryBuilder.createCorrelation(agentProxies);
        SimpleOperand Operand1 = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        Operand1.setFeature((EStructuralFeature)HierarchyPackage.eINSTANCE.getCorrelationEntry_Key());
        query.getOutputElements().add((Object)Operand1);
        SimpleOperand Operand2 = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        Operand2.setFeature((EStructuralFeature)HierarchyPackage.eINSTANCE.getCorrelationEntry_Value());
        query.getOutputElements().add((Object)Operand2);
        return LogQueryBuilder.getMergedQuery((Query)query, filter);
    }

    public static Query createInboundCorrelationQuery(List agentProxies, ILogFilterCriteria filter) {
        TimeBasedCorrelationQuery query = (TimeBasedCorrelationQuery)LogQueryBuilder.createCorrelation(agentProxies);
        SimpleOperand Operand1 = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        Operand1.setFeature((EStructuralFeature)HierarchyPackage.eINSTANCE.getCorrelationEntry_Value());
        query.getOutputElements().add((Object)Operand1);
        SimpleOperand Operand2 = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        Operand2.setFeature((EStructuralFeature)HierarchyPackage.eINSTANCE.getCorrelationEntry_Key());
        query.getOutputElements().add((Object)Operand2);
        return LogQueryBuilder.getMergedQuery((Query)query, filter);
    }

    private static void addAgentToQuery(SimpleSearchQuery query, TRCAgentProxy inputObject, ILogFilterCriteria element) {
        TRCAgent agent = (TRCAgent)inputObject.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
        if (agent != null) {
            query.getSources().add((Object)EcoreUtil.getURI((EObject)agent).toString());
            if (element != null) {
                ((LogicalExpression)query.getWhereExpression()).getArguments().addAll((Collection)LogQueryBuilder.createWhereClause(CBEPackage.eINSTANCE.getCBECommonBaseEvent(), element.getFilters()));
                LogQueryBuilder.addSeverityFilters(query, element);
                query.getOrderByExpresions().addAll((Collection)LogQueryBuilder.createOrderByClause(CBEPackage.eINSTANCE.getCBECommonBaseEvent(), element.getSortColumns()));
            }
        }
    }

    private static void addSeverityFilters(SimpleSearchQuery query, ILogFilterCriteria element) {
        Map options = element.getFilterOptions();
        if (options != null) {
            if (options.get("sev1").equals("1") && options.get("sev2").equals("1") && options.get("sev3").equals("1")) {
                return;
            }
            if (options.get("sev1").equals("1") && options.get("sev2").equals("0") && options.get("sev3").equals("0")) {
                LogQueryBuilder.getANDArguments(query).add(LogQueryBuilder.createBinaryExpression(CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), RelationalOperators.get((int)1), new Integer(49)));
                LogQueryBuilder.getANDArguments(query).add(LogQueryBuilder.createBinaryExpression(CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), RelationalOperators.get((int)0), new Integer(71)));
            } else if (options.get("sev1").equals("1") && options.get("sev2").equals("1") && options.get("sev3").equals("0")) {
                LogQueryBuilder.getANDArguments(query).add(LogQueryBuilder.createBinaryExpression(CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), RelationalOperators.get((int)1), new Integer(29)));
                LogQueryBuilder.getANDArguments(query).add(LogQueryBuilder.createBinaryExpression(CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), RelationalOperators.get((int)0), new Integer(71)));
            } else if (options.get("sev1").equals("0") && options.get("sev2").equals("1") && options.get("sev3").equals("0")) {
                LogQueryBuilder.getANDArguments(query).add(LogQueryBuilder.createBinaryExpression(CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), RelationalOperators.get((int)1), new Integer(29)));
                LogQueryBuilder.getANDArguments(query).add(LogQueryBuilder.createBinaryExpression(CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), RelationalOperators.get((int)0), new Integer(50)));
            } else if (options.get("sev1").equals("0") && options.get("sev2").equals("1") && options.get("sev3").equals("0")) {
                LogQueryBuilder.getANDArguments(query).add(LogQueryBuilder.createBinaryExpression(CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), RelationalOperators.get((int)1), new Integer(29)));
                LogQueryBuilder.getANDArguments(query).add(LogQueryBuilder.createBinaryExpression(CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), RelationalOperators.get((int)0), new Integer(50)));
            } else if (options.get("sev1").equals("0") && options.get("sev2").equals("1") && options.get("sev3").equals("1")) {
                LogQueryBuilder.getANDArguments(query).add(LogQueryBuilder.createBinaryExpression(CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), RelationalOperators.get((int)0), new Integer(50)));
            } else if (options.get("sev1").equals("0") && options.get("sev2").equals("0") && options.get("sev3").equals("1")) {
                LogQueryBuilder.getANDArguments(query).add(LogQueryBuilder.createBinaryExpression(CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), RelationalOperators.get((int)0), new Integer(30)));
            }
        }
    }

    public static List getANDArguments(SimpleSearchQuery query) {
        if (query.getWhereExpression() == null) {
            return Collections.EMPTY_LIST;
        }
        return ((LogicalExpression)query.getWhereExpression()).getArguments();
    }

    private static Query createQueryFromAgents(List inputList, ILogFilterCriteria element) {
        SimpleSearchQuery query = LogQueryBuilder.addAgents(inputList, element);
        SimpleOperand Operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        Operand.setType(CBEPackage.eINSTANCE.getCBECommonBaseEvent());
        query.getOutputElements().add((Object)Operand);
        return query;
    }

    private static SimpleSearchQuery addAgents(List inputList, ILogFilterCriteria element) {
        int s = inputList.size();
        TRCAgentProxy agentProxy = null;
        SimpleSearchQuery query = LogQueryBuilder.simulateOldWhereExpressions();
        int i = 0;
        while (i < s) {
            agentProxy = (TRCAgentProxy)inputList.get(i);
            LogQueryBuilder.addAgentToQuery(query, agentProxy, element);
            ++i;
        }
        return query;
    }

    private static SimpleSearchQuery simulateOldWhereExpressions() {
        SimpleSearchQuery query = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
        LogicalExpression l = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        l.setOperator(LogicalOperators.AND_LITERAL);
        query.setWhereExpression((WhereExpression)l);
        return query;
    }

    private static Query createQueryFromAgentProxy(TRCAgentProxy inputObject, ILogFilterCriteria element) {
        SimpleSearchQuery query = LogQueryBuilder.simulateOldWhereExpressions();
        SimpleOperand Operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        Operand.setType(CBEPackage.eINSTANCE.getCBECommonBaseEvent());
        query.getOutputElements().add((Object)Operand);
        LogQueryBuilder.addAgentToQuery(query, inputObject, element);
        return query;
    }

    private static List createWhereClause(EClass eClass, IFilterElement[] elements) {
        ArrayList<BinaryExpression> whereCriteria = new ArrayList<BinaryExpression>();
        EList attributes = eClass.getEAllAttributes();
        EAttribute attribute = null;
        int i = 0;
        while (i < elements.length) {
            attribute = LogQueryBuilder.findAttributeInList(elements[i].getAttribute(), (List)attributes);
            if (attribute != null) {
                whereCriteria.add(LogQueryBuilder.createBinaryExpression(elements[i], attribute));
            }
            ++i;
        }
        return whereCriteria;
    }

    private static BinaryExpression createBinaryExpression(IFilterElement element, EAttribute attribute) {
        BinaryExpression binaryExpression = ExtensionsFactory.eINSTANCE.createBinaryExpression();
        SimpleOperand Operand2 = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        Operand2.setFeature((EStructuralFeature)attribute);
        binaryExpression.setLeftOperand((Operand)Operand2);
        String value = element.getValue();
        if (element.getOperator().equals("=")) {
            if (value.indexOf(42) > -1) {
                value = value.replace('*', '%');
                binaryExpression.setOperator(RelationalOperators.LIKE_LITERAL);
            } else {
                binaryExpression.setOperator(RelationalOperators.EQ_LITERAL);
            }
        } else if (element.getOperator().equals("<")) {
            binaryExpression.setOperator(RelationalOperators.LT_LITERAL);
        } else if (element.getOperator().equals(">")) {
            binaryExpression.setOperator(RelationalOperators.GT_LITERAL);
        } else if (element.getOperator().equals("<>")) {
            binaryExpression.setOperator(RelationalOperators.NEQ_LITERAL);
        } else if (element.getOperator().equals("LIKE")) {
            binaryExpression.setOperator(RelationalOperators.LIKE_LITERAL);
        }
        LogQueryBuilder.setRightOperandValue(binaryExpression, LogQueryBuilder.convertToType(attribute.getEType(), value));
        return binaryExpression;
    }

    public static void setRightOperandValue(BinaryExpression binaryExpression, Object object) {
        SimpleOperand operand = null;
        if (binaryExpression.getRightOperands().isEmpty()) {
            operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
            binaryExpression.getRightOperands().add((Object)operand);
        } else {
            operand = (SimpleOperand)binaryExpression.getRightOperands().get(0);
        }
        if (object instanceof EStructuralFeature) {
            operand.setFeature((EStructuralFeature)object);
            return;
        }
        if (object instanceof EClass) {
            operand.setType((EClass)object);
            return;
        }
        if (object instanceof Integer) {
            operand.setValueType(EcorePackage.eINSTANCE.getEIntegerObject());
        } else if (object instanceof Double) {
            operand.setValueType(EcorePackage.eINSTANCE.getEDoubleObject());
        } else if (object instanceof Short) {
            operand.setValueType(EcorePackage.eINSTANCE.getEShortObject());
        } else if (object instanceof Long) {
            operand.setValueType(EcorePackage.eINSTANCE.getELongObject());
        } else if (object instanceof String) {
            operand.setValueType(EcorePackage.eINSTANCE.getEString());
        }
        operand.setValue(object);
    }

    private static Object convertToType(EClassifier attribute, String value) {
        if (attribute instanceof EDataType) {
            return EcoreFactory.eINSTANCE.createFromString((EDataType)attribute, value);
        }
        return value;
    }

    private static void formatFilterValue(String string) {
        StringBuffer sb = new StringBuffer();
        int l = string.length();
        int i = 0;
        while (i < l) {
            char ch = string.charAt(i);
            if (ch == '%') {
                sb.append("\\%");
            } else if (ch == '_') {
                sb.append("\\_");
            } else {
                sb.append(ch);
            }
            ++i;
        }
        string = sb.toString();
    }

    private static BinaryExpression createBinaryExpression(EAttribute attribute, RelationalOperators operator, Object value) {
        BinaryExpression binaryExpression = ExtensionsFactory.eINSTANCE.createBinaryExpression();
        SimpleOperand Operand2 = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        Operand2.setFeature((EStructuralFeature)attribute);
        binaryExpression.setLeftOperand((Operand)Operand2);
        binaryExpression.setOperator(operator);
        LogQueryBuilder.setRightOperandValue(binaryExpression, value);
        return binaryExpression;
    }

    public static List createOrderByClause(EClass eClass, ISortElement[] elements) {
        if (elements == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<OrderByElement> orderByCriteria = new ArrayList<OrderByElement>();
        EList attributes = eClass.getEAllAttributes();
        EAttribute attribute = null;
        int i = 0;
        while (i < elements.length) {
            attribute = LogQueryBuilder.findAttributeInList(elements[i].getSortColumn(), (List)attributes);
            if (attribute != null) {
                orderByCriteria.add(LogQueryBuilder.createOrderByElement(elements[i], attribute));
            }
            ++i;
        }
        return orderByCriteria;
    }

    private static OrderByElement createOrderByElement(ISortElement element, EAttribute attribute) {
        OrderByElement orderByElement = ExtensionsFactory.eINSTANCE.createOrderByElement();
        SimpleOperand Operand2 = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        Operand2.setFeature((EStructuralFeature)attribute);
        orderByElement.setOperand((Operand)Operand2);
        if (element.isAscending()) {
            orderByElement.setOperator(OrderByOperators.ASC_LITERAL);
        } else {
            orderByElement.setOperator(OrderByOperators.DESC_LITERAL);
        }
        return orderByElement;
    }

    private static EAttribute findAttributeInList(String name, List attributeList) {
        int s = attributeList.size();
        int i = 0;
        while (i < s) {
            EAttribute attr = (EAttribute)attributeList.get(i);
            if (attr.getName().equalsIgnoreCase(name)) {
                return attr;
            }
            ++i;
        }
        return null;
    }

    private static boolean isFilterInWhereClause(IFilterElement element, List whereClause) {
        return false;
    }

    public static boolean compare(Query query1, Query query2) {
        EList outputElements1 = query1.getOutputElements();
        EList outputElements2 = query2.getOutputElements();
        if (outputElements1.size() != outputElements2.size()) {
            return false;
        }
        int s = outputElements1.size();
        int i = 0;
        while (i < s) {
            SimpleOperand left1 = (SimpleOperand)outputElements1.get(i);
            SimpleOperand left2 = (SimpleOperand)outputElements2.get(i);
            if (left1 != null && left2 == null || left1 == null && left2 != null) {
                return false;
            }
            if (left1 != null && left2 != null && left1.getType() != left2.getType()) {
                return false;
            }
            if (left1 != null && left2 != null && left1.getFeature() != left2.getFeature()) {
                return false;
            }
            ++i;
        }
        EList sourceElements1 = query1.getSources();
        EList sourceElements2 = query2.getSources();
        if (sourceElements1.size() != sourceElements2.size()) {
            return false;
        }
        s = sourceElements1.size();
        int i2 = 0;
        while (i2 < s) {
            if (sourceElements1.get(i2) != null && !sourceElements1.get(i2).equals(sourceElements2.get(i2))) {
                return false;
            }
            ++i2;
        }
        if (query1 instanceof SimpleSearchQuery && query2 instanceof SimpleSearchQuery) {
            WhereExpression w1 = ((SimpleSearchQuery)query1).getWhereExpression();
            WhereExpression w2 = ((SimpleSearchQuery)query2).getWhereExpression();
            TreeIterator w1i = w1.eAllContents();
            TreeIterator w2i = w2.eAllContents();
            while (w1i.hasNext() && w2i.hasNext()) {
                EObject e1 = (EObject)w1i.next();
                EObject e2 = (EObject)w2i.next();
                if (e1 == null && e2 == null) continue;
                if (e1 != null && e2 == null) {
                    return false;
                }
                if (e1 == null && e2 != null) {
                    return false;
                }
                if (e1.eClass() != e2.eClass()) {
                    return false;
                }
                if (e1 instanceof LogicalExpression) {
                    if (((LogicalExpression)e1).getOperator() != ((LogicalExpression)e2).getOperator()) {
                        return false;
                    }
                    if (((LogicalExpression)e1).getArguments().size() == ((LogicalExpression)e2).getArguments().size()) continue;
                    return false;
                }
                if (!(e1 instanceof BinaryExpression)) continue;
                BinaryExpression expression1 = (BinaryExpression)e1;
                BinaryExpression expression2 = (BinaryExpression)e2;
                if (((SimpleOperand)expression1.getLeftOperand()).getFeature() != ((SimpleOperand)expression2.getLeftOperand()).getFeature()) {
                    return false;
                }
                if (((SimpleOperand)expression1.getLeftOperand()).getType() != ((SimpleOperand)expression2.getLeftOperand()).getType()) {
                    return false;
                }
                Object v1 = ((SimpleOperand)expression1.getLeftOperand()).getValue();
                Object v2 = ((SimpleOperand)expression2.getLeftOperand()).getValue();
                if (v1 == null && v2 != null) {
                    return false;
                }
                if (v1 != null && !v1.equals(v2)) {
                    return false;
                }
                if (expression1.getOperator() != expression2.getOperator()) {
                    return false;
                }
                if (expression1.getRightOperands().size() != expression2.getRightOperands().size()) {
                    return false;
                }
                int i3 = 0;
                while (i3 < expression1.getRightOperands().size()) {
                    if (((SimpleOperand)expression1.getRightOperands().get(i3)).getFeature() != ((SimpleOperand)expression2.getRightOperands().get(i3)).getFeature()) {
                        return false;
                    }
                    if (((SimpleOperand)expression1.getRightOperands().get(i3)).getType() != ((SimpleOperand)expression2.getRightOperands().get(i3)).getType()) {
                        return false;
                    }
                    v1 = ((SimpleOperand)expression1.getRightOperands().get(i3)).getValue();
                    v2 = ((SimpleOperand)expression2.getRightOperands().get(i3)).getValue();
                    if (v1 == null && v2 != null) {
                        return false;
                    }
                    if (v1 != null && !v1.equals(v2)) {
                        return false;
                    }
                    ++i3;
                }
            }
        }
        return true;
    }
}

