/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.util;

import java.awt.EventQueue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.internal.logging.core.Constants;
import org.eclipse.hyades.logging.core.LoggingCorePlugin;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.ContentHandler;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.impl.TemplateContentHandlerImpl;

public class EventHelpers {
    private static boolean isJava14xRunTime = true;
    private static ResourceBundle resourceBundle = null;
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
    private static final String DEFAULT_FORMATTED_DATE_FORMAT = "MMMM d, yyyy h:mm:ss.SSS a z";
    private static final List CBE_ORDERED_LISTS;
    private static final String CBE_CASE_INSENSITIVE_PROPERTY;
    private static final String RESOURCE_BUNDLE_NAME = "org.eclipse.hyades.logging.core.properties.plugin";
    private static final String LINE_SEPARATOR;
    public static final Object LOCK;

    public static void serializableRead(EObject eObject, ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        EList eList = eObject.eClass().getEAllStructuralFeatures();
        int n = 0;
        while (n < eList.size()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)eList.get(n);
            Object object = objectInputStream.readObject();
            eObject.eSet(eStructuralFeature, object);
            ++n;
        }
    }

    public static void serializableWrite(EObject eObject, ObjectOutputStream objectOutputStream) throws IOException {
        EList eList = eObject.eClass().getEAllStructuralFeatures();
        int n = 0;
        while (n < eList.size()) {
            Object object = eObject.eGet((EStructuralFeature)eList.get(n));
            if (object instanceof EList) {
                ArrayList arrayList = new ArrayList((List)object);
                objectOutputStream.writeObject(arrayList);
            } else {
                objectOutputStream.writeObject(object);
            }
            ++n;
        }
    }

    public static boolean compareEObject(Object object, Object object2) {
        if (object2 == null) {
            return false;
        }
        if (!(object instanceof EObject) || !(object2 instanceof EObject)) {
            return false;
        }
        if (object == object2) {
            return true;
        }
        if (!object.getClass().equals(object2.getClass())) {
            return false;
        }
        EObject eObject = (EObject)object;
        EObject eObject2 = (EObject)object2;
        boolean bl = true;
        EList eList = eObject.eClass().getEAllStructuralFeatures();
        int n = 0;
        while (n < eList.size()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)eList.get(n);
            Object object3 = eObject.eGet(eStructuralFeature);
            Object object4 = eObject2.eGet(eStructuralFeature);
            boolean bl2 = eObject.eIsSet(eStructuralFeature);
            boolean bl3 = eObject2.eIsSet(eStructuralFeature);
            if (object3 != null && object4 == null || object3 == null && object4 != null || bl2 != bl3) {
                bl = false;
                break;
            }
            if (object3 != null) {
                bl = object3 instanceof List ? (CBE_ORDERED_LISTS.contains(eStructuralFeature.getName()) ? EventHelpers.compareEList((List)object3, (List)object4, true) : EventHelpers.compareEList((List)object3, (List)object4, false)) : (eStructuralFeature.getName().equals(CBE_CASE_INSENSITIVE_PROPERTY) ? ((String)object3).equalsIgnoreCase((String)object4) : object3.equals(object4));
                if (!bl) break;
            }
            ++n;
        }
        return bl;
    }

    public static long dateToLong(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        Date date = null;
        long l = 0L;
        int n2 = -1;
        if (string.length() < 19) {
            throw new IllegalArgumentException(string + " is not a valid xsd:dateTime");
        }
        if (string.indexOf(90) >= 19) {
            n2 = string.indexOf(90);
            string2 = string.substring(0, n2);
            n = 90;
        } else if (string.indexOf(43) >= 19) {
            n2 = string.indexOf(43);
            string2 = string.substring(0, n2);
            n = string.charAt(n2);
            string4 = string.substring(n2 + 1);
        } else if (string.indexOf(45, 19) >= 19) {
            n2 = string.indexOf(45, 19);
            string2 = string.substring(0, n2);
            n = string.charAt(n2);
            string4 = string.substring(n2 + 1);
        } else {
            string2 = string;
        }
        int n3 = string2.indexOf(46);
        if (n3 > 0) {
            if (n2 != -1) {
                string2 = string.substring(0, n2);
            }
            string3 = string2.substring(n3 + 1);
        }
        if (string2 != null) {
            int n4 = string.indexOf(45);
            if (n4 == -1) {
                throw new IllegalArgumentException(string + " is not a valid xsd:dateTime. Cannot find '-'.");
            }
            String string5 = string2.substring(0, n4);
            if (string5.length() == 4 && Integer.parseInt(string5) > 1969) {
                try {
                    SimpleDateFormat simpleDateFormat = EventHelpers.simpleDateFormat;
                    synchronized (simpleDateFormat) {
                        date = EventHelpers.simpleDateFormat.parse(string2);
                    }
                }
                catch (ParseException parseException) {
                    throw new IllegalArgumentException(string + " is not a valid xsd:dateTime. Parse error is: " + parseException.getMessage());
                }
            }
        }
        if (date != null) {
            l = date.getTime();
            if (string3 != null && string3.length() > 0) {
                long l2 = Long.parseLong(string3);
                int n5 = string3.length();
                if (n5 == 1) {
                    l2 *= 100L;
                } else if (n5 == 2) {
                    l2 *= 10L;
                } else if (n5 != 3) {
                    l2 = Long.parseLong(string3.substring(0, 3));
                }
                l += l2;
            }
            if (n != 0 && string4 != null && string4.length() == 5) {
                long l3 = Long.parseLong(string4.substring(0, 2));
                long l4 = Long.parseLong(string4.substring(3));
                if (n == 43) {
                    l = l - l3 * 60L * 60L * 1000L - l4 * 60L * 1000L;
                } else if (n == 45) {
                    l = l + l3 * 60L * 60L * 1000L + l4 * 60L * 1000L;
                }
            } else if (string4 != null && !string4.equals("Z")) {
                l = 0L;
            }
        }
        return l;
    }

    public static String longToDate(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(l + " cannot be negative.");
        }
        String string = null;
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(simpleTimeZone);
        gregorianCalendar.setTime(new Date(l));
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2);
        ++n2;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        int n7 = gregorianCalendar.get(14);
        StringBuffer stringBuffer = new StringBuffer(35);
        stringBuffer.append(n);
        stringBuffer.append('-');
        if (n2 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n2);
        stringBuffer.append('-');
        if (n3 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n3);
        stringBuffer.append('T');
        if (n4 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n4);
        stringBuffer.append(':');
        if (n5 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n5);
        stringBuffer.append(':');
        if (n6 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n6);
        stringBuffer.append(".");
        if (n7 < 10) {
            stringBuffer.append("00");
        } else if (n7 < 100) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n7);
        stringBuffer.append("Z");
        string = stringBuffer.toString();
        return string;
    }

    private static boolean compareEList(List list, List list2, boolean bl) {
        if (list.size() != list2.size()) {
            return false;
        }
        boolean bl2 = true;
        Object[] objectArray = list2.toArray(new Object[list2.size()]);
        int n = 0;
        while (n < objectArray.length) {
            boolean bl3 = false;
            Object e = list.get(n);
            if (bl) {
                Object object = objectArray[n];
                bl3 = e.equals(object);
            } else {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    Object object = objectArray[n2];
                    if (object != null && e.equals(object)) {
                        bl3 = true;
                        objectArray[n2] = null;
                        break;
                    }
                    ++n2;
                }
            }
            if (!bl3) {
                bl2 = false;
                break;
            }
            ++n;
        }
        return bl2;
    }

    public static String getString(String string) {
        if (resourceBundle == null) {
            try {
                resourceBundle = LoggingCorePlugin.getDefault().getResourceBundle();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (resourceBundle == null) {
                try {
                    resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME);
                }
                catch (MissingResourceException missingResourceException) {
                    return string;
                }
            }
        }
        try {
            return resourceBundle.getString(string.trim()).trim();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String getString(String string, Object object) {
        return EventHelpers.getString(string, new Object[]{object});
    }

    public static String getString(String string, Object object, Object object2) {
        return EventHelpers.getString(string, new Object[]{object, object2});
    }

    public static String getString(String string, Object object, Object object2, Object object3) {
        return EventHelpers.getString(string, new Object[]{object, object2, object3});
    }

    public static String getString(String string, Object object, Object object2, Object object3, Object object4) {
        return EventHelpers.getString(string, new Object[]{object, object2, object3, object4});
    }

    public static String getString(String string, Object[] objectArray) {
        try {
            return MessageFormat.format(EventHelpers.getString(string), objectArray);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static ExtendedDataElement convertToExtendedDataElement(Throwable throwable) {
        return EventHelpers.convertToExtendedDataElement(throwable, "Throwable");
    }

    public static ExtendedDataElement convertToExtendedDataElement(Throwable throwable, String string) {
        ExtendedDataElement extendedDataElement = EventFactory.eINSTANCE.createExtendedDataElement();
        extendedDataElement.setName(string);
        extendedDataElement.setTypeAsInt(16);
        if (throwable == null) {
            extendedDataElement.setValues(new String[]{null});
        } else {
            if (isJava14xRunTime) {
                try {
                    Object object;
                    Object[] objectArray = (Object[])throwable.getClass().getMethod("getStackTrace", null).invoke((Object)throwable, null);
                    if (objectArray.length > 0) {
                        object = EventHelpers.getExtendedDataElementValuesArray(throwable.toString());
                        String[] stringArray = new String[((String[])object).length + objectArray.length];
                        System.arraycopy(object, 0, stringArray, 0, ((String[])object).length);
                        int n = 0;
                        while (n < objectArray.length) {
                            stringArray[n + ((String[])object).length] = objectArray[n].toString();
                            ++n;
                        }
                        extendedDataElement.setValues(stringArray);
                    } else {
                        extendedDataElement.setValues(EventHelpers.getExtendedDataElementValuesArray(throwable.toString()));
                    }
                    object = (Throwable)throwable.getClass().getMethod("getCause", null).invoke((Object)throwable, null);
                    if (object != null) {
                        extendedDataElement.addChild(EventHelpers.convertToExtendedDataElement((Throwable)object, "Cause"));
                    }
                    return extendedDataElement;
                }
                catch (Throwable throwable2) {
                    isJava14xRunTime = false;
                }
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
            throwable.printStackTrace(printWriter);
            if (!printWriter.checkError()) {
                StringTokenizer stringTokenizer = new StringTokenizer(byteArrayOutputStream.toString().trim(), LINE_SEPARATOR);
                int n = stringTokenizer.countTokens();
                if (n > 1) {
                    String[] stringArray = EventHelpers.getExtendedDataElementValuesArray(stringTokenizer.nextToken());
                    String[] stringArray2 = new String[stringArray.length + --n];
                    System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                    String string2 = null;
                    int n2 = 0;
                    while (n2 < n) {
                        string2 = stringTokenizer.nextToken().trim();
                        stringArray2[n2 + stringArray.length] = string2.startsWith("at") ? string2.substring(2).trim() : string2;
                        ++n2;
                    }
                    extendedDataElement.setValues(stringArray2);
                } else {
                    extendedDataElement.setValues(EventHelpers.getExtendedDataElementValuesArray(stringTokenizer.nextToken()));
                }
            } else {
                extendedDataElement.setValues(EventHelpers.getExtendedDataElementValuesArray(throwable.toString()));
            }
            printWriter.close();
        }
        return extendedDataElement;
    }

    public static String[] getExtendedDataElementValuesArray(String string) {
        if (string == null) {
            return new String[]{null};
        }
        int n = string.length();
        if (n > 1024) {
            String[] stringArray = new String[(int)Math.ceil((double)n / 1024.0)];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = string.substring(n2 * 1024, Math.min((n2 + 1) * 1024, n));
                ++n2;
            }
            return stringArray;
        }
        return new String[]{string};
    }

    public static String getFormattedDateString(long l) throws IllegalArgumentException {
        return EventHelpers.getFormattedDateString(l, DEFAULT_FORMATTED_DATE_FORMAT);
    }

    public static String getFormattedDateString(long l, String string) throws IllegalArgumentException {
        if (l < 0L) {
            throw new IllegalArgumentException(l + " cannot be negative.");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.ENGLISH);
        simpleDateFormat.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT")));
        return simpleDateFormat.format(new Date(l));
    }

    public static String getFormattedDateString(String string) throws IllegalArgumentException {
        return EventHelpers.getFormattedDateString(string, DEFAULT_FORMATTED_DATE_FORMAT);
    }

    public static String getFormattedDateString(String string, String string2) throws IllegalArgumentException {
        long l = EventHelpers.dateToLong(string);
        TimeZone timeZone = null;
        char c = string.trim().charAt(string.trim().length() - 6);
        timeZone = c == '+' || c == '-' ? TimeZone.getTimeZone("GMT" + string.substring(string.lastIndexOf(c)).trim()) : new SimpleTimeZone(0, "GMT");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, Locale.ENGLISH);
        simpleDateFormat.setCalendar(new GregorianCalendar(timeZone));
        return simpleDateFormat.format(new Date(l));
    }

    public static CommonBaseEvent convertObjectToCommonBaseEvent(Object object, int n) {
        if (object instanceof CommonBaseEvent) {
            return (CommonBaseEvent)object;
        }
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        EventHelpers.convertObjectToCommonBaseEvent(commonBaseEvent, object, n);
        return commonBaseEvent;
    }

    public static void convertObjectToCommonBaseEvent(CommonBaseEvent commonBaseEvent, Object object, int n) {
        if (object instanceof CommonBaseEvent) {
            TemplateContentHandlerImpl templateContentHandlerImpl = new TemplateContentHandlerImpl();
            templateContentHandlerImpl.setTemplateEvent((CommonBaseEvent)object);
            ContentHandler contentHandler = commonBaseEvent.getContentHandler();
            commonBaseEvent.setContentHandler(templateContentHandlerImpl);
            try {
                commonBaseEvent.complete();
            }
            catch (CompletionException completionException) {
                // empty catch block
            }
            commonBaseEvent.setContentHandler(contentHandler);
        } else {
            if (commonBaseEvent.getGlobalInstanceId() == null) {
                commonBaseEvent.setGlobalInstanceId(EventFactory.eINSTANCE.createGlobalInstanceId());
            }
            if (!commonBaseEvent.isSetCreationTime()) {
                commonBaseEvent.setCreationTimeAsLong(System.currentTimeMillis());
            }
            if (commonBaseEvent.getSituation() == null) {
                Situation situation = EventFactory.eINSTANCE.createSituation();
                situation.setReportSituation("INTERNAL", "LOG");
                commonBaseEvent.setSituation(situation);
            }
            if (commonBaseEvent.getSourceComponentId() == null) {
                commonBaseEvent.setSourceComponentId(null, "Logging", "Logger", "Logging_Application", "Application", Constants.LOCAL_HOST_IP_ADDRESS, "IPV4");
            }
            commonBaseEvent.addExtendedDataElement(EventHelpers.convertObjectToExtendedDataElement(object, null, n, 0));
        }
    }

    private static ExtendedDataElement convertObjectToExtendedDataElement(Object object, String string, int n, int n2) {
        ExtendedDataElement extendedDataElement = EventFactory.eINSTANCE.createExtendedDataElement();
        if (object != null) {
            Class<?> clazz = object.getClass();
            if (EventHelpers.isSimpleType(object)) {
                String string2 = object.toString().trim();
                int n3 = string2.length();
                if (n3 > 1024) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    int n4 = 0;
                    while (n4 < n3) {
                        arrayList.add(string2.substring(n4, Math.min(n4 + 1024, n3)));
                        n4 += 1024;
                    }
                    extendedDataElement.setValuesAsStringArray(arrayList.toArray(new String[arrayList.size()]));
                } else {
                    extendedDataElement.setValuesAsString(string2);
                }
            } else if (clazz.isArray()) {
                if (object instanceof boolean[]) {
                    boolean[] blArray = (boolean[])object;
                    int n5 = 0;
                    while (n5 < blArray.length) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(new Boolean(blArray[n5]), null, n, n2));
                        ++n5;
                    }
                } else if (object instanceof char[]) {
                    char[] cArray = (char[])object;
                    int n6 = 0;
                    while (n6 < cArray.length) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(new Character(cArray[n6]), null, n, n2));
                        ++n6;
                    }
                } else if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    int n7 = 0;
                    while (n7 < byArray.length) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(new Byte(byArray[n7]), null, n, n2));
                        ++n7;
                    }
                } else if (object instanceof short[]) {
                    short[] sArray = (short[])object;
                    int n8 = 0;
                    while (n8 < sArray.length) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(new Short(sArray[n8]), null, n, n2));
                        ++n8;
                    }
                } else if (object instanceof int[]) {
                    int[] nArray = (int[])object;
                    int n9 = 0;
                    while (n9 < nArray.length) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(new Integer(nArray[n9]), null, n, n2));
                        ++n9;
                    }
                } else if (object instanceof long[]) {
                    long[] lArray = (long[])object;
                    int n10 = 0;
                    while (n10 < lArray.length) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(new Long(lArray[n10]), null, n, n2));
                        ++n10;
                    }
                } else if (object instanceof float[]) {
                    float[] fArray = (float[])object;
                    int n11 = 0;
                    while (n11 < fArray.length) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(new Float(fArray[n11]), null, n, n2));
                        ++n11;
                    }
                } else if (object instanceof double[]) {
                    double[] dArray = (double[])object;
                    int n12 = 0;
                    while (n12 < dArray.length) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(new Double(dArray[n12]), null, n, n2));
                        ++n12;
                    }
                } else if (n2 == n) {
                    extendedDataElement.addChild(EventHelpers.createEndOfNestingExtendedDataElement(string));
                } else {
                    Object[] objectArray = (Object[])object;
                    int n13 = 0;
                    while (n13 < objectArray.length) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(objectArray[n13], null, n, n2 + 1));
                        ++n13;
                    }
                }
            } else if (object instanceof Collection) {
                if (n2 == n) {
                    extendedDataElement.addChild(EventHelpers.createEndOfNestingExtendedDataElement(string));
                } else {
                    Iterator iterator = ((Collection)object).iterator();
                    while (iterator.hasNext()) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(iterator.next(), null, n, n2 + 1));
                    }
                }
            } else if (object instanceof Enumeration) {
                if (n2 == n) {
                    extendedDataElement.addChild(EventHelpers.createEndOfNestingExtendedDataElement(string));
                } else {
                    Enumeration enumeration = (Enumeration)object;
                    while (enumeration.hasMoreElements()) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(enumeration.nextElement(), null, n, n2 + 1));
                    }
                }
            } else if (object instanceof Iterator) {
                if (n2 == n) {
                    extendedDataElement.addChild(EventHelpers.createEndOfNestingExtendedDataElement(string));
                } else {
                    Iterator iterator = (Iterator)object;
                    while (iterator.hasNext()) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(iterator.next(), null, n, n2 + 1));
                    }
                }
            } else if (object instanceof Thread) {
                Thread thread = (Thread)object;
                extendedDataElement.addChild("Name", thread.getName());
                extendedDataElement.addChild("Priority", String.valueOf(thread.getPriority()));
                extendedDataElement.addChild("Group", thread.getThreadGroup().getName());
            } else if (object instanceof Throwable) {
                extendedDataElement = EventHelpers.convertToExtendedDataElement((Throwable)object);
            } else if (object instanceof Map) {
                if (n2 == n) {
                    extendedDataElement.addChild(EventHelpers.createEndOfNestingExtendedDataElement(string));
                } else {
                    Map map = (Map)object;
                    Iterator iterator = map.keySet().iterator();
                    ExtendedDataElement extendedDataElement2 = null;
                    ExtendedDataElement extendedDataElement3 = null;
                    ExtendedDataElement extendedDataElement4 = null;
                    int n14 = 1;
                    while (iterator.hasNext()) {
                        Object k = iterator.next();
                        extendedDataElement2 = EventFactory.eINSTANCE.createExtendedDataElement();
                        extendedDataElement2.setName("Entry_".concat(String.valueOf(n14++)));
                        extendedDataElement2.setTypeAsInt(0);
                        extendedDataElement3 = EventFactory.eINSTANCE.createExtendedDataElement();
                        extendedDataElement3.setName("Key");
                        extendedDataElement3.setTypeAsInt(0);
                        extendedDataElement3.addChild(EventHelpers.convertObjectToExtendedDataElement(k, null, n, n2 + 1));
                        extendedDataElement2.addChild(extendedDataElement3);
                        extendedDataElement4 = EventFactory.eINSTANCE.createExtendedDataElement();
                        extendedDataElement4.setName("Value");
                        extendedDataElement4.setTypeAsInt(0);
                        extendedDataElement4.addChild(EventHelpers.convertObjectToExtendedDataElement(map.get(k), null, n, n2 + 1));
                        extendedDataElement2.addChild(extendedDataElement4);
                        extendedDataElement.addChild(extendedDataElement2);
                    }
                }
            } else if (!(object instanceof EventQueue)) {
                if (object instanceof Class) {
                    Class clazz2 = (Class)object;
                    extendedDataElement.addChild("Name", EventHelpers.getClassName(clazz2));
                    if (clazz2.isPrimitive()) {
                        extendedDataElement.addChild("Type", "primitive");
                    } else if (clazz2.isArray()) {
                        extendedDataElement.addChild("Type", "array");
                    } else if (clazz2.isInterface()) {
                        extendedDataElement.addChild("Type", "interface");
                    } else {
                        extendedDataElement.addChild("Type", "class");
                    }
                    Package package_ = clazz2.getPackage();
                    if (package_ != null) {
                        extendedDataElement.addChild("Package", package_.getName());
                    }
                    extendedDataElement.addChild("Modifers", Modifier.toString(clazz2.getModifiers()));
                    extendedDataElement.addChild("Superclass", EventHelpers.getClassName(clazz2.getSuperclass()));
                } else {
                    Method[] methodArray = clazz.getMethods();
                    String string3 = null;
                    Object object2 = null;
                    int n15 = 0;
                    while (n15 < methodArray.length) {
                        string3 = methodArray[n15].getName().trim();
                        if (string3.length() > 3 && string3.startsWith("get") && methodArray[n15].getParameterTypes().length == 0) {
                            try {
                                object2 = methodArray[n15].invoke(object, null);
                            }
                            catch (Throwable throwable) {
                                object2 = null;
                            }
                            if (object2 != null && !EventHelpers.isSimpleType(object2) && n2 == n) {
                                extendedDataElement.addChild(EventHelpers.createEndOfNestingExtendedDataElement(string3.substring(3)));
                            } else {
                                extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(object2, string3.substring(3), n, n2 + 1));
                            }
                        }
                        ++n15;
                    }
                }
            }
        }
        extendedDataElement.setName(EventHelpers.getClassName(object));
        if (extendedDataElement.getType() == null) {
            extendedDataElement.setTypeAsInt(0);
        }
        if (string != null && string.trim().length() > 0) {
            extendedDataElement.addChild("Instance_Name", string);
        }
        return extendedDataElement;
    }

    private static ExtendedDataElement createEndOfNestingExtendedDataElement(String string) {
        ExtendedDataElement extendedDataElement = EventFactory.eINSTANCE.createExtendedDataElement();
        extendedDataElement.setName("End_Of_Nesting");
        extendedDataElement.setTypeAsInt(0);
        if (string != null && string.trim().length() > 0) {
            extendedDataElement.addChild("Instance_Name", string);
        }
        return extendedDataElement;
    }

    private static String getClassName(Object object) {
        if (object == null) {
            return "null";
        }
        Class<?> clazz = object.getClass();
        String string = clazz.getName().trim();
        if (clazz.isArray()) {
            int n = string.lastIndexOf(91) + 1;
            String string2 = string.substring(n).trim();
            char c = string2.charAt(0);
            String string3 = "";
            string3 = c == 'L' && string2.endsWith(";") ? string2.substring(1, string2.length() - 1) : (c == 'B' ? "byte" : (c == 'C' ? "char" : (c == 'D' ? "double" : (c == 'F' ? "float" : (c == 'I' ? "int" : (c == 'J' ? "long" : (c == 'S' ? "short" : (c == 'Z' ? "boolean" : string2.substring(1, string2.length())))))))));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string3);
            int n2 = string.substring(0, n).trim().length();
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append("[]");
                ++n3;
            }
            return stringBuffer.toString();
        }
        return string;
    }

    private static boolean isSimpleType(Object object) {
        return object.getClass().isPrimitive() || object instanceof Boolean || object instanceof Character || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof BigDecimal || object instanceof BigInteger || object instanceof String || object instanceof StringBuffer;
    }

    static {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(new SimpleTimeZone(0, "UTC"));
        gregorianCalendar.setLenient(false);
        simpleDateFormat.setLenient(false);
        simpleDateFormat.setCalendar(gregorianCalendar);
        CBE_ORDERED_LISTS = Arrays.asList(EventPackage.eINSTANCE.getExtendedDataElement_Values().getName(), EventPackage.eINSTANCE.getMsgDataElement_MsgCatalogTokens().getName());
        CBE_CASE_INSENSITIVE_PROPERTY = EventPackage.eINSTANCE.getExtendedDataElement_HexValue().getName();
        LINE_SEPARATOR = System.getProperty("line.separator");
        LOCK = new Object();
    }
}

