/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceSDPlugin.java,v 1.11 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.uml2sd.trace.preferences.ITraceInteractionPreferenceListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class TraceSDPlugin extends AbstractUIPlugin {

	// Id of the Trace Interactions view -> also in plugin.xml: please keep in sync
	public static final String UML2SD_TRACE_VIEW_ID =
		"org.eclipse.hyades.uml2sd.trace.view.TraceSDView"; //$NON-NLS-1$

	//The shared instance.
	private static TraceSDPlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;
	
	/**
	 * The constructor.
	 */
	public TraceSDPlugin() {
		super();
		plugin = this;
	}

	public void start(BundleContext context) throws Exception {
		super.start(context);
		debugTracePlugin("Start called"); //$NON-NLS-1$
		try {
			this.resourceBundle = Platform.getResourceBundle(this.getBundle());
		} catch (MissingResourceException x) {
			this.resourceBundle = null;
		}
	}
	
	public void stop(BundleContext context) throws Exception {
		if (images != null) {
			for (Iterator e = images.values().iterator(); e.hasNext();) {
				Object next = e.next();
				if (next instanceof Image && !((Image) next).isDisposed()) {
					((Image) next).dispose();
				}
			}
			images.clear();
			images = null;
		}
		super.stop(context);
		debugTracePlugin("stop finished"); //$NON-NLS-1$
	}
	/**
	 * Returns the shared instance.
	 */
	public static TraceSDPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#initializeDefaultPreferences(org.eclipse.jface.preference.IPreferenceStore)
	 */
	protected void initializeDefaultPreferences(IPreferenceStore store) {
		store.setDefault(ITraceInteractionPreferenceListener.PAGE_SIZE, 128*1024);
	}
	
	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = TraceSDPlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * @return the resource bundle
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}

	/**
	 * @return the plugin id
	 */
	public static String getId()
	{
		return getDefault().getBundle().getSymbolicName(); 
	}
	
	private static URL BASIC_URL = null;
	private static Hashtable images = null;
	/**
	 * Load image with that _name and return it
	 */
	public static Image getResourceImage( String _name )
	{
		if (getDefault() == null) {
			return null;
		}
		if (images != null) {
			Image img = (Image)images.get(_name);
			if (img != null &&
				!img.isDisposed()) {
				debugTracePlugin("Optimizing for image "+_name); //$NON-NLS-1$
				return img;
			}
		} else {
			images = new Hashtable();
		}
		ImageDescriptor imgd = getResourceImageDescriptor(_name);
		if (imgd == null) {
			return null;
		}
		Image img = imgd.createImage();
		images.put(_name, img);
		return img;
	}
	
	/**
	 * @param _name
	 * @return
	 */
	public static ImageDescriptor getResourceImageDescriptor(String _name) {
		if (BASIC_URL == null) {
			try {
				BASIC_URL = new URL( "platform", "localhost", "plugin"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			} catch (MalformedURLException e) {
				e.printStackTrace();
				return null;
			}
		}
		ImageDescriptor imgd;
		try {
			URL url = new URL( BASIC_URL, "plugin/org.eclipse.hyades.uml2sd.trace/icons/"+_name);  //$NON-NLS-1$
			imgd = ImageDescriptor.createFromURL(url);
			debugTracePlugin("Getting image "+url); //$NON-NLS-1$
		} catch (MalformedURLException e) {
			imgd = ImageDescriptor.getMissingImageDescriptor();
			debugTracePlugin("Missing image "+BASIC_URL+_name); //$NON-NLS-1$
		}
		return imgd;
	}

	/**
	 * Log system of the plugin
	 */
	public static boolean debugMatch  = checkForDebugTrace("org.eclipse.hyades.uml2sd.trace/match"); //$NON-NLS-1$
	public static boolean debugLoader = checkForDebugTrace("org.eclipse.hyades.uml2sd.trace/loader"); //$NON-NLS-1$
	public static boolean debugEvents = checkForDebugTrace("org.eclipse.hyades.uml2sd.trace/events"); //$NON-NLS-1$
	public static boolean debugPlugin = checkForDebugTrace("org.eclipse.hyades.uml2sd.trace/plugin"); //$NON-NLS-1$
	
	/**
	 * @param option
	 * @return
	 */
	private static boolean checkForDebugTrace(String option) {
		String value = Platform.getDebugOption(option);
		if (value != null && value.equalsIgnoreCase("true")) { //$NON-NLS-1$
			return true;
		}
		return false;
	}
	/**
	 * @param msg
	 */
	public static void debugTraceMatch(String msg) {
		if (debugMatch) {
			System.out.println(msg);
		}
	}

	/**
	 * @param msg
	 */
	public static void debugTraceLoader(String msg) {
		if (debugLoader) {
			System.out.println(msg);
		}
	}

	/**
	 * @param msg
	 */
	public static void debugTraceEvents(String msg) {
		if (debugEvents) {
			System.out.println(msg);
		}
	}

	/**
	 * @param msg
	 */
	public static void debugTracePlugin(String msg) {
		if (debugPlugin) {
			System.out.println(msg);
		}
	}

}
