/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceGraphNodeAction.java,v 1.7 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.actions.internal;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.BaseLifelineLoader;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/**
 * Abstract class for objectContribution action delegates
 */
public abstract class TraceGraphNodeAction implements IObjectActionDelegate {

	protected IAction action;
	protected IWorkbenchPart targetPart;
	protected ArrayList graphNodes;
	
	/**
	 * @see org.eclipse.ui.IObjectActionDelegate#setActivePart(org.eclipse.jface.action.IAction, org.eclipse.ui.IWorkbenchPart)
	 */
	public void setActivePart(IAction action_, IWorkbenchPart targetPart_) {
		TraceSDPlugin.debugTraceEvents(this+" setActivePart("+action_+", "+targetPart_+")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		if (targetPart_ instanceof org.eclipse.hyades.uml2sd.ui.view.SDView) {
			action = action_;
			targetPart = targetPart_;
		}
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action_) {
		TraceSDPlugin.debugTraceEvents(this+" run("+action+")"); //$NON-NLS-1$ //$NON-NLS-2$
		if (action_ == action && targetPart != null && graphNodes != null) {
			IUml2SDLoader loader = LoadersManager.getLoadersManager().getCurrentLoader(TraceSDPlugin.UML2SD_TRACE_VIEW_ID);
			if (loader instanceof BaseLifelineLoader) {
				run();
			}
		}
	}
	
	/**
	 * @param loader
	 */
	public abstract void run();

	/**
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action_, ISelection selection_) {
		TraceSDPlugin.debugTraceEvents(this+" selectionChanged("+action+", "+selection_+")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		if (action_ == action) {
			graphNodes = new ArrayList();
			if (selection_ instanceof IStructuredSelection) {
				IStructuredSelection s = (IStructuredSelection)selection_;
				for (Iterator i = s.iterator(); i.hasNext(); ) {
					Object o = i.next();
					if (o instanceof GraphNode) {
						graphNodes.add(o);
						TraceSDPlugin.debugTraceEvents(this+" selectionChanged(): adding "+o); //$NON-NLS-1$
					}
				}
			}
		}
	}

}
