/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ClassInteractions.java,v 1.14 2005/03/18 15:27:04 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;

/**
 * This is the concrete class for class interaction loader
 */
public class ClassInteractions extends BaseLifelineLoader {

	/**
	 * Constructor
	 */
	public ClassInteractions() {
		parent = new ThreadInteractions();
	}
	
	/**
	 * The lifeline to be used for any instance of a class is the class itself
	 */
	public EObject getLifelineEObjectFromMethodInvocation(TRCFullMethodInvocation mi) {
		return mi.getMethod().getDefiningClass(); // TRCClass
	}

	/**
	 * The name of the lifeline is the name of the class
	 */
	public String getLifeLineTitle(EObject eo, boolean long_) {
		TRCClass cl = (TRCClass)eo;
		return cl.getName() +
			   (!long_ && cl.getPackage() != null ? (" ("+cl.getPackage().getName()+")") : ""); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-2 //$NON-NLS-3$
	}

	/**
	 * The runtimeId of agentProxy and the lifeline title
	 */
	public String getLifeLineId(EObject eo) {
		TRCAgentProxy ap;
		ap = ((TRCClass)eo).getPackage().getProcess().getAgent().getAgentProxy();
		return ap.getRuntimeId()+"#"+getLifeLineTitle(eo, true); //$NON-NLS-1$
	}
	
	/**
	 * The category of such a lifeline is invariably the Classes category
	 */
	public int getLifeLineCategory(EObject eo) {
		return TraceInteractions.CATEGORY_CLASSES;
	}
	
	/**
	 * This is the class interactions, nothing else
	 */
	public String getFinalTitleString() {
		return TraceSDPlugin.getResourceString("STR_UML2SD_CLASS_INTERACTION"); //$NON-NLS-1$
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getLifelineType(org.eclipse.emf.ecore.EObject)
	 */
	public String getLifelineType(EObject eObject) {
		return TraceSDPlugin.getResourceString("STR_CLASS"); //$NON-NLS-1$;
	}

	/**
	 * @return a string carrying the lifeline type
	 */
	public String getLifelineTypeName() {
		return TraceSDPlugin.getResourceString("STR_CLASS"); //$NON-NLS-1$;
	}

}
