/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ILifelineLoader.java,v 1.9 2005/03/18 15:27:04 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;

/**
 * This interface caracterizes a lifeline loader: something that is able to decide what are
 * two distinct lifelines.
 */
public interface ILifelineLoader {
	
	/**
	 * @return the parent lifeline loader or null if none
	 */
	public ILifelineLoader getParent();

	/**
	 * Associates a EObject denoting a lifeline to a method invocation
	 * @param mi the method invocation
	 * @return the EObject denoting the lifeline that must contain this method invocation
	 */
	public EObject getLifelineEObjectFromMethodInvocation(TRCFullMethodInvocation mi);

	/**
	 * Get the category of a lifeline
	 * @param to the EObject denoting this lifeline
	 * @return the category
	 */
	public int getLifeLineCategory(EObject eo);

	/**
	 * Returns the title of a lifeline
	 * @param to the EObject denoting this lifeline
	 * @param long_ long version if true, short string otherwise
	 * @return the title of the lifeline
	 */
	public String getLifeLineTitle(EObject eo, boolean long_);

	/**
	 * Returns the unique id of a lifeline
	 * @param to the EObject denoting this lifeline
	 * @return the title of the lifeline
	 */
	public String getLifeLineId(EObject eo);

	/**
	 * Return the convenient title when this loader is the one
	 * @return the title
	 */
	public String getFinalTitleString();
	
	/**
	 * Enables drill down
	 * @param value the value 'true' or 'false' to compare this property to
	 * @return true if value is aligned to the property
	 */
	public boolean drillDownEnabled(String value);

	/**
	 * @return the kind of lifeline as a string for properties view
	 */
	public String getLifelineType(EObject eObject);

	/**
	 * @return a string carrying the instance type
	 */
	public String getLifelineTypeName();
	
	/**
	 * @return a string carrying the message type
	 */
	public String getMessageTypeName();

}