/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceLifelineDraft.java,v 1.6 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;

/**
 * A draft with some build-time datas
 */
public class TraceLifelineDraft {
	
	private Lifeline lifeline;
	private int start, end, nbUser;
	private boolean filtered;
	private EObject eObject;
	
	public void setStart(int start_) {
		start = start_;
	}

	public int getStart() {
		return start;
	}
	
	public void setEnd(int end_) {
		end = end_;
	}
	
	public int getEnd() {
		return end;
	}
	
	public void addAUser() {
		nbUser++;
	}

	public void removeAUser() {
		nbUser--;
	}

	public int getNbUser() {
		return nbUser;
	}

	public void setLifeline(Lifeline lifeline_) {
		lifeline = lifeline_;
	}
	
	public Lifeline getLifeline() {
		return lifeline;
	}

	public void setFiltered(boolean filtered) {
		this.filtered = filtered;
	}

	public boolean isFiltered() {
		return filtered;
	}

	public TraceLifelineDraft(EObject eObject_) {
		eObject = eObject_;
	}

	public EObject getEObject() {
		return eObject;
	}
}
