/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceSyncMessageReturn.java,v 1.10 2005/03/24 22:40:27 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.selection.IDateSelection;
import org.eclipse.hyades.uml2sd.trace.selection.IEObjectSelection;
import org.eclipse.hyades.uml2sd.trace.util.TIUtils;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.util.TimeUtil;
import org.eclipse.ui.IActionFilter;


/**
 * Here is a message return
 */
public class TraceSyncMessageReturn extends SyncMessageReturn
		implements IDateSelection, ITraceMessage, IActionFilter, IEObjectSelection, IPropertiesMiner {
	
	public TRCFullMethodInvocation model;

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.selection.IDateSelection#getMeaning()
	 */
	public int getMeaning() {
		return IDateSelection.NOW;
	}
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.selection.IDateSelection#getStartDate()
	 */
	public double getStartDate() {
		return model == null ? 0 :
			(model.getExitTime() == 0) ?
			(getLastTime()-TIUtils.getAbsoluteEntryTime(model.getProcess().getAgent())) :
			model.getExitTime();
	}
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.selection.IDateSelection#getEndDate()
	 */
	public double getEndDate() {
		return getStartDate();
	}
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.selection.IEObjectSelection#getEObject()
	 */
	public EObject getEObject() {
		return model;
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.internal.IPropertiesMiner#getDescription(java.lang.String)
	 */
	public String getDescription(String propertyName) {
		if (propertyName.equals(TraceRootProperty.STR_TYPE)) {
			return TraceSDPlugin.getResourceString("STR_TYPE_DESCRIPTION"); //$NON-NLS-1$
		} else if (propertyName.equals(TraceRootProperty.STR_NAME)) {
			return TraceSDPlugin.getResourceString("STR_NAME_DESCRIPTION"); //$NON-NLS-1$
		} else if (propertyName.equals(TraceRootProperty.STR_TIME)) {
			return TraceSDPlugin.getResourceString("STR_TIME_DESCRIPTION"); //$NON-NLS-1$
		}
		return propertyName;
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.internal.IPropertiesMiner#getDisplayName(java.lang.String)
	 */
	public String getDisplayName(String propertyName) {
		if (propertyName.equals(TraceRootProperty.STR_TYPE)) {
			return TraceSDPlugin.getResourceString("STR_TYPE_DISPLAY_NAME"); //$NON-NLS-1$
		} else if (propertyName.equals(TraceRootProperty.STR_NAME)) {
			return TraceSDPlugin.getResourceString("STR_NAME_DISPLAY_NAME"); //$NON-NLS-1$
		} else if (propertyName.equals(TraceRootProperty.STR_TIME)) {
			return TraceSDPlugin.getResourceString("STR_TIME_DISPLAY_NAME"); //$NON-NLS-1$
		}
		return propertyName;
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.internal.IPropertiesMiner#getValueAsString(java.lang.String)
	 */
	public String getValueAsString(String propertyName) {
		if (propertyName.equals(TraceRootProperty.STR_TYPE)) {
			return TraceSDPlugin.getResourceString("STR_TYPE_MESSAGE_EXIT_VALUE"); //$NON-NLS-1$
		} else if (propertyName.equals(TraceRootProperty.STR_NAME)) {
			TRCFullMethodInvocation mi = ((TRCFullMethodInvocation)model);
			TRCClass clazz;
			if (mi.getOwningObject().getIsA() == mi.getProcess().getClassClass())
				clazz = mi.getMethod().getDefiningClass(); // TRCClass
			else {
				clazz = mi.getOwningObject().getIsA(); // TRCTraceObject
			}
			return clazz.getName()+"."+mi.getMethod().getName()+mi.getMethod().getSignature(); //$NON-NLS-1$
		} else if (propertyName.equals(TraceRootProperty.STR_TIME)) {
			TRCFullMethodInvocation mi = ((TRCFullMethodInvocation)model);
			return TimeUtil.timeToString(mi.getExitTime());
		}
		// Unknown property
		return ""; //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.ui.IActionFilter#testAttribute(java.lang.Object, java.lang.String, java.lang.String)
	 */
	public boolean testAttribute(Object target, String name, String value) {
		if (name.equals("goToMessageOnDistinctPage")) { //$NON-NLS-1$
			return Boolean.toString(((TraceSyncMessageReturn)target).getMessage() == null).equalsIgnoreCase(value);
		}
		// Any other property is ignored
		return true;
	}

}