/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpRequest.java,v 1.6 2005/02/16 22:21:43 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.runner;


/**
 * The request is the object that stores the data that is
 * sent from the client (usually a browser) to the server.
 * 
 * @author marcelop
 * @since 1.0.2
 */ 
public class HttpRequest
extends HttpElement
{
	private String method;
	private String host;
	private int port;
	private String absolutePath;
	// aberns:
	private long thinkTime = 0;  // by default - no think time. Can't use THE default value at runtime.
	
	//jnevicos - page level response data
	private int nPageNum;
	private int pageOrder;
	//enumeration for pageOrder
	public static final int PAGE_START = 1;
	public static final int PAGE_MID = 2;
	public static final int PAGE_END = 3;
	public static final int PAGE_ONLY = 4;
	public static final int PAGE_UNDEFINED = 0;
	
	//jnevicos - SSL data
	private boolean bSSL;
	private int nConnID;
	private int connOrder;
	//enumeration for reqOrder
	public static final int CONN_START = 1;
	public static final int CONN_MID = 2;
	public static final int CONN_END = 3;
	public static final int CONN_UNDEFINED = 0;
	
	private HttpResponse response;

		
	public String getURL()
	{
		if(getHost() == null)
			return null;
			
		StringBuffer url;
		if (!bSSL) 
			url = new StringBuffer("http://").append(getHost());
		else
			url = new StringBuffer("https://").append(getHost());
			
		if((getPort() > 0) && ((bSSL && getPort() != 443) || (!bSSL && getPort() != 80)))
			url.append(":").append(getPort());
			
		if(getAbsolutePath() != null)
			url.append(getAbsolutePath());
			
		return url.toString();
	}

	/**
	 * @return
	 */
	public String getAbsolutePath()
	{
		return absolutePath;
	}

	/**
	 * @param absolutePath
	 */
	public void setAbsolutePath(String absolutePath)
	{
		this.absolutePath = absolutePath;
	}

	/**
	 * @return
	 */
	public String getHost()
	{
		return host;
	}

	/**
	 * @param host
	 */
	public void setHost(String host)
	{
		this.host = host;
	}

	/**
	 * @return
	 */
	public String getMethod()
	{
		return method;
	}

	/**
	 * @param method
	 */
	public void setMethod(String method)
	{
		this.method = method;
	}

	/**
	 * @return
	 */
	public int getPort()
	{
		return port;
	}

	/**
	 * @param port
	 */
	public void setPort(int port)
	{
		this.port = port;
	}
		
	public HttpResponse getResponse()
	{
		return response;
	}

	/**
	 * All the verification to enforce the bidirectional association
	 * must be done by the caller of this method
	 */
	void setResponse(HttpResponse response)
	{
		this.response = response;
	}
	
	/**
	 * @return
	 */
	public long getThinkTime()
	{
		return thinkTime;
	}

	/**
	 * @param i_i
	 */
	public void setThinkTime(long i_i)
	{
		thinkTime = i_i;
	}

	public int getPageNumber() {return nPageNum;}
	public void setPageNumber(int nPage) { nPageNum = nPage; }
	
	
	public int getConnID() {return nConnID; }
	public void setConnID(int nReq) { nConnID = nReq; }
	
	
	public int getPageOrder() { return pageOrder; }
	public void setPageOrder(int nPage) 
	{
		if (nPage != PAGE_START && nPage != PAGE_MID && nPage != PAGE_END && nPage != PAGE_ONLY)
			pageOrder = PAGE_UNDEFINED;
		else
			pageOrder = nPage;
	} 
	
	public int getConnOrder() {return connOrder; }
	public void setConnOrder(int nConn) 
	{
		if (nConn != CONN_START && nConn != CONN_MID && nConn != CONN_END)
			connOrder = CONN_UNDEFINED;
		else
			connOrder = nConn;
	} 
	
	public boolean getSecure() {return bSSL;}
	public void setSecure(boolean b) {bSSL = b;}	
		
}
