/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpResponse.java,v 1.6 2005/02/16 22:21:43 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.runner;


/**
 * The response is the object that stores the data that is
 * sent from the server to the client (usually a browser).
 * 
 * @author marcelop
 * @since 1.0.2
 */ 
public class HttpResponse
extends HttpElement
{
	private String contentType = null;
	private int contentLength = -1;
	private long pageResponseTime;
	private long elapsedTime;
	
	private int code;
	private String detail;
	private HttpRequest request;
	
	private boolean shouldCloseSocket = false;
	
	public HttpResponse(HttpRequest request)
	{
		this.request = request;
		request.setResponse(this);
	}
	
	
	public HttpRequest getRequest()
	{
		return request;
	}

	public void setDetail(String detail)
	{
		this.detail = detail;
	}	
	
	public String getDetail()
	{
		return detail;
	}

	public void setCode(int code)
	{
		this.code = code;
	}

	public int getCode()
	{
		return code;
	}

	/**
	 * @return
	 */
	public int getContentLength()
	{
		return contentLength;
	}

	/**
	 * @param contentLength
	 */
	public void setContentLength(int contentLength)
	{
		this.contentLength = contentLength;
	}

	/**
	 * @return
	 */
	public String getContentType()
	{
		return contentType;
	}
 
	/**
	 * @return
 	 */
	public long getPageResponseTime()
	{
		return pageResponseTime;
	}

	/**
	 * @param pageResponseTime
	 */
	public void setPageResponseTime(long pageResponseTime)
	{
		this.pageResponseTime = pageResponseTime;
	}

	/**
	 * @param contentType
	 */
	public void setContentType(String contentType)
	{
		this.contentType = contentType;
	}
	/**
	 * @return
	 */
	public long getElapsedTime() {
		return elapsedTime;
	}

	/**
	 * @param l
	 */
	public void setElapsedTime(long l) {
		elapsedTime = l;
	}

	public void setShouldCloseSocket(boolean bClose){
		shouldCloseSocket = bClose;
	}
	
	public boolean getShouldCloseSocket(){
		return shouldCloseSocket;
	}
}
