/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: QueryFactory.java,v 1.4 2005/02/16 22:21:28 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal;

import org.eclipse.hyades.resources.database.internal.impl.QueryFactoryImpl;
/**
 * This factory allows you to create an object query or a reference query.
 * <p>
 * There is one QueryFactory instance that you can access using the INSTANCE
 * field.
 */
public interface QueryFactory {
	/**
	 * Creates an object query.
	 */
	ObjectQuery createObjectQuery();

	/**
	 * Creates a reference query.
	 */
	ReferenceQuery createReferenceQuery();

	/**
	 * Use this field to access the instance of the QueryFactory.
	 */
	QueryFactory INSTANCE = new QueryFactoryImpl();

} // QueryFactory
