/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DbmodelPackage.java,v 1.4 2005/02/16 22:21:28 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.dbmodel;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelFactory
 * @generated
 */
public interface DbmodelPackage extends EPackage {
	/**

	 * The package name.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	String eNAME = "dbmodel";

	/**

	 * The package namespace URI.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	String eNS_URI = "http:///dbmodel.ecore";

	/**

	 * The package namespace name.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	String eNS_PREFIX = "dbmodel";

	/**

	 * The singleton instance of the package.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	DbmodelPackage eINSTANCE = org.eclipse.hyades.resources.database.internal.dbmodel.impl.DbmodelPackageImpl.init();

	/**

	 * The meta object id for the '{@link org.eclipse.hyades.resources.database.internal.dbmodel.impl.DBElementImpl <em>DB Element</em>}' class.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.impl.DBElementImpl

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.impl.DbmodelPackageImpl#getDBElement()

	 * @generated

	 */

	int DB_ELEMENT = 0;

	/**

	 * The feature id for the '<em><b>Name</b></em>' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int DB_ELEMENT__NAME = 0;

	/**

	 * The number of structural features of the the '<em>DB Element</em>' class.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int DB_ELEMENT_FEATURE_COUNT = 1;

	/**

	 * The meta object id for the '{@link org.eclipse.hyades.resources.database.internal.dbmodel.impl.DatabaseImpl <em>Database</em>}' class.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.impl.DatabaseImpl

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.impl.DbmodelPackageImpl#getDatabase()

	 * @generated

	 */

	int DATABASE = 1;

	/**

	 * The feature id for the '<em><b>Name</b></em>' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int DATABASE__NAME = DB_ELEMENT__NAME;

	/**

	 * The feature id for the '<em><b>Tables</b></em>' containment reference list.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int DATABASE__TABLES = DB_ELEMENT_FEATURE_COUNT + 0;

	/**

	 * The feature id for the '<em><b>Types</b></em>' containment reference list.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int DATABASE__TYPES = DB_ELEMENT_FEATURE_COUNT + 1;

	/**

	 * The number of structural features of the the '<em>Database</em>' class.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int DATABASE_FEATURE_COUNT = DB_ELEMENT_FEATURE_COUNT + 2;

	/**

	 * The meta object id for the '{@link org.eclipse.hyades.resources.database.internal.dbmodel.impl.TableImpl <em>Table</em>}' class.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.impl.TableImpl

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.impl.DbmodelPackageImpl#getTable()

	 * @generated

	 */

	int TABLE = 2;

	/**

	 * The feature id for the '<em><b>Name</b></em>' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int TABLE__NAME = DB_ELEMENT__NAME;

	/**

	 * The feature id for the '<em><b>Constraints</b></em>' containment reference list.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int TABLE__CONSTRAINTS = DB_ELEMENT_FEATURE_COUNT + 0;

	/**

	 * The feature id for the '<em><b>Columns</b></em>' containment reference list.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int TABLE__COLUMNS = DB_ELEMENT_FEATURE_COUNT + 1;

	/**

	 * The number of structural features of the the '<em>Table</em>' class.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int TABLE_FEATURE_COUNT = DB_ELEMENT_FEATURE_COUNT + 2;

	/**

	 * The meta object id for the '{@link org.eclipse.hyades.resources.database.internal.dbmodel.impl.ColumnImpl <em>Column</em>}' class.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.impl.ColumnImpl

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.impl.DbmodelPackageImpl#getColumn()

	 * @generated

	 */

	int COLUMN = 3;

	/**

	 * The feature id for the '<em><b>Name</b></em>' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int COLUMN__NAME = DB_ELEMENT__NAME;

	/**

	 * The feature id for the '<em><b>Allow Null</b></em>' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int COLUMN__ALLOW_NULL = DB_ELEMENT_FEATURE_COUNT + 0;

	/**

	 * The feature id for the '<em><b>Table</b></em>' container reference.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int COLUMN__TABLE = DB_ELEMENT_FEATURE_COUNT + 1;

	/**

	 * The feature id for the '<em><b>Constraints</b></em>' reference list.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int COLUMN__CONSTRAINTS = DB_ELEMENT_FEATURE_COUNT + 2;

	/**

	 * The feature id for the '<em><b>Type</b></em>' reference.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int COLUMN__TYPE = DB_ELEMENT_FEATURE_COUNT + 3;

	/**

	 * The number of structural features of the the '<em>Column</em>' class.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int COLUMN_FEATURE_COUNT = DB_ELEMENT_FEATURE_COUNT + 4;

	/**

	 * The meta object id for the '{@link org.eclipse.hyades.resources.database.internal.dbmodel.impl.SQLTypeImpl <em>SQL Type</em>}' class.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.impl.SQLTypeImpl

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.impl.DbmodelPackageImpl#getSQLType()

	 * @generated

	 */

	int SQL_TYPE = 4;

	/**

	 * The feature id for the '<em><b>Name</b></em>' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int SQL_TYPE__NAME = DB_ELEMENT__NAME;

	/**

	 * The feature id for the '<em><b>Sql Type</b></em>' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int SQL_TYPE__SQL_TYPE = DB_ELEMENT_FEATURE_COUNT + 0;

	/**

	 * The number of structural features of the the '<em>SQL Type</em>' class.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int SQL_TYPE_FEATURE_COUNT = DB_ELEMENT_FEATURE_COUNT + 1;

	/**

	 * The meta object id for the '{@link org.eclipse.hyades.resources.database.internal.dbmodel.impl.ConstraintImpl <em>Constraint</em>}' class.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.impl.ConstraintImpl

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.impl.DbmodelPackageImpl#getConstraint()

	 * @generated

	 */

	int CONSTRAINT = 5;

	/**

	 * The feature id for the '<em><b>Name</b></em>' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int CONSTRAINT__NAME = DB_ELEMENT__NAME;

	/**

	 * The feature id for the '<em><b>Type</b></em>' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int CONSTRAINT__TYPE = DB_ELEMENT_FEATURE_COUNT + 0;

	/**

	 * The feature id for the '<em><b>Columns</b></em>' reference list.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int CONSTRAINT__COLUMNS = DB_ELEMENT_FEATURE_COUNT + 1;

	/**

	 * The number of structural features of the the '<em>Constraint</em>' class.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int CONSTRAINT_FEATURE_COUNT = DB_ELEMENT_FEATURE_COUNT + 2;

	/**

	 * The meta object id for the '{@link org.eclipse.hyades.resources.database.internal.dbmodel.impl.StringTypeImpl <em>String Type</em>}' class.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.impl.StringTypeImpl

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.impl.DbmodelPackageImpl#getStringType()

	 * @generated

	 */

	int STRING_TYPE = 6;

	/**

	 * The feature id for the '<em><b>Name</b></em>' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int STRING_TYPE__NAME = SQL_TYPE__NAME;

	/**

	 * The feature id for the '<em><b>Sql Type</b></em>' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int STRING_TYPE__SQL_TYPE = SQL_TYPE__SQL_TYPE;

	/**

	 * The feature id for the '<em><b>Length</b></em>' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int STRING_TYPE__LENGTH = SQL_TYPE_FEATURE_COUNT + 0;

	/**

	 * The number of structural features of the the '<em>String Type</em>' class.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 * @ordered

	 */

	int STRING_TYPE_FEATURE_COUNT = SQL_TYPE_FEATURE_COUNT + 1;

	/**

	 * Returns the meta object for class '{@link org.eclipse.hyades.resources.database.internal.dbmodel.DBElement <em>DB Element</em>}'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the meta object for class '<em>DB Element</em>'.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.DBElement

	 * @generated

	 */

	EClass getDBElement();

	/**

	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.resources.database.internal.dbmodel.DBElement#getName <em>Name</em>}'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the meta object for the attribute '<em>Name</em>'.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.DBElement#getName()

	 * @see #getDBElement()

	 * @generated

	 */

	EAttribute getDBElement_Name();

	/**

	 * Returns the meta object for class '{@link org.eclipse.hyades.resources.database.internal.dbmodel.Database <em>Database</em>}'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the meta object for class '<em>Database</em>'.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.Database

	 * @generated

	 */

	EClass getDatabase();

	/**

	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.resources.database.internal.dbmodel.Database#getTables <em>Tables</em>}'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the meta object for the containment reference list '<em>Tables</em>'.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.Database#getTables()

	 * @see #getDatabase()

	 * @generated

	 */

	EReference getDatabase_Tables();

	/**

	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.resources.database.internal.dbmodel.Database#getTypes <em>Types</em>}'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the meta object for the containment reference list '<em>Types</em>'.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.Database#getTypes()

	 * @see #getDatabase()

	 * @generated

	 */

	EReference getDatabase_Types();

	/**

	 * Returns the meta object for class '{@link org.eclipse.hyades.resources.database.internal.dbmodel.Table <em>Table</em>}'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the meta object for class '<em>Table</em>'.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.Table

	 * @generated

	 */

	EClass getTable();

	/**

	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.resources.database.internal.dbmodel.Table#getConstraints <em>Constraints</em>}'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the meta object for the containment reference list '<em>Constraints</em>'.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.Table#getConstraints()

	 * @see #getTable()

	 * @generated

	 */

	EReference getTable_Constraints();

	/**

	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.resources.database.internal.dbmodel.Table#getColumns <em>Columns</em>}'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the meta object for the containment reference list '<em>Columns</em>'.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.Table#getColumns()

	 * @see #getTable()

	 * @generated

	 */

	EReference getTable_Columns();

	/**

	 * Returns the meta object for class '{@link org.eclipse.hyades.resources.database.internal.dbmodel.Column <em>Column</em>}'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the meta object for class '<em>Column</em>'.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.Column

	 * @generated

	 */

	EClass getColumn();

	/**

	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.resources.database.internal.dbmodel.Column#isAllowNull <em>Allow Null</em>}'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the meta object for the attribute '<em>Allow Null</em>'.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.Column#isAllowNull()

	 * @see #getColumn()

	 * @generated

	 */

	EAttribute getColumn_AllowNull();

	/**

	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.resources.database.internal.dbmodel.Column#getTable <em>Table</em>}'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the meta object for the container reference '<em>Table</em>'.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.Column#getTable()

	 * @see #getColumn()

	 * @generated

	 */

	EReference getColumn_Table();

	/**

	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.resources.database.internal.dbmodel.Column#getConstraints <em>Constraints</em>}'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the meta object for the reference list '<em>Constraints</em>'.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.Column#getConstraints()

	 * @see #getColumn()

	 * @generated

	 */

	EReference getColumn_Constraints();

	/**

	 * Returns the meta object for the reference '{@link org.eclipse.hyades.resources.database.internal.dbmodel.Column#getType <em>Type</em>}'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the meta object for the reference '<em>Type</em>'.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.Column#getType()

	 * @see #getColumn()

	 * @generated

	 */

	EReference getColumn_Type();

	/**

	 * Returns the meta object for class '{@link org.eclipse.hyades.resources.database.internal.dbmodel.SQLType <em>SQL Type</em>}'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the meta object for class '<em>SQL Type</em>'.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.SQLType

	 * @generated

	 */

	EClass getSQLType();

	/**

	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.resources.database.internal.dbmodel.SQLType#getSqlType <em>Sql Type</em>}'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the meta object for the attribute '<em>Sql Type</em>'.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.SQLType#getSqlType()

	 * @see #getSQLType()

	 * @generated

	 */

	EAttribute getSQLType_SqlType();

	/**

	 * Returns the meta object for class '{@link org.eclipse.hyades.resources.database.internal.dbmodel.Constraint <em>Constraint</em>}'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the meta object for class '<em>Constraint</em>'.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.Constraint

	 * @generated

	 */

	EClass getConstraint();

	/**

	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.resources.database.internal.dbmodel.Constraint#getType <em>Type</em>}'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the meta object for the attribute '<em>Type</em>'.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.Constraint#getType()

	 * @see #getConstraint()

	 * @generated

	 */

	EAttribute getConstraint_Type();

	/**

	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.resources.database.internal.dbmodel.Constraint#getColumns <em>Columns</em>}'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the meta object for the reference list '<em>Columns</em>'.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.Constraint#getColumns()

	 * @see #getConstraint()

	 * @generated

	 */

	EReference getConstraint_Columns();

	/**

	 * Returns the meta object for class '{@link org.eclipse.hyades.resources.database.internal.dbmodel.StringType <em>String Type</em>}'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the meta object for class '<em>String Type</em>'.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.StringType

	 * @generated

	 */

	EClass getStringType();

	/**

	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.resources.database.internal.dbmodel.StringType#getLength <em>Length</em>}'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the meta object for the attribute '<em>Length</em>'.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.StringType#getLength()

	 * @see #getStringType()

	 * @generated

	 */

	EAttribute getStringType_Length();

	/**

	 * Returns the factory that creates the instances of the model.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the factory that creates the instances of the model.

	 * @generated

	 */

	DbmodelFactory getDbmodelFactory();

} //DbmodelPackage

