/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Table.java,v 1.4 2005/02/16 22:21:29 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.dbmodel;

import org.eclipse.emf.common.util.EList;
/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Table</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.resources.database.internal.dbmodel.Table#getConstraints <em>Constraints</em>}</li>
 *   <li>{@link org.eclipse.hyades.resources.database.internal.dbmodel.Table#getColumns <em>Columns</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage#getTable()
 * @model
 * @generated
 */
public interface Table extends DBElement {
	/**

	 * Returns the value of the '<em><b>Constraints</b></em>' containment reference list.

	 * The list contents are of type {@link org.eclipse.hyades.resources.database.internal.dbmodel.Constraint}.

	 * <!-- begin-user-doc -->

	 * <p>

	 * If the meaning of the '<em>Constraints</em>' containment reference list isn't clear,

	 * there really should be more of a description here...

	 * </p>

	 * <!-- end-user-doc -->

	 * @return the value of the '<em>Constraints</em>' containment reference list.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage#getTable_Constraints()

	 * @model type="org.eclipse.hyades.resources.database.internal.dbmodel.Constraint" containment="true"

	 * @generated

	 */

	EList getConstraints();

	/**

	 * Returns the value of the '<em><b>Columns</b></em>' containment reference list.

	 * The list contents are of type {@link org.eclipse.hyades.resources.database.internal.dbmodel.Column}.

	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.resources.database.internal.dbmodel.Column#getTable <em>Table</em>}'.

	 * <!-- begin-user-doc -->

	 * <p>

	 * If the meaning of the '<em>Columns</em>' containment reference list isn't clear,

	 * there really should be more of a description here...

	 * </p>

	 * <!-- end-user-doc -->

	 * @return the value of the '<em>Columns</em>' containment reference list.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage#getTable_Columns()

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.Column#getTable

	 * @model type="org.eclipse.hyades.resources.database.internal.dbmodel.Column" opposite="Table" containment="true"

	 * @generated

	 */

	EList getColumns();

} // Table

