/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ColumnImpl.java,v 1.4 2005/02/16 22:21:29 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.dbmodel.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Constraint;
import org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage;
import org.eclipse.hyades.resources.database.internal.dbmodel.SQLType;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Column</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.resources.database.internal.dbmodel.impl.ColumnImpl#isAllowNull <em>Allow Null</em>}</li>
 *   <li>{@link org.eclipse.hyades.resources.database.internal.dbmodel.impl.ColumnImpl#getTable <em>Table</em>}</li>
 *   <li>{@link org.eclipse.hyades.resources.database.internal.dbmodel.impl.ColumnImpl#getConstraints <em>Constraints</em>}</li>
 *   <li>{@link org.eclipse.hyades.resources.database.internal.dbmodel.impl.ColumnImpl#getType <em>Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ColumnImpl extends DBElementImpl implements Column {
	/**

	 * The default value of the '{@link #isAllowNull() <em>Allow Null</em>}' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see #isAllowNull()

	 * @generated

	 * @ordered

	 */

	protected static final boolean ALLOW_NULL_EDEFAULT = false;

	/**

	 * The cached value of the '{@link #isAllowNull() <em>Allow Null</em>}' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see #isAllowNull()

	 * @generated

	 * @ordered

	 */

	protected boolean allowNull = ALLOW_NULL_EDEFAULT;

	/**

	 * The cached value of the '{@link #getConstraints() <em>Constraints</em>}' reference list.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see #getConstraints()

	 * @generated

	 * @ordered

	 */

	protected EList constraints = null;

	/**

	 * The cached value of the '{@link #getType() <em>Type</em>}' reference.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see #getType()

	 * @generated

	 * @ordered

	 */

	protected SQLType type = null;

	protected Object defaultValue;

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	protected ColumnImpl() {
		super();

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	protected EClass eStaticClass() {
		return DbmodelPackage.eINSTANCE.getColumn();

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public boolean isAllowNull() {
		return allowNull;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public void setAllowNull(boolean newAllowNull) {
		boolean oldAllowNull = allowNull;

		allowNull = newAllowNull;

		if (eNotificationRequired())

			eNotify(new ENotificationImpl(this, Notification.SET, DbmodelPackage.COLUMN__ALLOW_NULL, oldAllowNull, allowNull));

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public Table getTable() {
		if (eContainerFeatureID != DbmodelPackage.COLUMN__TABLE)
			return null;

		return (Table) eContainer;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public void setTable(Table newTable) {
		if (newTable != eContainer || (eContainerFeatureID != DbmodelPackage.COLUMN__TABLE && newTable != null)) {
			if (EcoreUtil.isAncestor(this, newTable))

				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());

			NotificationChain msgs = null;

			if (eContainer != null)

				msgs = eBasicRemoveFromContainer(msgs);

			if (newTable != null)

				msgs = ((InternalEObject) newTable).eInverseAdd(this, DbmodelPackage.TABLE__COLUMNS, Table.class, msgs);

			msgs = eBasicSetContainer((InternalEObject) newTable, DbmodelPackage.COLUMN__TABLE, msgs);

			if (msgs != null)
				msgs.dispatch();

		}

		else if (eNotificationRequired())

			eNotify(new ENotificationImpl(this, Notification.SET, DbmodelPackage.COLUMN__TABLE, newTable, newTable));

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EList getConstraints() {
		if (constraints == null) {
			constraints = new EObjectWithInverseResolvingEList.ManyInverse(Constraint.class, this, DbmodelPackage.COLUMN__CONSTRAINTS, DbmodelPackage.CONSTRAINT__COLUMNS);

		}

		return constraints;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public SQLType getType() {
		if (type != null && type.eIsProxy()) {
			SQLType oldType = type;

			type = (SQLType) EcoreUtil.resolve(type, this);

			if (type != oldType) {
				if (eNotificationRequired())

					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DbmodelPackage.COLUMN__TYPE, oldType, type));

			}

		}

		return type;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public SQLType basicGetType() {
		return type;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public void setType(SQLType newType) {
		SQLType oldType = type;

		type = newType;

		if (eNotificationRequired())

			eNotify(new ENotificationImpl(this, Notification.SET, DbmodelPackage.COLUMN__TYPE, oldType, type));

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case DbmodelPackage.COLUMN__TABLE :

					if (eContainer != null)

						msgs = eBasicRemoveFromContainer(msgs);

					return eBasicSetContainer(otherEnd, DbmodelPackage.COLUMN__TABLE, msgs);

				case DbmodelPackage.COLUMN__CONSTRAINTS :

					return ((InternalEList) getConstraints()).basicAdd(otherEnd, msgs);

				default :

					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);

			}

		}

		if (eContainer != null)

			msgs = eBasicRemoveFromContainer(msgs);

		return eBasicSetContainer(otherEnd, featureID, msgs);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case DbmodelPackage.COLUMN__TABLE :

					return eBasicSetContainer(null, DbmodelPackage.COLUMN__TABLE, msgs);

				case DbmodelPackage.COLUMN__CONSTRAINTS :

					return ((InternalEList) getConstraints()).basicRemove(otherEnd, msgs);

				default :

					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);

			}

		}

		return eBasicSetContainer(null, featureID, msgs);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case DbmodelPackage.COLUMN__TABLE :

					return ((InternalEObject) eContainer).eInverseRemove(this, DbmodelPackage.TABLE__COLUMNS, Table.class, msgs);

				default :

					return eDynamicBasicRemoveFromContainer(msgs);

			}

		}

		return ((InternalEObject) eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.COLUMN__NAME :

				return getName();

			case DbmodelPackage.COLUMN__ALLOW_NULL :

				return isAllowNull() ? Boolean.TRUE : Boolean.FALSE;

			case DbmodelPackage.COLUMN__TABLE :

				return getTable();

			case DbmodelPackage.COLUMN__CONSTRAINTS :

				return getConstraints();

			case DbmodelPackage.COLUMN__TYPE :

				if (resolve)
					return getType();

				return basicGetType();

		}

		return eDynamicGet(eFeature, resolve);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.COLUMN__NAME :

				setName((String) newValue);

				return;

			case DbmodelPackage.COLUMN__ALLOW_NULL :

				setAllowNull(((Boolean) newValue).booleanValue());

				return;

			case DbmodelPackage.COLUMN__TABLE :

				setTable((Table) newValue);

				return;

			case DbmodelPackage.COLUMN__CONSTRAINTS :

				getConstraints().clear();

				getConstraints().addAll((Collection) newValue);

				return;

			case DbmodelPackage.COLUMN__TYPE :

				setType((SQLType) newValue);

				return;

		}

		eDynamicSet(eFeature, newValue);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.COLUMN__NAME :

				setName(NAME_EDEFAULT);

				return;

			case DbmodelPackage.COLUMN__ALLOW_NULL :

				setAllowNull(ALLOW_NULL_EDEFAULT);

				return;

			case DbmodelPackage.COLUMN__TABLE :

				setTable((Table) null);

				return;

			case DbmodelPackage.COLUMN__CONSTRAINTS :

				getConstraints().clear();

				return;

			case DbmodelPackage.COLUMN__TYPE :

				setType((SQLType) null);

				return;

		}

		eDynamicUnset(eFeature);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.COLUMN__NAME :

				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);

			case DbmodelPackage.COLUMN__ALLOW_NULL :

				return allowNull != ALLOW_NULL_EDEFAULT;

			case DbmodelPackage.COLUMN__TABLE :

				return getTable() != null;

			case DbmodelPackage.COLUMN__CONSTRAINTS :

				return constraints != null && !constraints.isEmpty();

			case DbmodelPackage.COLUMN__TYPE :

				return type != null;

		}

		return eDynamicIsSet(eFeature);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());

		result.append(" (allowNull: ");

		result.append(allowNull);

		result.append(')');

		return result.toString();

	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.Column#getDefaultValue()
	 */
	public Object getDefaultValue() {
		// TODO Auto-generated method stub
		return defaultValue;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.Column#setDefaultValue(java.lang.Object)
	 */
	public void setDefaultValue(Object newValue) {
		defaultValue = newValue;
	}
} //ColumnImpl

