/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TableImpl.java,v 1.4 2005/02/16 22:21:29 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.dbmodel.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Constraint;
import org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Table</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.resources.database.internal.dbmodel.impl.TableImpl#getConstraints <em>Constraints</em>}</li>
 *   <li>{@link org.eclipse.hyades.resources.database.internal.dbmodel.impl.TableImpl#getColumns <em>Columns</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TableImpl extends DBElementImpl implements Table {
	/**

	 * The cached value of the '{@link #getConstraints() <em>Constraints</em>}' containment reference list.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see #getConstraints()

	 * @generated

	 * @ordered

	 */

	protected EList constraints = null;

	/**

	 * The cached value of the '{@link #getColumns() <em>Columns</em>}' containment reference list.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see #getColumns()

	 * @generated

	 * @ordered

	 */

	protected EList columns = null;

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	protected TableImpl() {
		super();

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	protected EClass eStaticClass() {
		return DbmodelPackage.eINSTANCE.getTable();

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EList getConstraints() {
		if (constraints == null) {
			constraints = new EObjectContainmentEList(Constraint.class, this, DbmodelPackage.TABLE__CONSTRAINTS);

		}

		return constraints;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EList getColumns() {
		if (columns == null) {
			columns = new EObjectContainmentWithInverseEList(Column.class, this, DbmodelPackage.TABLE__COLUMNS, DbmodelPackage.COLUMN__TABLE);

		}

		return columns;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case DbmodelPackage.TABLE__COLUMNS :

					return ((InternalEList) getColumns()).basicAdd(otherEnd, msgs);

				default :

					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);

			}

		}

		if (eContainer != null)

			msgs = eBasicRemoveFromContainer(msgs);

		return eBasicSetContainer(otherEnd, featureID, msgs);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case DbmodelPackage.TABLE__CONSTRAINTS :

					return ((InternalEList) getConstraints()).basicRemove(otherEnd, msgs);

				case DbmodelPackage.TABLE__COLUMNS :

					return ((InternalEList) getColumns()).basicRemove(otherEnd, msgs);

				default :

					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);

			}

		}

		return eBasicSetContainer(null, featureID, msgs);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.TABLE__NAME :

				return getName();

			case DbmodelPackage.TABLE__CONSTRAINTS :

				return getConstraints();

			case DbmodelPackage.TABLE__COLUMNS :

				return getColumns();

		}

		return eDynamicGet(eFeature, resolve);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.TABLE__NAME :

				setName((String) newValue);

				return;

			case DbmodelPackage.TABLE__CONSTRAINTS :

				getConstraints().clear();

				getConstraints().addAll((Collection) newValue);

				return;

			case DbmodelPackage.TABLE__COLUMNS :

				getColumns().clear();

				getColumns().addAll((Collection) newValue);

				return;

		}

		eDynamicSet(eFeature, newValue);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.TABLE__NAME :

				setName(NAME_EDEFAULT);

				return;

			case DbmodelPackage.TABLE__CONSTRAINTS :

				getConstraints().clear();

				return;

			case DbmodelPackage.TABLE__COLUMNS :

				getColumns().clear();

				return;

		}

		eDynamicUnset(eFeature);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.TABLE__NAME :

				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);

			case DbmodelPackage.TABLE__CONSTRAINTS :

				return constraints != null && !constraints.isEmpty();

			case DbmodelPackage.TABLE__COLUMNS :

				return columns != null && !columns.isEmpty();

		}

		return eDynamicIsSet(eFeature);

	}

} //TableImpl

