/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TypeMapFactory.java,v 1.4 2005/02/16 22:21:29 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.extensions;
import java.sql.Types;

import org.eclipse.hyades.resources.database.internal.TypeMap;
import org.eclipse.hyades.resources.database.internal.impl.TypeMapImpl;
/**
 * This class returns a default TypeMap according to the database type.
 */
public class TypeMapFactory {
	/**
	 * Constructor for TypeMapFactory.
	 */
	public TypeMapFactory() {
		super();
	}
	public TypeMap createTypeMap(DatabaseType type) {
		TypeMap map = new TypeMapImpl();
		addTypes(map);
		return map;
	}

	protected void addTypes(TypeMap map) {
		map.add("EInt", Types.INTEGER);
		map.add("EIntegerObject", Types.INTEGER);
		map.add("EByte", Types.SMALLINT);
		map.add("EByteObject", Types.SMALLINT);
		map.add("EShort", Types.SMALLINT);
		map.add("EShortObject", Types.SMALLINT);
		map.add("ELong", Types.BIGINT);
		map.add("ELongObject", Types.BIGINT);
		map.add("EBoolean", Types.CHAR);
		map.add("EBooleanObject", Types.CHAR);
		map.add("EDouble", Types.DOUBLE);
		map.add("EDoubleObject", Types.DOUBLE);
	}
} // TypeMapFactory
