/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ClearCommand.java,v 1.4 2005/02/16 22:21:29 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
/**
 * This class deletes all of the rows from a database.
 */
public class ClearCommand extends DBCommand {
	/**
	 * Constructor for ClearCommand.
	 * 
	 * @param helper
	 * @param map
	 */
	public ClearCommand(JDBCHelper helper, DBMap map) {
		super(helper, map);
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.DBCommand#execute()
	 */
	public Object execute() throws Exception {
		List tables = getTablesToClear();
		List statements = new ArrayList();

		for (int i = 0, l = tables.size(); i < l; i++) {
			Table table = (Table) tables.get(i);
			statements.add("DELETE FROM " + addQuotes(table.getName()));
		}

		for (int i = 0, l = statements.size(); i < l; i++)
			helper.executeUpdateStatement((String) statements.get(i));

		return null;
	}

	protected List getTablesToClear() {
		List tables = new ArrayList();
		Table table = dbMap.getResourceTable();

		if (table != null)
			tables.add(table);

		table = dbMap.getProxyTable();

		if (table != null)
			tables.add(table);

		table = dbMap.getIdTable();

		if (table != null)
			tables.add(table);

		tables.addAll(dbMap.getAttributeTables());
		tables.addAll(dbMap.getReferenceTables());
		tables.addAll(dbMap.getClassTables());
		return tables;
	}
} // ClearCommand
