/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DBVisitorImpl.java,v 1.4 2005/02/16 22:21:31 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.hyades.resources.database.internal.DBCollectedExceptions;
import org.eclipse.hyades.resources.database.internal.DBVisitor;
import org.eclipse.hyades.resources.database.internal.Database;
import org.eclipse.hyades.resources.database.internal.PagingList;
import org.eclipse.hyades.resources.database.internal.QueryFactory;
import org.eclipse.hyades.resources.database.internal.ReferenceQuery;
/**
 * The DBVisitor performs reference queries on single-valued references and
 * creates PagingLists for multi-valued references.
 */
public class DBVisitorImpl implements DBVisitor {
	protected Database database;
	protected int pagingSize;

	public DBVisitorImpl(Database database, int pagingSize) {
		this.database = database;
		this.pagingSize = pagingSize;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.DBVisitor#get(org.eclipse.emf.ecore.EObject,
	 *      org.eclipse.emf.ecore.EReference)
	 */
	public Object get(EObject object, EReference reference) {
		if (reference.isMany()) {
			PagingList list = new DynamicPagingListImpl((InternalEObject) object, (EStructuralFeature) reference, database, pagingSize);
			list.setReferences(false);
			return list;
		} else
			return getSingleObject(object, reference);
	}

	protected Object getSingleObject(EObject object, EReference reference) {
		ReferenceQuery query = QueryFactory.INSTANCE.createReferenceQuery();
		query.setEObject(object);
		query.setEReference(reference);
		query.setReferences(false);
		EObject[] objects = null;

		try {
			objects = database.getObjects(query);
		} catch (Exception e) {
			throw new DBCollectedExceptions(e);
		}

		if (objects == null)
			return null;
		else
			return objects[0];
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.DBVisitor#setPagingSize(int)
	 */
	public void setPagingSize(int size) {
		pagingSize = size;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.DBVisitor#getPagingSize()
	 */
	public int getPagingSize() {
		return pagingSize;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.DBVisitor#setDatabase(org.eclipse.hyades.resources.database.internal.Database)
	 */
	public void setDatabase(Database database) {
		this.database = database;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.DBVisitor#getDatabase()
	 */
	public Database getDatabase() {
		return database;
	}
} // DBVisitorImpl
