/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GetIdsOfMatches.java,v 1.4 2005/02/16 22:21:31 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
/**
 * This class gets ids of objects that have the attribute values in the values
 * Map and that are instances of the given EClass.
 */
public class GetIdsOfMatches extends DBCommand {
	protected DatabaseType type;
	protected EClass eClass;
	protected Map values;

	/**
	 * Constructor for GetObjectQuery.
	 * 
	 * @param helper
	 * @param map
	 * @param dbType
	 * @param eClass
	 * @param values
	 */
	public GetIdsOfMatches(JDBCHelper helper, DBMap map, DatabaseType dbType, EClass eClass, Map values) {
		super(helper, map);
		this.type = dbType;
		this.eClass = eClass;
		this.values = values;
	}

	/**
	 * Return a.
	 */
	public Object execute() throws Exception {
		Map classesToValues = computeClassesToValues();
		List ids = new ArrayList();
		Iterator entries = classesToValues.entrySet().iterator();

		while (entries.hasNext()) {
			Map.Entry entry = (Map.Entry) entries.next();
			EClass eClass = (EClass) entry.getKey();
			List valuesForClass = (List) entry.getValue();
			ids = getIds(eClass, valuesForClass, ids);

			if (ids.isEmpty())
				break;
		}

		return ids;
	}

	/**
	 * The key is an EClass; the value is a list of EAttribute and value pairs.
	 */
	protected Map computeClassesToValues() {
		Map classesToValues = new HashMap();
		Iterator entries = values.entrySet().iterator();

		while (entries.hasNext()) {
			Map.Entry entry = (Map.Entry) entries.next();
			EAttribute attribute = (EAttribute) entry.getKey();
			Object value = entry.getValue();
			addValueToMap(classesToValues, attribute, value);
		}

		return classesToValues;
	}

	/**
	 * Add the EAttribute and value to the map.
	 */
	protected void addValueToMap(Map map, EAttribute attribute, Object value) {
		EClass eClass = attribute.getEContainingClass();

		List valuesForClass = (List) map.get(eClass);

		if (valuesForClass == null) {
			valuesForClass = new ArrayList();
			map.put(eClass, valuesForClass);
		}

		valuesForClass.add(attribute);
		valuesForClass.add(value);
	}

	/**
	 * Returns a list of ids of objects for the given class that match the given
	 * attribute values for the given set of ids.
	 */
	protected List getIds(EClass eClass, List valuesForClass, List ids) throws Exception {
		List newIds = new ArrayList();
		Statement statement = helper.createStatement();
		ResultSet result = helper.executeQuery(statement, getQuery(eClass, valuesForClass, ids));

		while (result.next())
			newIds.add(new Integer(result.getInt(1)));

		result.close();
		statement.close();
		return newIds;
	}

	/**
	 * Return a SQL statement that obtains the ids of the objects for the given
	 * class that match the given attribute values for the given ids.
	 */
	protected String getQuery(EClass eClass, List valuesForClass, List ids) {
		StatementFactory factory = StatementFactory.INSTANCE;
		QueryStatement query = factory.createAttributeValueQuery(type, dbMap, eClass, valuesForClass, ids);
		return query.getStatement();
	}
} // GetIdsOfMatches
