/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GetLargestDatabaseIdCommand.java,v 1.4 2005/02/16 22:21:31 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.ResultSet;
import java.sql.Statement;

import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
/**
 * This class gets the largest database id by looking it up in the id table.
 */
public class GetLargestDatabaseIdCommand extends DBCommand {
	public GetLargestDatabaseIdCommand(JDBCHelper helper, DBMap map) {
		super(helper, map);
	}

	public Object execute() throws Exception {
		if (dbMap.getIdTable() == null)
			return null;

		String query = createIdTableQuery(dbMap.getIdTable());
		Statement statement = helper.createStatement();
		ResultSet rs = helper.executeQuery(statement, query);
		int max = getInt(rs);
		rs.close();
		statement.close();
		return new Integer(max);
	}

	protected int getInt(ResultSet rs) throws Exception {
		if (rs.next())
			return rs.getInt(1);
		else
			return 0;
	}

	protected String createIdTableQuery(Table idTable) {
		StringBuffer query = new StringBuffer();
		String idColumn = ((Column) idTable.getColumns().get(0)).getName();
		query.append("SELECT ");
		query.append(addQuotes(idColumn));
		query.append(" FROM ");
		query.append(addQuotes(idTable.getName()));
		return query.toString();
	}
} // GetLargestDatabaseIdCommand
