/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GetReferenceCountCommand.java,v 1.5 2005/02/16 22:21:31 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.ResultSet;
import java.sql.Statement;

import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
/**
 * This class counts the number of referenced objects for the object with the
 * given id and reference.
 */
public class GetReferenceCountCommand extends DBCommand {
	protected Integer id;
	protected EReference reference;

	public GetReferenceCountCommand(JDBCHelper helper, DBMap map, Integer id, EReference reference) {
		super(helper, map);
		this.id = id;
		this.reference = reference;
	}

	/**
	 * Return an array of EObjects, or null.
	 */
	public Object execute() throws Exception {
		StatementFactory factory = StatementFactory.INSTANCE;
		QueryStatement query = factory.createReferenceCountQuery(helper.getDatabaseType(), dbMap, id, reference);
		Statement statement = helper.createStatement();
		ResultSet rs = helper.executeQuery(statement, query.getStatement());
		int count = 0;

		while (rs.next())
			count = rs.getInt(1);

		rs.close();
		statement.close();
		return new Integer(count);
	}
} // GetReferenceCountCommand
