/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: QueryStatement.java,v 1.4 2005/02/16 22:21:31 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
/**
 * This class represents an SQL SELECT statement that queries the class table
 * for the given eClass for the row or rows where the key matches the filter, if
 * the filter is not null.
 */
public class QueryStatement extends SQLStatement {

	protected EModelElement element;
	protected Table table;
	protected List statements;
	protected int initial;

	/**
	 * Constructor for QueryStatement.
	 */
	public QueryStatement(DatabaseType dbType, DBMap map, EModelElement element) {
		super(dbType,map);
		this.element = element;

		if (element instanceof EClass) {
			DBMap.ClassData data = (DBMap.ClassData) dbMap.getDBRepresentation(element);
			table = data.getTable();
		} else if (element instanceof EAttribute) {
			DBMap.AttributeData data;
			data = (DBMap.AttributeData) dbMap.getDBRepresentation(element);
			table = data.getTable();
		} else if (element instanceof EReference) {
			DBMap.ReferenceData data;
			data = (DBMap.ReferenceData) dbMap.getDBRepresentation(element);
			table = data.getTable();
		}
	}

	/**
	 * Creates the String representation of the statement, creating it if
	 * necessary.
	 */
	public String getStatement() {
		if (statement.length() != 0) {
			//TODO : MS - remove this debug info
			//        System.out.println(getClass()+"|"+statement);

			return statement.toString();
		}

		boolean finished = false;

		while (!finished) {
			int start = initial;
			createSelectFrom();
			createWhereClause(initial);
			createOrderClause();

			if (initial == 0)
				finished = true;
			else {
				addToStatements();
				statement = new StringBuffer();

				if (start == initial)
					finished = true;
			}
		}

		if (statements != null)
			return null;
		else {
			//TODO : MS - remove this debug info
			//        System.out.println(getClass()+"|"+statement);
			return statement.toString();
		}
	}

	protected void createSelectFrom() {
	}

	protected void createWhereClause(int begin) {
	}

	protected void createOrderClause() {
	}

	protected void addToStatements() {
		if (statements == null)
			statements = new ArrayList();

		statements.add(statement.toString());
	}

	public String[] getStatements() {
		if (statements == null)
			return null;
		else {
			//TODO : MS - remove this debug info
			//        for (int i = 0; i < statements.size(); i++)
			//              System.out.println(getClass()+"|"+statements.get(i));
			return (String[]) statements.toArray(new String[statements.size()]);
		}
	}
} // QueryStatement
