/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TimeBasedCorrelationCommand.java,v 1.11 2005/03/28 13:31:58 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.resources.database.internal.DBCollectedExceptions;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DBCommandFactory;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;

/**
 * @author slavescu
 */
public class TimeBasedCorrelationCommand extends DBCommand {
	private TimeBasedCorrelationQuery query;
	private ResourceSet resourceSet;
	private WeakObjectCache cache;
	private Collection notLoadedClasses;
	private int correlationContainerID=-1;
	/**
	 * @param helper
	 * @param map
	 * @param notLoadedClasses
	 * @param cache
	 * @param targetResourceSet
	 * @param query
	 */
	public TimeBasedCorrelationCommand(JDBCHelper helper, DBMap map, TimeBasedCorrelationQuery query, ResourceSet targetResourceSet, WeakObjectCache cache, Collection notLoadedClasses) {
		super(helper, map);
		this.query = query;
		this.resourceSet = targetResourceSet;
		this.cache = cache;
		this.notLoadedClasses = notLoadedClasses;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.resources.database.internal.impl.DBCommand#execute()
	 */
	public Object execute() throws Exception {
		String s;

		QueryResult queryResult = ExtensionsFactory.eINSTANCE.createQueryResult();
		queryResult.setQuery(query);
		PerfUtil p = new PerfUtil("TimeBasedCorrelationCommand.execute()",false);
		if(query.getOutputElements().size()==0)
		{
			List sts = createCorrelation();
			try {
				for (Iterator iter = sts.iterator(); iter.hasNext();) {
					s = (String) iter.next();
					p.setMessageAndStart("TimeBasedCorrelationCommand.execute() 1 statement="+s);
					helper.executeUpdateStatement(s);
					p.stopAndPrintStatus();
				}
				helper.executeUpdateStatement("UPDATE Id_Table SET id = (NEXTVAL FOR id_sequence)");
				helper.commitTransaction();
				
			} catch (Exception e) {
				helper.rollbackTransaction();
				throw e;
			} 
			return queryResult;
		}
		else if(query.getOutputElements().size()==1 && ((SimpleOperand)query.getOutputElements().get(0)).getType() == CBEPackage.eINSTANCE.getCBECommonBaseEvent())
		{
			s = getCorrelatedCBECommonBaseEvents();
		}
		else if(query.getOutputElements().size()==2 && ((SimpleOperand)query.getOutputElements().get(0)).getFeature() == HierarchyPackage.eINSTANCE.getCorrelationEntry_Value())
		{
			s = getInboundCorrelationEntries();
			// TODO MS - remove this fix for IndirectedList
			((SimpleOperand)query.getOutputElements().get(0)).setType(CBEPackage.eINSTANCE.getCBECommonBaseEvent());
			((SimpleOperand)query.getOutputElements().get(0)).setFeature(null);
			((SimpleOperand)query.getOutputElements().get(1)).setType(CBEPackage.eINSTANCE.getCBECommonBaseEvent());
			((SimpleOperand)query.getOutputElements().get(1)).setFeature(null);
			
		}
		else if(query.getOutputElements().size()==2 && ((SimpleOperand)query.getOutputElements().get(0)).getFeature() == HierarchyPackage.eINSTANCE.getCorrelationEntry_Key())
		{
			s = getOutboundCorrelationEntries();
			// TODO MS - remove this fix for IndirectedList
			((SimpleOperand)query.getOutputElements().get(0)).setType(CBEPackage.eINSTANCE.getCBECommonBaseEvent());
			((SimpleOperand)query.getOutputElements().get(0)).setFeature(null);
			((SimpleOperand)query.getOutputElements().get(1)).setType(CBEPackage.eINSTANCE.getCBECommonBaseEvent());
			((SimpleOperand)query.getOutputElements().get(1)).setFeature(null);
		}
		else
			throw new IllegalArgumentException("Illegal arguments in query "+query);
		Statement st = helper.createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_READ_ONLY);
		p.setMessageAndStart("TimeBasedCorrelationCommand.execute() 2 statement="+s);
		helper.executeQuery(st, s);
		p.stopAndPrintStatus();
		ResultSet rs = st.getResultSet();
		for (int i=0;i<query.getOutputElements().size();i++) {
			EList objects;
			if(query.isCount())// || ((Operand)query.getOutputElements().get(i)).isCount())
			{
				objects = new BasicEList();
				rs.absolute(1);
				Integer id = new Integer(rs.getInt(i+1));
				objects.add(id);
			}
			else
			{
				objects = new IndirectedList(helper,dbMap,cache,query,s,resourceSet,notLoadedClasses,rs,i);
			}
			ResultEntry resultEntry = ExtensionsFactory.eINSTANCE.createResultEntry();
			resultEntry.setValue(objects);
			queryResult.getResultEntries().add(resultEntry);
			
		}
		
		return queryResult;
	}
	/**
	 * @return
	 */
	protected String getCorrelatedCBECommonBaseEvents() {
		SQLStatement st = new SimpleSearchQueryStatement(helper,dbMap,query) {
			/* (non-Javadoc)
			 * @see org.eclipse.hyades.resources.database.internal.impl.SimpleSearchQueryStatement#processOutputElementsInSelectFrom()
			 */
			protected void processOutputElementsInSelectFrom() {
				statement.append("SELECT DISTINCT CBECommonBaseEvent.id, CBECommonBaseEvent.creationTime+P.deltaTime AS ct");
				first = false;
				all = false;
				processedAlready.add(getOperandType((SimpleOperand)this.query.getOutputElements().get(0)));
				super.processOutputElementsInSelectFrom();
			}
			/* (non-Javadoc)
			 * @see org.eclipse.hyades.resources.database.internal.impl.SimpleSearchQueryStatement#processFromSet()
			 */
			protected void processFromSet() {
				statement.append(" FROM CBECommonBaseEvent,CorrelationEntry AS K,CorrelationEntry_value AS V, Correlation_Params AS P");
				processedAlready.add("CBECommonBaseEvent");
				first = false;
				super.processFromSet();
			}
			/**
			 * 
			 */
			protected void processWhereExpressions() {
				statement.append(" WHERE K.correlationContainer="+getCorrelationContainerID()+" AND K.id = V.Source_Id AND (CBECommonBaseEvent.id = K.key OR CBECommonBaseEvent.id = V.Target_Id ) AND CBECommonBaseEvent.p_p=P.agentPath AND P.correlationContainer="+getCorrelationContainerID());
				first=false;
				super.processWhereExpressions();
			}
			
			/* (non-Javadoc)
			 * @see org.eclipse.hyades.resources.database.internal.impl.SimpleSearchQueryStatement#processOrderByExpressionsInOrderByClause()
			 */
			protected void processOrderByExpressionsInOrderByClause() {
				statement.append(" ORDER BY ct");
				first=false;
				super.processOrderByExpressionsInOrderByClause();
			}
			
			/* (non-Javadoc)
			 * @see org.eclipse.hyades.resources.database.internal.impl.SimpleSearchQueryStatement#appendWhereClauseForSources()
			 */
			protected void appendWhereClauseForSources() {
				// NOP
			}
			
		};
		return st.getStatement();
		
	}
	
	/**
	 * @return
	 */
	protected int getCorrelationContainerID() {
		if(correlationContainerID==-1)
		{
			DBCommand command = DBCommandFactory.INSTANCE.createGetIdByURICommand(helper, dbMap, query.getCorrelationContainerURI());
			try {
				correlationContainerID = ((Integer) command.execute()).intValue();
			} catch (Exception e) {
				throw new DBCollectedExceptions(e);
			}
		}
		return correlationContainerID;
	}
	protected String getInboundCorrelationEntries() {
		SQLStatement st = new SimpleSearchQueryStatement(helper,dbMap,query) {
			/* (non-Javadoc)
			 * @see org.eclipse.hyades.resources.database.internal.impl.SimpleSearchQueryStatement#processOutputElementsInSelectFrom()
			 */
			protected void processOutputElementsInSelectFrom() {
				statement.append("SELECT C2.id,C1.id");
				first = false;
				all = false;
				processedAlready.add(getOperandType((SimpleOperand)this.query.getOutputElements().get(0)));
				processedAlready.add(getOperandType((SimpleOperand)this.query.getOutputElements().get(1)));
				super.processOutputElementsInSelectFrom();
			}
			/* (non-Javadoc)
			 * @see org.eclipse.hyades.resources.database.internal.impl.SimpleSearchQueryStatement#processFromSet()
			 */
			protected void processFromSet() {
				statement.append(" FROM CBECommonBaseEvent AS C1,CBECommonBaseEvent AS C2,CorrelationEntry AS K,CorrelationEntry_value AS V, Correlation_Params AS P");
				processedAlready.add("CBECommonBaseEvent");
				first = false;
				super.processFromSet();
			}
			/**
			 * 
			 */
			protected void processWhereExpressions() {
				statement.append(" WHERE K.correlationContainer="+getCorrelationContainerID()+" AND K.id = V.Source_Id AND C1.id = K.key AND C2.id = V.Target_Id AND P.correlationContainer="+getCorrelationContainerID()+" AND C2.p_p=P.agentPath");
				first=false;
				super.processWhereExpressions();
			}
			
			/* (non-Javadoc)
			 * @see org.eclipse.hyades.resources.database.internal.impl.SimpleSearchQueryStatement#processOrderByExpressionsInOrderByClause()
			 */
			protected void processOrderByExpressionsInOrderByClause() {
				statement.append(" ORDER BY C2.creationTime+P.deltaTime");
				first=false;
				super.processOrderByExpressionsInOrderByClause();
			}
			
			/* (non-Javadoc)
			 * @see org.eclipse.hyades.resources.database.internal.impl.SimpleSearchQueryStatement#appendWhereClauseForSources()
			 */
			protected void appendWhereClauseForSources() {
				// NOP
			}
			
		};
		return st.getStatement();
	}

	protected String getOutboundCorrelationEntries() {
		SQLStatement st = new SimpleSearchQueryStatement(helper,dbMap,query) {
			/* (non-Javadoc)
			 * @see org.eclipse.hyades.resources.database.internal.impl.SimpleSearchQueryStatement#processOutputElementsInSelectFrom()
			 */
			protected void processOutputElementsInSelectFrom() {
				statement.append("SELECT C1.id,C2.id");
				first = false;
				all = false;
				processedAlready.add(getOperandType((SimpleOperand)this.query.getOutputElements().get(0)));
				processedAlready.add(getOperandType((SimpleOperand)this.query.getOutputElements().get(1)));
				super.processOutputElementsInSelectFrom();
			}
			/* (non-Javadoc)
			 * @see org.eclipse.hyades.resources.database.internal.impl.SimpleSearchQueryStatement#processFromSet()
			 */
			protected void processFromSet() {
				statement.append(" FROM CBECommonBaseEvent AS C1,CBECommonBaseEvent AS C2,CorrelationEntry AS K,CorrelationEntry_value AS V, Correlation_Params AS P");
				processedAlready.add("CBECommonBaseEvent");
				first = false;
				super.processFromSet();
			}
			/**
			 * 
			 */
			protected void processWhereExpressions() {
				statement.append(" WHERE K.correlationContainer="+getCorrelationContainerID()+" AND K.id = V.Source_Id AND C1.id = K.key AND C2.id = V.Target_Id AND P.correlationContainer="+getCorrelationContainerID()+" AND C1.p_p=P.agentPath");
				first=false;
				super.processWhereExpressions();
			}
			
			/* (non-Javadoc)
			 * @see org.eclipse.hyades.resources.database.internal.impl.SimpleSearchQueryStatement#processOrderByExpressionsInOrderByClause()
			 */
			protected void processOrderByExpressionsInOrderByClause() {
				statement.append(" ORDER BY C1.creationTime+P.deltaTime");
				first=false;
				super.processOrderByExpressionsInOrderByClause();
			}
			
			/* (non-Javadoc)
			 * @see org.eclipse.hyades.resources.database.internal.impl.SimpleSearchQueryStatement#appendWhereClauseForSources()
			 */
			protected void appendWhereClauseForSources() {
				// NOP
			}
			
		};
		return st.getStatement();
	}
	
	/**
	 * @return
	 */
	protected List createCorrelation() {		
		StringBuffer statement = new StringBuffer();
		List statements = new ArrayList();
		String containerURI = query.getCorrelationContainerURI();
		updateCorrelationContainer();

		statement.append("ALTER SEQUENCE id_sequence RESTART WITH "+(getCorrelationContainerID()+1));
		statements.add(statement.toString());
		statement.setLength(0);
		
		statement.append("INSERT INTO ");
		statement.append("RESOURCE_TABLE VALUES (");
		statement.append("'"+getContainerResourceURI(containerURI)+"'");
		statement.append(",'CorrelationContainer',"+getCorrelationContainerID()+")");
		
		statements.add(statement.toString());
		statement.setLength(0);

		statement.append("INSERT INTO CORRELATIONCONTAINER VALUES ('/',"+getCorrelationContainerID()+",0,'0')");		
		statements.add(statement.toString());
		statement.setLength(0);

		appendInsertParams(statement);
		statements.add(statement.toString());
		statement.setLength(0);
		
		statement.append("INSERT INTO Correlation_Temp SELECT "+getCorrelationContainerID()+",id, creationTime+B.deltaTime AS ct FROM CBECommonBaseEvent AS A, Correlation_Params AS B WHERE A.p_p=B.agentPath AND B.correlationContainer="+getCorrelationContainerID());
		statements.add(statement.toString());
		statement.setLength(0);

		statement.append("INSERT INTO CorrelationEntry (p_p,id,correlationContainer,key) ");
		statement.append(" SELECT '"+getCorrelationContainerID()+"/', NEXTVAL FOR id_sequence,"+getCorrelationContainerID()+",A.Id FROM (select distinct S.objId as id from Correlation_Temp AS S, Correlation_Temp AS T WHERE S.correlationContainer="+getCorrelationContainerID()+" and T.correlationContainer="+getCorrelationContainerID()+" and S.objId<T.objId AND S.creationTime=T.creationTime) as A");
		statements.add(statement.toString());
		statement.setLength(0);

		statement.append("INSERT INTO CorrelationEntry_Value (Source_Id,Target_Id)"); 
		statement.append(" SELECT CE.id,idT FROM CorrelationEntry as CE,(select distinct S.objId as idS, T.objId as idT from Correlation_Temp AS S, Correlation_Temp AS T WHERE S.correlationContainer="+getCorrelationContainerID()+" and T.correlationContainer="+getCorrelationContainerID()+" and S.objId<T.objId AND S.creationTime=T.creationTime) as A where CE.key=A.idS and CE.correlationContainer="+getCorrelationContainerID());
		statements.add(statement.toString());
		statement.setLength(0);

		statement.append("DELETE FROM Correlation_Temp WHERE correlationContainer="+getCorrelationContainerID());
		statements.add(statement.toString());
		statement.setLength(0);
		return statements;
	}
	/**
	 * @param containerURI
	 * @return
	 */
	private String getContainerResourceURI(String uri) {
		int i = uri.indexOf('#');
		if(i!=-1)
			uri=uri.substring(0,i);
		return uri;
	}
	/**
	 * 
	 */
	private void updateCorrelationContainer() {
		try {
			DBCommand command = DBCommandFactory.INSTANCE.createGetLargestDatabaseId(helper, dbMap);
			Integer id = (Integer) command.execute();
			correlationContainerID = id == null ? -1 : id.intValue();
//			if(correlationContainerID!=-1)
//			{
//				command = DBCommandFactory.INSTANCE.createUpdateLargestDatabaseId(helper, dbMap, correlationContainerID);
//				command.execute();
//			}
		} catch (Exception e) {
			new DBCollectedExceptions(e);
		}
	}
	/**
	 * @param statement
	 */
	protected void appendInsertParams(StringBuffer statement) {
		boolean first = true;
		for (int i=0;i<query.getSources().size(); i++) {
			String element = (String) query.getSources().get(i);
			String currentAgentPath = getObjectCompressedURIFragment(element);
			double currentDeltaTime = getDeltaTime(i);
			if(first)
			{
				statement.append("INSERT INTO Correlation_Params VALUES ");
				first=false;
			}
			else
			{
				statement.append(',');
			}
			statement.append("("+getCorrelationContainerID()+",'"+currentAgentPath+"',"+currentDeltaTime+")");
		}
	}
	/**
	 * @param currentAgentPath
	 * @return
	 */
	private double getDeltaTime(int i) {
		if(query.getDeltaTime().size()>i)
			return ((Double)query.getDeltaTime().get(i)).doubleValue();
		return 0;
	}
	protected String getObjectCompressedURIFragment(String source) {
		DBCommand command = DBCommandFactory.INSTANCE.createGetCommpressedPathByURICommand(helper, dbMap, source);
		String s = "";
		try {
			s = (String) command.execute();
		} catch (Exception e) {
			new DBCollectedExceptions(e);
		}
		return s;
	}


}
