/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TypeMapImpl.java,v 1.4 2005/02/16 22:21:32 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.Types;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.hyades.resources.database.internal.TypeMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.StringType;
/**
 * This class implements the TypeMap interface.
 */
public class TypeMapImpl implements TypeMap {
	protected static final int NO_MAP_TYPE = -999;
	protected static final int DEFAULT_VARCHAR_LENGTH = 160;
	protected static final int DEFAULT_ID_TYPE = Types.INTEGER;

	protected Map ecoreToSQL;
	protected int varCharLength;
	protected int idType;
	protected Map attributesToSQL;

	/**
	 * Constructor for TypeMapImpl.
	 */
	public TypeMapImpl() {
		super();
		varCharLength = DEFAULT_VARCHAR_LENGTH;
		idType = Types.INTEGER;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.TypeMap#add(String, int)
	 */
	public void add(String ecoreDatatype, int sqlType) {
		if (ecoreToSQL == null)
			ecoreToSQL = new HashMap();

		ecoreToSQL.put(ecoreDatatype, new Integer(sqlType));
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.TypeMap#getSQLType(String)
	 */
	public int getSQLType(String ecoreDatatype) {
		if (ecoreToSQL == null)
			return NO_MAP_TYPE;

		Integer type = (Integer) ecoreToSQL.get(ecoreDatatype);

		if (type == null)
			return NO_MAP_TYPE;
		else
			return type.intValue();
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.TypeMap#getVarCharLength()
	 */
	public int getVarCharLength() {
		return varCharLength;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.TypeMap#setVarCharLength(int)
	 */
	public void setVarCharLength(int length) {
		varCharLength = length;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.TypeMap#getIdType()
	 */
	public int getIdType() {
		return idType;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.TypeMap#setIdType(int)
	 */
	public void setIdType(int type) {
		idType = type;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.TypeMap#add(org.eclipse.emf.ecore.EAttribute,
	 *      int)
	 */
	public void add(EAttribute attribute, int sqlType) {
		if (attributesToSQL == null)
			attributesToSQL = new HashMap();

		attributesToSQL.put(attribute, new Integer(sqlType));
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.TypeMap#add(org.eclipse.emf.ecore.EAttribute,
	 *      org.eclipse.hyades.resources.database.internal.dbmodel.StringType)
	 */
	public void add(EAttribute attribute, StringType type) {
		if (attributesToSQL == null)
			attributesToSQL = new HashMap();

		attributesToSQL.put(attribute, type);
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.TypeMap#getSQLType(org.eclipse.emf.ecore.EAttribute)
	 */
	public Object getSQLType(EAttribute attribute) {
		if (attributesToSQL == null)
			return null;
		else
			return attributesToSQL.get(attribute);
	}
} // TypeMapImpl
