/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: UpdateReferenceStatement.java,v 1.4 2005/02/16 22:21:32 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.List;

import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Constraint;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
/**
 * Generates an UPDATE statement to set a reference value.
 */
public class UpdateReferenceStatement extends SQLStatement {
	protected Integer sourceId, targetId;
	protected EReference reference;
	protected int position;
	protected Column source, target;

	public UpdateReferenceStatement(DatabaseType dbType,DBMap map, Integer sourceId, EReference reference, Integer targetId, int position) {
		super(dbType,map);
		this.sourceId = sourceId;
		this.targetId = targetId;
		this.reference = reference;
		this.position = position;
	}

	public String getStatement() {
		StringBuffer buffer = new StringBuffer();
		DBMap.ReferenceData data = (DBMap.ReferenceData) dbMap.getDBRepresentation(reference);
		setSourceAndTarget(data);
		buffer.append("UPDATE ");
		buffer.append(addQuotes(data.getTable().getName()));
		buffer.append(" SET ");
		buffer.append(addQuotes(target.getName()));
		buffer.append(" = ");
		buffer.append(targetId);

		if (data.getOrderColumn() != null) {
			buffer.append(", ");
			buffer.append(addQuotes(data.getOrderColumn().getName()));
			buffer.append(" = ");
			buffer.append(position);
		}

		buffer.append(" WHERE ");
		buffer.append(addQuotes(source.getName()));
		buffer.append(" = ");
		buffer.append(sourceId);

		return buffer.toString();
	}

	/**
	 * Set target to be the column that is NOT a primary key column for the
	 * table.
	 */
	protected void setSourceAndTarget(DBMap.ReferenceData data) {
		source = data.getSourceColumn();
		target = data.getTargetColumn();

		if (isPrimaryKey(target)) {
			Column temp = target;
			target = source;
			source = temp;
			Integer temp2 = targetId;
			targetId = sourceId;
			sourceId = temp2;
		}
	}

	protected boolean isPrimaryKey(Column column) {
		List constraints = column.getConstraints();

		for (int i = 0, l = constraints.size(); i < l; i++) {
			Constraint constraint = (Constraint) constraints.get(i);

			if (RDBHelper.PRIMARY_KEY_TYPE.equals(constraint.getType()))
				return true;
		}

		return false;
	}
} // UpdateReferenceStatement
