/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolDeleteColumnDialog.java,v 1.6 2005/02/16 22:22:16 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.dialog;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.DatapoolUtil;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

/**
 * @author psun
 *
 */
public class DatapoolDeleteColumnDialog extends DatapoolBaseDialog implements SelectionListener
{
	private static final String TAG_VARIABLES = "variables"; //$NON-NLS-1$
		
	//private static final int HEIGHT = 40;
	//private static final int WIDTH = 280;
	
	private IDatapool datapool = null;
	private Combo variableCombo = null;
	private String deletionVariableID = null;
	
	/**
	 * @param parentShell
	 */
	public DatapoolDeleteColumnDialog(Shell parentShell, IDatapool datapool) 
	{
		super(parentShell);
		setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
		this.datapool = datapool;
	}
	
	/**
	 * @see org.eclipse.jface.window.Window#createContents(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createContents(Composite parent)
	{
		Control control = super.createContents(parent);
		enableOK();
		return control;
	}

	/**
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createDialogArea(Composite parent)
	{
		getShell().setText(DatapoolPlugin.getResourceString("DATA_DEL_VAR_DLG_TITLE")); //$NON-NLS-1$
		Composite superComposite = (Composite)super.createDialogArea(parent);
		GridData gridData = GridDataUtil.createFill();
		superComposite.setLayoutData(gridData);		

		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		superComposite.setLayout(gridLayout);

		Label variableLabel = new Label(superComposite, SWT.NONE);
		variableLabel.setText(DatapoolPlugin.getResourceString("DATA_DEL_VAR_DLG_SEL")); //$NON-NLS-1$

		variableCombo = new Combo(superComposite, SWT.READ_ONLY | SWT.DROP_DOWN);
		IDatapoolVariable[] variables = DatapoolUtil.getInstance().getVariables(datapool, null);
		String[] variableLabels = getVariableLabels(variables);

		gridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		variableCombo.setItems(variableLabels);
		variableCombo.setData(TAG_VARIABLES, variables);
		variableCombo.setLayoutData(gridData);
		variableCombo.addSelectionListener(this);
		
		return superComposite;
	}
	
	private boolean enableOK()
	{
		if(deletionVariableID == null)
		{
			getOKButton().setEnabled(false);
			return false;
		}
		else
		{
			getOKButton().setEnabled(true);
			return true;
		}
	}

	private String[] getVariableLabels(IDatapoolVariable[] variables)
	{
		if(variables == null)
			return null;
		int listSize = variables.length;
		String[] returnList = new String[listSize];
		for(int i = 0; i < listSize; i++)
		{
			IDatapoolVariable variable = variables[i];
			if(variable == null)
				continue;
			String name = variable.getName();			
			returnList[i] = name;
		}
		return returnList;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) 
	{
		Combo deleteVariableCombo = (Combo)e.widget;
		int selectionIndex = deleteVariableCombo.getSelectionIndex();
		IDatapoolVariable[] variables = (IDatapoolVariable[])deleteVariableCombo.getData(TAG_VARIABLES);
		if(selectionIndex >= 0 && selectionIndex < variables.length)
		{
			IDatapoolVariable variable = variables[selectionIndex];
			deletionVariableID = variable.getId();
		}
		else
		{
			deletionVariableID = new String();
		}
		enableOK();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) 
	{
		return;
	}	
	
	public String getDeletedVariableID()
	{
		return deletionVariableID;
	}
	
}
