/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Dirtiable;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBar;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBarEvent;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBarListener;

public class ModifiableVariableBar implements ZoomControlBarListener {
	SDModifiableVariableRepresentation rep;
	ZoomControlBar bar;
	Dirtiable dirtiable;
	StatConInterface statcon;
	public ModifiableVariableBar(StatConInterface statcon, ZoomControlBar bar, SDModifiableVariableRepresentation rep, Dirtiable dirtiable) {
		this.bar = bar;
		this.rep = rep;
		this.dirtiable = dirtiable;
		this.statcon = statcon;
	}
	public void zoomControlBarChanged(ZoomControlBarEvent e) {
		if (e.finished) {
			if (dirtiable != null) {
				dirtiable.setDirty(true);
			}
	
			double d = e.value;
			if (d > rep.getMaxBound()) d = rep.getMaxBound();
			if (d < rep.getMinBound()) d = rep.getMinBound();
	
			bar.setValue(d);
	
			rep.setRequestedValue(System.currentTimeMillis(),d);
			
			statcon.getGraphWindow().updateTables();
		}
	}	
}