/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.monitoractions.internal.email;

import java.util.Properties;

import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertAction;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.StatConAlertActionProvider;
import org.eclipse.jface.preference.IPreferenceStore;

public class EmailActionProvider implements StatConAlertActionProvider {
	public static final String PREFS = "STATCON_ACTION_EMAIL__";
	public static final String TO = "to";
	public static final String FROM = "from";
	public static final String HOST = "host";
	public static final String PORT = "port";
	public static final String DOMAIN = "domain";

	public String getName() {
		return EditorPlugin.getString("ALERT_ACTION_NAME_EMAIL");
	}
	public AlertAction newAlertAction() {
		return fromPreferenceStore(EditorPlugin.getDefault().getPreferenceStore());
//		return new EmailAlertAction();
	}
	
	public AlertAction fromPreferenceStore(IPreferenceStore props) {
		EmailAlertAction a = new EmailAlertAction();
		if (props.contains(PREFS+HOST)) a.host = props.getString(PREFS+HOST);
		if (props.contains(PREFS+TO)) a.recipients = props.getString(PREFS+TO);
		if (props.contains(PREFS+FROM)) a.sender = props.getString(PREFS+FROM);
		if (props.contains(PREFS+PORT)) a.port = props.getInt(PREFS+PORT);
		if (props.contains(PREFS+DOMAIN)) a.localhostDomain = props.getString(PREFS+DOMAIN);
		return a;
	}
	public void toPreferenceStore(IPreferenceStore props, AlertAction action) {
		EmailAlertAction a = (EmailAlertAction)action;
		props.setDefault(PREFS+HOST,a.host);
		props.setDefault(PREFS+TO,a.recipients);
		props.setDefault(PREFS+FROM,a.sender);
		props.setDefault(PREFS+PORT,a.port);
		props.setDefault(PREFS+DOMAIN,a.localhostDomain);
	}
	
	public AlertAction fromProperties(Properties props) {
		EmailAlertAction a = new EmailAlertAction();
		a.host = props.getProperty(PREFS+HOST);
		a.recipients = props.getProperty(PREFS+TO);
		a.sender = props.getProperty(PREFS+FROM);
		try {
			a.port = Integer.parseInt(props.getProperty(PREFS+PORT));
		} catch (Exception e) {}
		a.localhostDomain = props.getProperty(PREFS+DOMAIN);
		return a;
	}
	public void toProperties(Properties props, AlertAction action) {
		EmailAlertAction a = (EmailAlertAction)action;
		props.setProperty(PREFS+HOST,a.host);
		props.setProperty(PREFS+TO,a.recipients);
		props.setProperty(PREFS+FROM,a.sender);
		props.setProperty(PREFS+PORT,""+a.port);
		props.setProperty(PREFS+DOMAIN,a.localhostDomain);
	}
}

