/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.monitoractions.internal.email;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertAction;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertActionControl;
import org.eclipse.swt.widgets.Composite;

public class EmailAlertAction implements AlertAction {

String host = EditorPlugin.getString("ALERT_ACTION_EMAIL_DEFAULT_SERVER");
int port = 25;
String sender = EditorPlugin.getString("ALERT_ACTION_EMAIL_DEFAULT_SENDER");
String recipients = EditorPlugin.getString("ALERT_ACTION_EMAIL_DEFAULT_RECIPIENT");
String localhostDomain = EditorPlugin.getString("ALERT_ACTION_EMAIL_DEFAULT_DOMAIN");
//String subject;
//String message;

static SimpleDateFormat sdf = new SimpleDateFormat();

boolean trigger;
String name;
double value;
double time;

	public AlertActionControl getControl(Composite c) {
		return new EmailControl(c,this);
	}
	
	public String getDescription() {
		return EditorPlugin.getString("ALERT_ACTION_NAME_EMAIL")+" ("+recipients+")";
	}
	
	public String getProviderName() {
		return EditorPlugin.getString("ALERT_ACTION_NAME_EMAIL");
	}
	public void setInformation(String name, SDSnapshotObservation obs, double value, double time, boolean trigger) {
		this.name = name;
		this.value = value;
		this.time = time;
		this.trigger = trigger;
	}
	public void run() {
		try {
			Mailer m = new Mailer(host,port);
			
			String subject;
			String message;
			if (trigger) {
				subject = sdf.format(new Date((long)time)) + " - " + EditorPlugin.getString("ALERT_ALERT")+" "+name+" "+EditorPlugin.getString("ALERT_TRIGGERED_AT")+" "+value;
			} else {
				subject = sdf.format(new Date((long)time)) + " - " + EditorPlugin.getString("ALERT_ALERT")+" "+name+" "+EditorPlugin.getString("ALERT_RESET_AT")+" "+value;
			}
			message = subject;
			
			m.send(sender,recipients,localhostDomain,subject,message);
		} catch (Exception e) {
			EditorPlugin.DBG.warning("error sending alert email "+e);
		}
	}

	public Object clone() {
		EmailAlertAction action = new EmailAlertAction();
		action.host = host;
		action.port = port;
		action.recipients = recipients;
		action.localhostDomain = localhostDomain;
		return action;
	}
}

