/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.monitoractions.internal.email;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

public class Mailer extends Object
{
	private static String EOL = "\r\n";
	
    private Socket socket;
    private DataInputStream dataInputStream;
    private PrintStream	printStream;
    
    private int     port = 25;
    private String  host = "mail";
    
    // The characters which are valid separators of email addresses
	private static char [] separators = {';', ' ', ','};
    
    public Mailer()
    {
    }

    public Mailer(String host)
    {
	    this.host = host;
    }

    public Mailer(String host, int port)
    {
	    this.host = host;
	    this.port = port;
    }
    
    public String getHost()
    {
	    return host;
    }

    public void setHost(String host)
    {
	    this.host = host;
    }

    public int getPort()
    {
	    return port;
    }

    public void setPort(int port)
    {
	    this.port = port;
    }

    public void send(String sender, String recipient, String localhostDomain, String subject, String message) throws MailerException
    {
        try
        {
        	System.out.println("Sender:"+sender);
        	System.out.println("Recipient:"+recipient);
        	System.out.println("Domain:"+localhostDomain);
        	System.out.println("Subject:"+subject);
        	System.out.println("Message:"+message);
        	
            socket          = new Socket(host, port);
            dataInputStream = new DataInputStream(socket.getInputStream());
            printStream     = new PrintStream(socket.getOutputStream());
            //greeting();
            
            response("220"); 

            printStream.print("HELO " + localhostDomain +EOL);
//            printStream.print("HELO [" + localhostDomain + "]\n");
            response("250");

            printStream.print("MAIL FROM: <" + sender + ">" +EOL);
            response("250");

            printStream.print("RCPT TO: <" + recipient + ">" +EOL);
            response("250");

            printStream.print("DATA"+EOL);
            response("354");

    	    printStream.print("To: Alert Recipient <" + recipient + ">" +EOL);
    	    printStream.print("From: Statistical Alert <" + sender + ">" +EOL);
    	    //printStream.print("Date:  " + date + EOL);
      	    printStream.print("Subject:  " + subject +EOL);
			
            printStream.print(message +EOL);
            printStream.print("."+EOL);
     	    response("250");
    		
    	    printStream.print("QUIT"+EOL);
    	    response("221");
        }
        catch(UnknownHostException e)
        {
            throw new MailerException("UnknownHostException - " + e);
        }
        catch(IOException e)
        {
            throw new MailerException("IOException - " + e);
        }
        catch (IndexOutOfBoundsException e)
        {
            throw new MailerException("Error getting qualified host name for this machine");
        }    
        
        finally
        {
            try
	        {
   		        socket.close();
       	    }   
            catch (Exception e)
            {
	        	// ignore
       	    }
        }
    }

    private void response(String expected) throws IOException, MailerException
    {
        System.out.println("Mailer waiting for response, expecting \""+expected+"\"");
        String response = dataInputStream.readLine();

//        if (expected.equals("220"))
//        {
            System.out.println("Mailer expected 220, received - \"" + response + "\"");
//        }    

        if (!response.startsWith(expected))
        {
            throw new MailerException ("Unexpected response \"" + response + "\" from server " + host);
        }
        
        while (!response.startsWith(expected + " "))
//        while (!response.startsWith(expected))
        {
            response = dataInputStream.readLine();
            
//            if (expected.equals("220"))
//            {
                System.out.println("Mailer expected 220, received - \"" + response + "\"");
//            }    

            if (!response.startsWith(expected))
            {
                throw new MailerException ("Unexpected response \"" + response + "\" from server " + host);
            }
        }    
    }
    
    public static String [] separateRecipients(String recipient)
    {
    	Vector recipientVector = new Vector();
    	boolean separating = true;
    	StringBuffer current = new StringBuffer();
    	
    	char [] chars = recipient.toCharArray();
    	
    	for (int i=0; i<chars.length; i++)
    	{
    		if (isSeparator(chars[i]))
    		{
    			if (!separating)
    			{
    				recipientVector.add(current.toString());
    				
    				current = new StringBuffer();
    			}    				
    				
    			separating = true;
    		}
    		else
    		{
   				current.append(chars[i]);
    			
  				separating = false;    			
    		}
    	}
    	
		if (!separating)
		{
			recipientVector.add(current.toString());
		}
		
		String [] recipientArray = new String[recipientVector.size()];
		
		for (int i=0; i<recipientVector.size(); i++)
		{
			recipientArray[i] = (String)recipientVector.elementAt(i);
		}
		
		return recipientArray;
    }
    
    private static boolean isSeparator(char c)
    {
    	for (int i=0; i<separators.length; i++)
    	{
    		if (c == separators[i])
    		{
    			return true;
    		}
    	}
    	
    	return false;
    }
}
