/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.monitoractions.internal.email;

import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.InvalidDataException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
/**
 * @author amiguel
 *
 */
public class PreferencePage extends org.eclipse.jface.preference.PreferencePage
		implements IWorkbenchPreferencePage {

EmailControl control;	

	/**
	 * 
	 */
	public PreferencePage() {
		super();
	}

	/**
	 * @param title
	 */
	public PreferencePage(String title) {
		super(title);
	}

	/**
	 * @param title
	 * @param image
	 */
	public PreferencePage(String title, ImageDescriptor image) {
		super(title, image);
	}

	protected Control createContents(Composite parent) {
		
		EmailActionProvider provider = new EmailActionProvider();
		EmailAlertAction action = (EmailAlertAction) provider.fromPreferenceStore(EditorPlugin.getDefault().getPreferenceStore());
		
		control = (EmailControl)action.getControl(parent);
		control.setDefaultsButtonOn(false);
		
		performDefaults();
		
		return control;
	}

	public void init(IWorkbench workbench) {
		setPreferenceStore(EditorPlugin.getDefault().getPreferenceStore());
	}
	
	protected void performDefaults() {
		EmailActionProvider provider = new EmailActionProvider();
		control.readFromAction(provider.fromPreferenceStore(EditorPlugin.getDefault().getPreferenceStore()));
	}			
	
	
	public boolean performOk()
	{
		try {
			EmailActionProvider provider = new EmailActionProvider();
			provider.toPreferenceStore(EditorPlugin.getDefault().getPreferenceStore(),control.writeToClonedAction());
			setErrorMessage(null);
		} catch (InvalidDataException e) {
			setErrorMessage(e.getMessage());
			EditorPlugin.DBG.error("Error storing email action preferences",e);
			return false;
		}

		return super.performOk();
	}

}
